/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.gml.parser.v2.features;

import java.io.IOException;
import java.util.Map;
import org.gvsig.gpe.lib.api.parser.IAttributesIterator;
import org.gvsig.gpe.prov.gml.parser.GPEDefaultGmlParser;
import org.gvsig.gpe.prov.gml.utils.GmlGeometries;
import org.gvsig.gpe.prov.gml.utils.GmlObject;
import org.gvsig.gpe.prov.gml.utils.GmlTags;
import org.gvsig.gpe.prov.gml.utils.GmlUtilsParser;
import org.gvsig.gpe.prov.xml.utils.XMLAttributesIterator;
import org.gvsig.xmlpull.lib.api.stream.IQName;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamReader;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;

public class FeatureTypeBinding {
    public Object parse(IXmlStreamReader parser, GPEDefaultGmlParser handler) throws XmlStreamException, IOException {
        boolean endFeature = false;
        Object feature = null;
        IQName featureRootType = parser.getName();
        if (parser.getEventType() != 1) {
            throw new XmlStreamException("Expected start element of feature (" + featureRootType + ").");
        }
        parser.next();
        XMLAttributesIterator attributesIterator = new XMLAttributesIterator(parser);
        String fid = this.getID(handler, attributesIterator.getAttributes());
        feature = handler.getContentHandler().startFeature(fid, featureRootType.getNamespaceURI(), GmlUtilsParser.removeBlancSymbol(featureRootType.getLocalPart()), (IAttributesIterator)attributesIterator, null);
        IQName tag = parser.getName();
        int currentTag = parser.getEventType();
        while (!endFeature) {
            switch (currentTag) {
                case 1: {
                    if (handler.getQNameComparator().equals(tag, GmlTags.GML_NAME)) {
                        parser.next();
                        handler.getContentHandler().addNameToFeature(parser.getText(), feature);
                        break;
                    }
                    if (handler.getQNameComparator().equals(tag, GmlTags.GML_DESCRIPTION)) {
                        parser.next();
                        String string = parser.getText();
                        break;
                    }
                    if (handler.getQNameComparator().equals(tag, GmlTags.GML_BOUNDEDBY)) {
                        Object bbox = handler.getProfile().getBoundedByTypeBinding().parse(parser, handler);
                        handler.getContentHandler().addBboxToFeature(bbox, feature);
                        break;
                    }
                    if (GmlGeometries.isGML(tag)) {
                        Object geometry = handler.getProfile().getGeometryBinding().parse(parser, handler);
                        handler.getContentHandler().addGeometryToFeature(geometry, feature);
                        break;
                    }
                    Object element = handler.getProfile().getElementTypeBinding().parse(parser, handler, feature, null, null);
                    handler.getContentHandler().addElementToFeature(element, feature);
                    break;
                }
                case 2: {
                    if (!handler.getQNameComparator().equals(featureRootType, tag)) break;
                    endFeature = true;
                    handler.getContentHandler().endFeature(feature);
                    break;
                }
            }
            if (endFeature) continue;
            currentTag = parser.next();
            tag = parser.getName();
        }
        return new GmlObject(feature, 1);
    }

    public String getID(GPEDefaultGmlParser handler, Map hash) {
        for (IQName name : hash.keySet()) {
            if (handler.getQNameComparator().equalsWithOutNamespace(name, GmlTags.GML_FID)) {
                return (String)hash.get(name);
            }
            if (!handler.getQNameComparator().equalsWithOutNamespace(name, GmlTags.GML_ID)) continue;
            return (String)hash.get(name);
        }
        return null;
    }
}

