/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.gml.writer;

import java.io.IOException;
import java.util.Stack;
import org.gvsig.gpe.lib.api.writer.ICoordinateSequence;
import org.gvsig.gpe.prov.gml.writer.profiles.IWriterProfile;
import org.gvsig.gpe.prov.xml.writer.GPEXmlWriterHandlerImplementor;
import org.gvsig.xmlpull.lib.api.stream.XmlStreamException;

public abstract class GPEGmlWriterHandlerImplementor
extends GPEXmlWriterHandlerImplementor {
    private boolean oneLayer = false;
    private boolean isMultiple = false;
    private boolean hasMultipleType = false;
    private Stack currentFeature = new Stack();
    private Stack currentElement = new Stack();
    private boolean isInitialized = false;
    private IWriterProfile profile = null;

    public void initialize() {
        super.initialize();
        try {
            this.initPrefixes();
        }
        catch (XmlStreamException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void close() {
        try {
            this.writer.flush();
            this.writer.close();
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startLayer(String id, String namespace, String name, String description, String srs) {
        try {
            this.getProfile().getFeatureCollectionWriter().start(this.writer, this, id, namespace, name);
            this.writer.writeEndAttributes();
            this.getProfile().getNameWriter().write(this.writer, this, name);
            this.getProfile().getDescriptionWriter().write(this.writer, this, description);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    protected void initPrefixes() throws XmlStreamException {
        this.writer.setPrefix("http://www.w3.org/2000/xmlns/", "xmlns");
        this.writer.setPrefix("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        this.writer.setPrefix("gml", "http://www.opengis.net/gml");
        this.writer.setPrefix(this.getGpeManager().getStringProperty("namespacePrefix"), this.getGpeManager().getStringProperty("namespaceURI"));
    }

    public void endLayer() {
        try {
            this.writer.writeEndElement();
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startFeature(String id, String namespace, String name) {
        this.currentFeature.push(name);
        try {
            this.profile.getFeatureMemberWriter().start(this.writer, this, id, namespace, name);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endFeature() {
        try {
            this.profile.getFeatureMemberWriter().end(this.writer, this, (String)this.currentFeature.pop(), this.getTargetNamespacePrefix());
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startElement(String namespace, String name, Object value) {
        this.currentElement.push(name);
        try {
            this.profile.getElementWriter().start(this.writer, this, namespace, name, value);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endElement() {
        try {
            this.profile.getElementWriter().end(this.writer, this, (String)this.currentElement.pop(), this.getTargetNamespacePrefix());
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startPoint(String id, ICoordinateSequence coords, String srs) {
        try {
            if (this.isMultiple) {
                if (this.hasMultipleType) {
                    this.profile.getGeometryMemberWriter().startPoint(this.writer, this, id, srs);
                    this.profile.getPointWriter().start(this.writer, this, id, coords, srs);
                } else {
                    this.profile.getPointMemberWriter().start(this.writer, this, id, coords, srs);
                }
            } else {
                this.profile.getPointWriter().start(this.writer, this, id, coords, srs);
            }
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endPoint() {
        try {
            if (this.isMultiple) {
                if (this.hasMultipleType) {
                    this.profile.getPointWriter().end(this.writer, this);
                    this.profile.getGeometryMemberWriter().end(this.writer, this);
                } else {
                    this.profile.getPointMemberWriter().end(this.writer, this);
                }
            } else {
                this.profile.getPointWriter().end(this.writer, this);
            }
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startLineString(String id, ICoordinateSequence coords, String srs) {
        try {
            if (this.isMultiple) {
                if (this.hasMultipleType) {
                    this.profile.getGeometryMemberWriter().startPoint(this.writer, this, id, srs);
                    this.profile.getLineStringWriter().start(this.writer, this, id, coords, srs);
                } else {
                    this.profile.getLineStringMemeberWriter().start(this.writer, this, id, coords, srs);
                }
            } else {
                this.profile.getLineStringWriter().start(this.writer, this, id, coords, srs);
            }
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endLineString() {
        try {
            if (this.isMultiple) {
                if (this.hasMultipleType) {
                    this.profile.getLineStringWriter().end(this.writer, this);
                    this.profile.getGeometryMemberWriter().end(this.writer, this);
                } else {
                    this.profile.getLineStringMemeberWriter().end(this.writer, this);
                }
            } else {
                this.profile.getLineStringWriter().end(this.writer, this);
            }
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startBbox(String id, ICoordinateSequence coords, String srs) {
        try {
            this.profile.getBoundedByWriter().start(this.writer, this, id, coords, srs);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endBbox() {
        try {
            this.profile.getBoundedByWriter().end(this.writer, this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startLinearRing(String id, ICoordinateSequence coords, String srs) {
        try {
            this.profile.getLinearRingWriter().start(this.writer, this, id, coords, srs);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endLinearRing() {
        try {
            this.profile.getLinearRingWriter().end(this.writer, this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startPolygon(String id, ICoordinateSequence coords, String srs) {
        try {
            if (this.isMultiple) {
                if (this.hasMultipleType) {
                    this.profile.getGeometryMemberWriter().startPoint(this.writer, this, id, srs);
                    this.profile.getPolygonWriter().start(this.writer, this, id, coords, srs);
                } else {
                    this.profile.getPolygonMemberWriter().start(this.writer, this, id, coords, srs);
                }
            } else {
                this.profile.getPolygonWriter().start(this.writer, this, id, coords, srs);
            }
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endPolygon() {
        try {
            if (this.isMultiple) {
                if (this.hasMultipleType) {
                    this.profile.getPolygonWriter().end(this.writer, this);
                    this.profile.getGeometryMemberWriter().end(this.writer, this);
                } else {
                    this.profile.getPolygonMemberWriter().end(this.writer, this);
                }
            } else {
                this.profile.getPolygonWriter().end(this.writer, this);
            }
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startInnerBoundary(String id, ICoordinateSequence coords, String srs) {
        try {
            this.profile.getInnerBoundaryIsWriter().start(this.writer, this, coords);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endInnerBoundary() {
        try {
            this.profile.getInnerBoundaryIsWriter().end(this.writer, this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startMultiPoint(String id, String srs) {
        this.isMultiple = true;
        try {
            this.profile.getMultiPointWriter().start(this.writer, this, id, srs);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endMultiPoint() {
        this.isMultiple = false;
        try {
            this.profile.getMultiPointWriter().end(this.writer, this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startMultiGeometry(String id, String srs) {
        this.isMultiple = true;
        this.hasMultipleType = true;
        try {
            this.profile.getMultiGeometryWriter().start(this.writer, this, id, srs);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endMultiGeometry() {
        this.isMultiple = false;
        this.hasMultipleType = false;
        try {
            this.profile.getMultiGeometryWriter().end(this.writer, this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startMultiLineString(String id, String srs) {
        this.isMultiple = true;
        try {
            this.profile.getMultiLineStringWriter().start(this.writer, this, id, srs);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endMultiLineString() {
        this.isMultiple = false;
        try {
            this.profile.getMultiLineStringWriter().end(this.writer, this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void startMultiPolygon(String id, String srs) {
        this.isMultiple = true;
        try {
            this.profile.getMultiPolygonWriter().start(this.writer, this, id, srs);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public void endMultiPolygon() {
        this.isMultiple = false;
        try {
            this.profile.getMultiPolygonWriter().end(this.writer, this);
        }
        catch (IOException e) {
            this.getErrorHandler().addError((Throwable)e);
        }
    }

    public IWriterProfile getProfile() {
        return this.profile;
    }

    public void setProfile(IWriterProfile profile) {
        this.profile = profile;
    }

    public String getFileExtension() {
        return "gml";
    }
}

