/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.prov.gml.writer.v2.geometries;

import java.io.IOException;
import org.gvsig.gpe.prov.gml.utils.GmlProjectionFactory;
import org.gvsig.gpe.prov.gml.utils.GmlTags;
import org.gvsig.gpe.prov.gml.writer.GPEGmlWriterHandlerImplementor;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamWriter;

public abstract class GeometryWriter {
    public void start(IXmlStreamWriter writer, GPEGmlWriterHandlerImplementor handler, String id, String srs) throws IOException {
        writer.writeStartElement("http://www.opengis.net/gml", this.getGeometryName());
        if (id != null) {
            writer.writeStartAttribute(GmlTags.GML_GID);
            writer.writeValue(id);
        }
        if (srs != null) {
            writer.writeStartAttribute(GmlTags.GML_SRS_NAME);
            writer.writeValue(GmlProjectionFactory.fromGPEToGML(srs, handler.getErrorHandler()));
        }
        writer.writeEndAttributes();
    }

    public abstract String getGeometryName();

    public void end(IXmlStreamWriter writer, GPEGmlWriterHandlerImplementor handler) throws IOException {
        writer.writeEndElement();
    }
}

