/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldsupport.sld.symbol.misc;

import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.sldsupport.sld.filter.expression.SLDExpression;
import org.gvsig.sldsupport.sld.filter.expression.operator.SLDLiteral;
import org.gvsig.sldsupport.sld.graphic.SLDGraphic;

public class SLDStroke {
    public static final int STROKE_TYPE_SOLID = 0;
    public static final int STROKE_TYPE_GRAPHIC_FILL = 1;
    public static final int STROKE_TYPE_GRAPHIC_STROKE = 2;
    protected int strokeType = 0;
    public static DecimalFormat df = null;
    protected SLDExpression width = null;
    protected SLDExpression color = null;
    protected SLDExpression opacity = null;
    protected SLDExpression lineJoin = null;
    protected SLDExpression lineCap = null;
    protected SLDExpression dashOffset = null;
    protected List<Float> dashArray = new ArrayList<Float>();
    protected Double graphicStrokeInitialGap = null;
    protected Double graphicStrokeGap = null;
    protected SLDGraphic graphic = null;

    public SLDStroke() {
        this.setStrokeType(0);
        this.setColor(Color.BLACK);
        this.setOpacity(1.0);
        this.setWidth(1.0);
        this.setLineCap(new SLDLiteral("round"));
        this.setLineJoin(new SLDLiteral("round"));
    }

    public void setStrokeType(int t) {
        this.strokeType = t;
    }

    public int getStrokeType() {
        return this.strokeType;
    }

    public List<Float> getDashArray() {
        return this.dashArray;
    }

    public SLDExpression getWidth() {
        return this.width;
    }

    public void setWidth(SLDExpression w) {
        this.width = w;
    }

    public void setWidth(double w) {
        if (w >= 0.0) {
            this.setWidth(new SLDLiteral(df.format(w)));
        }
    }

    public SLDExpression getColor() {
        return this.color;
    }

    public void setColor(SLDExpression c) {
        this.color = c;
    }

    public void setColor(Color c) {
        if (c != null) {
            String colstr = SLDStroke.toHexadecimal(c, 6, "#");
            this.setColor(new SLDLiteral(colstr));
        }
    }

    public SLDExpression getOpacity() {
        return this.opacity;
    }

    public void setOpacity(SLDExpression o) {
        this.opacity = o;
    }

    public void setOpacity(double opa) {
        if (opa >= 0.0 && opa <= 1.0) {
            this.setOpacity(new SLDLiteral(df.format(opa)));
        }
    }

    public SLDExpression getLineJoin() {
        return this.lineJoin;
    }

    public void setLineJoin(SLDExpression j) {
        this.lineJoin = j;
    }

    public SLDExpression getLineCap() {
        return this.lineCap;
    }

    public void setLineCap(SLDExpression c) {
        this.lineCap = c;
    }

    public SLDExpression getDashOffset() {
        return this.dashOffset;
    }

    public void setDashOffset(SLDExpression doff) {
        this.dashOffset = doff;
    }

    public Double getGraphicStrokeInitialGap() {
        return this.graphicStrokeInitialGap;
    }

    public void setGraphicStrokeInitialGap(Double g) {
        this.graphicStrokeInitialGap = g;
    }

    public Double getGraphicStrokeGap() {
        return this.graphicStrokeGap;
    }

    public void setGraphicStrokeGap(Double g) {
        this.graphicStrokeGap = g;
    }

    public SLDGraphic getGraphic() {
        if (this.strokeType == 0) {
            return null;
        }
        return this.graphic;
    }

    public void setGraphic(SLDGraphic g) {
        this.graphic = g;
    }

    public static String toHexadecimal(Color co, int length, String prefix) {
        if (co == null) {
            return null;
        }
        int v = (co.getRed() << 16) + (co.getGreen() << 8) + co.getBlue();
        String resp = Integer.toHexString(v);
        int len = resp.length();
        for (int i = 0; i < length - len; ++i) {
            resp = "0" + resp;
        }
        resp = resp.substring(resp.length() - length);
        if (prefix != null) {
            resp = prefix + resp;
        }
        return resp;
    }

    static {
        DecimalFormatSymbols dformater_rules = new DecimalFormatSymbols();
        dformater_rules.setDecimalSeparator('.');
        df = new DecimalFormat("##########.0##########", dformater_rules);
    }
}

