/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.buffer.impl.histogram.textincreaser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.gvsig.raster.swing.buffer.impl.histogram.textincreaser.TextIncreaserEvent;
import org.gvsig.raster.swing.buffer.impl.histogram.textincreaser.TextIncreaserListener;

public class TextIncreaserContainer
extends JPanel
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 7570162018139822874L;
    private ArrayList actionCommandListeners = new ArrayList();
    private JTextField tText = null;
    private JPanel pButtons = null;
    private JButton bmas = null;
    private JButton bmenos = null;
    private JPanel pGeneral = null;
    private double minValue = 0.0;
    private double maxValue = 100.0;
    private double value = 0.0;
    private boolean isRight = true;
    private boolean bDoCallListeners = true;
    private static int eventId = Integer.MIN_VALUE;

    public TextIncreaserContainer(int width, double minValue, double maxValue, double init, boolean right) {
        this.getTText().setPreferredSize(new Dimension(width - 25, (int)this.getTText().getPreferredSize().getHeight()));
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.isRight = right;
        this.setValue(init);
        this.initialize();
    }

    private void initialize() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setHgap(0);
        flowLayout.setVgap(0);
        FlowLayout flowLayout5 = new FlowLayout();
        flowLayout5.setHgap(0);
        flowLayout5.setVgap(0);
        this.setLayout(flowLayout5);
        this.add((Component)this.getPGeneral(), null);
    }

    public void setValue(double value) {
        this.value = value;
        this.getTText().setText(Double.toString(value));
    }

    public double getValue() {
        return this.value;
    }

    private JTextField getTText() {
        if (this.tText == null) {
            this.tText = new JTextField();
            this.tText.setText(Double.toString(this.value));
            this.tText.setPreferredSize(new Dimension(45, (int)this.tText.getPreferredSize().getHeight()));
            this.tText.setHorizontalAlignment(4);
            this.tText.addKeyListener(this);
        }
        return this.tText;
    }

    private JPanel getPButtons() {
        if (this.pButtons == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 0;
            this.pButtons = new JPanel();
            this.pButtons.setLayout(new GridBagLayout());
            this.pButtons.add((Component)this.getBmas(), gridBagConstraints2);
            this.pButtons.add((Component)this.getBmenos(), gridBagConstraints3);
        }
        return this.pButtons;
    }

    private JButton getBmas() {
        if (this.bmas == null) {
            this.bmas = new JButton();
            this.bmas.setPreferredSize(new Dimension(16, (int)this.getTText().getPreferredSize().getHeight() / 2));
            this.bmas.addActionListener(this);
            this.bmas.setIcon(new ImageIcon(this.getClass().getResource("mas.png")));
        }
        return this.bmas;
    }

    private JButton getBmenos() {
        if (this.bmenos == null) {
            this.bmenos = new JButton();
            this.bmenos.setPreferredSize(new Dimension(16, (int)this.getTText().getPreferredSize().getHeight() / 2));
            this.bmenos.addActionListener(this);
            this.bmenos.setIcon(new ImageIcon(this.getClass().getResource("menos.png")));
        }
        return this.bmenos;
    }

    private JPanel getPGeneral() {
        if (this.pGeneral == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            if (this.isRight) {
                gridBagConstraints1.gridx = 1;
                gridBagConstraints.gridx = 0;
            } else {
                gridBagConstraints1.gridx = 0;
                gridBagConstraints.gridx = 1;
            }
            gridBagConstraints.gridy = 0;
            gridBagConstraints1.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            this.pGeneral = new JPanel();
            this.pGeneral.setLayout(new GridBagLayout());
            this.pGeneral.add((Component)this.getTText(), gridBagConstraints);
            this.pGeneral.add((Component)this.getPButtons(), gridBagConstraints1);
        }
        return this.pGeneral;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bmas) {
            this.value += 1.0;
            this.checkValues();
        }
        if (e.getSource() == this.bmenos) {
            this.value -= 1.0;
            this.checkValues();
        }
        this.callValueChangedListeners();
    }

    public void addValueChangedListener(TextIncreaserListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void removeValueChangedListener(TextIncreaserListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    private void callValueChangedListeners() {
        if (!this.bDoCallListeners) {
            return;
        }
        for (TextIncreaserListener listener : this.actionCommandListeners) {
            listener.actionValueChanged(new TextIncreaserEvent(this));
        }
        ++eventId;
    }

    private void checkValues() {
        if (this.value >= this.maxValue) {
            this.value = this.maxValue;
        }
        if (this.value <= this.minValue) {
            this.value = this.minValue;
        }
        this.getTText().setText(Double.toString(this.value));
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            try {
                this.value = Double.parseDouble(this.getTText().getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.checkValues();
            this.callValueChangedListeners();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

