/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.buffer;

import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.geoprocess.algorithm.buffer.IDistance;

public abstract class AbstractDistance
implements IDistance {
    public static final double EARTH_RADIUS = 6378137.0;
    protected int numberOfRings = 1;
    protected Feature feature = null;

    @Override
    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    private double toSexaAngularMeasure(double dist) {
        return Math.toDegrees(Math.PI * 2 * dist / 6378137.0);
    }

    protected double getInInternalUnits(double userEntryDistance, IProjection proj, int distanceUnits, int mapUnits) {
        if (proj != null && !proj.isProjected()) {
            return userEntryDistance / 111352.0;
        }
        return userEntryDistance;
    }

    @Override
    public void setNumberOfRings(int n) {
        this.numberOfRings = n;
    }
}

