/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.buffer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import es.unex.sextante.core.Sextante;
import java.util.ArrayList;
import java.util.Stack;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.algorithm.base.util.JTSFacade;
import org.gvsig.geoprocess.algorithm.buffer.BufferOperation;
import org.gvsig.geoprocess.algorithm.buffer.IDistance;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;

public class InOutBufferOperation
extends BufferOperation {
    public InOutBufferOperation(IDistance distance, FeatureStore inputStore, AbstractSextanteGeoProcess p, byte tableFields) {
        super(distance, inputStore, p, tableFields);
    }

    public EditableFeature invoke(org.gvsig.fmap.geom.Geometry g, Feature feature) {
        Geometry originalGeometry;
        GeometryFactory geomFact = new GeometryFactory();
        Geometry newGeom = null;
        Geometry previousExteriorRing = null;
        Geometry previousInteriorRing = null;
        Geometry inputParam = originalGeometry = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g);
        this.distance.setFeature(feature);
        double bufferDistance = this.distance.getBufferDistance(this.projection, this.getDistanceUnits(), this.getMapUnits());
        if (originalGeometry.getDimension() != 0) {
            inputParam = TopologyPreservingSimplifier.simplify((Geometry)originalGeometry, (double)(bufferDistance / 10.0));
        }
        for (int i = 1; i <= this.numberOfRadialBuffers; ++i) {
            double distRing = (double)i * bufferDistance;
            BufferOp bufOp = new BufferOp(inputParam);
            bufOp.setEndCapStyle(this.capBuffer == 1 ? 1 : 3);
            Geometry out = bufOp.getResultGeometry(distRing);
            Geometry in = bufOp.getResultGeometry(-1.0 * distRing);
            boolean collapsedInterior = this.verifyNilGeometry(in);
            if (previousExteriorRing == null || previousInteriorRing == null) {
                newGeom = collapsedInterior ? out : JTSFacade.difference((Geometry)out, (Geometry)in);
            } else if (collapsedInterior) {
                newGeom = JTSFacade.difference((Geometry)out, previousExteriorRing);
            } else {
                Geometry outRing = JTSFacade.difference((Geometry)out, previousExteriorRing);
                Geometry inRing = JTSFacade.difference(previousInteriorRing, (Geometry)in);
                Geometry[] geomArray = new Geometry[]{outRing, inRing};
                newGeom = geomFact.createGeometryCollection(geomArray);
                ArrayList<Geometry> polygons = new ArrayList<Geometry>();
                Stack<Geometry> stack = new Stack<Geometry>();
                stack.push(newGeom);
                while (stack.size() != 0) {
                    GeometryCollection geCol = (GeometryCollection)stack.pop();
                    for (int j = 0; j < geCol.getNumGeometries(); ++j) {
                        Geometry geometry = geCol.getGeometryN(j);
                        if (geometry instanceof GeometryCollection) {
                            stack.push(geometry);
                        }
                        if (!(geometry instanceof Polygon)) continue;
                        polygons.add(geometry);
                    }
                }
                Polygon[] pols = new Polygon[polygons.size()];
                pols = polygons.toArray(pols);
                MultiPolygon newSolution = geomFact.createMultiPolygon(pols);
                newGeom = newSolution;
            }
            try {
                if (newGeom != null && !newGeom.isEmpty()) {
                    this.lastEditFeature = this.getTableFieldStructure() == 0 ? this.persister.addFeature(feature, newGeom) : this.persister.addFeature(newGeom, this.id, -1.0 * distRing, distRing);
                    ++this.id;
                }
            }
            catch (CreateGeometryException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            catch (DataException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            previousExteriorRing = out;
            if (collapsedInterior) continue;
            previousInteriorRing = in;
        }
        return this.lastEditFeature;
    }

    public void invoke(org.gvsig.fmap.geom.Geometry g, EditableFeature feature) {
        this.invoke(g, (Feature)feature);
    }
}

