/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.buffer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import es.unex.sextante.core.Sextante;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.algorithm.base.util.JTSFacade;
import org.gvsig.geoprocess.algorithm.buffer.BufferOperation;
import org.gvsig.geoprocess.algorithm.buffer.IDistance;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;

public class OutBufferOperation
extends BufferOperation {
    public OutBufferOperation(IDistance distance, FeatureStore inputStore, AbstractSextanteGeoProcess p, byte tableFields) {
        super(distance, inputStore, p, tableFields);
    }

    public EditableFeature invoke(org.gvsig.fmap.geom.Geometry g, Feature feature) {
        Geometry originalGeometry;
        Geometry newGeom = null;
        Geometry previousExteriorRing = null;
        Geometry inputParam = originalGeometry = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g);
        this.distance.setFeature(feature);
        double bufferDistance = this.distance.getBufferDistance(this.projection, this.getDistanceUnits(), this.getMapUnits());
        if (originalGeometry == null) {
            return null;
        }
        if (originalGeometry.getDimension() != 0) {
            inputParam = TopologyPreservingSimplifier.simplify((Geometry)originalGeometry, (double)(bufferDistance / 10.0));
        }
        for (int i = 1; i <= this.numberOfRadialBuffers; ++i) {
            double distRing = (double)i * bufferDistance;
            BufferOp bufOp = new BufferOp(inputParam);
            bufOp.setEndCapStyle(this.capBuffer == 1 ? 1 : 3);
            newGeom = bufOp.getResultGeometry(distRing);
            if (i == 1) {
                previousExteriorRing = newGeom;
            } else {
                Geometry complete = newGeom;
                newGeom = JTSFacade.difference((Geometry)newGeom, (Geometry)previousExteriorRing);
                previousExteriorRing = complete;
            }
            try {
                if (newGeom == null || newGeom.isEmpty()) continue;
                this.lastEditFeature = this.getTableFieldStructure() == 0 ? this.persister.addFeature(feature, newGeom) : this.persister.addFeature(newGeom, this.id, distRing);
                ++this.id;
                continue;
            }
            catch (CreateGeometryException e) {
                Sextante.addErrorToLog((Throwable)e);
                continue;
            }
            catch (DataException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        return this.lastEditFeature;
    }

    public void invoke(org.gvsig.fmap.geom.Geometry g, EditableFeature feature) {
        this.invoke(g, (Feature)feature);
    }
}

