/*
 * Decompiled with CFR 0.152.
 */
package gishur.x;

import gishur.x.XLine;
import gishur.x.XPoint;
import java.awt.Rectangle;

public class XRectangle {
    public double x;
    public double y;
    public double width;
    public double height;

    public void move(XPoint xPoint) {
        this.move(xPoint.x, xPoint.y);
    }

    public String toString() {
        return this.getClass().getName() + "[(" + this.x + "," + this.y + ")+[" + this.width + "," + this.height + "]]";
    }

    public XRectangle() {
        this.height = 0.0;
        this.width = 0.0;
        this.y = 0.0;
        this.x = 0.0;
    }

    public XRectangle(double d, double d2, double d3, double d4) {
        this.reshape(d, d2, d3, d4);
    }

    public XRectangle(XPoint xPoint, double d, double d2) {
        this.reshape(xPoint.x, xPoint.y, d, d2);
    }

    public XRectangle(XPoint xPoint, XPoint xPoint2) {
        this.reshape(Math.min(xPoint.x, xPoint2.x), Math.min(xPoint.y, xPoint2.y), Math.abs(xPoint2.x - xPoint.x) + 1.0, Math.abs(xPoint2.y - xPoint.y) + 1.0);
    }

    public XRectangle(XRectangle xRectangle) {
        this.reshape(xRectangle.x, xRectangle.y, xRectangle.width, xRectangle.height);
    }

    public XRectangle(Rectangle rectangle) {
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean inside(double d, double d2) {
        return d >= this.x && d <= this.x + this.width && d2 >= this.y && d2 <= this.y + this.height;
    }

    public boolean inside(XPoint xPoint) {
        return this.inside(xPoint.x, xPoint.y);
    }

    public void resize(double d, double d2) {
        this.reshape(this.x, this.y, d, d2);
    }

    public XRectangle intersection(XRectangle xRectangle) {
        if (this.intersects(xRectangle)) {
            XRectangle xRectangle2 = new XRectangle();
            xRectangle2.x = Math.max(this.x, xRectangle.x);
            xRectangle2.y = Math.max(this.y, xRectangle.y);
            xRectangle2.width = Math.min(this.x + this.width, xRectangle.x + xRectangle.width) - xRectangle2.x;
            xRectangle2.height = Math.min(this.y + this.height, xRectangle.y + xRectangle.height) - xRectangle2.y;
            return xRectangle2;
        }
        return null;
    }

    public int intersection(XLine xLine, XPoint xPoint, XPoint xPoint2) {
        new XPoint();
        int n = 0;
        return n;
    }

    public XRectangle union(XRectangle xRectangle) {
        XRectangle xRectangle2 = new XRectangle();
        xRectangle2.x = Math.min(this.x, xRectangle.x);
        xRectangle2.y = Math.min(this.y, xRectangle.y);
        xRectangle2.width = Math.max(this.x + this.width, xRectangle.x + xRectangle.width) - xRectangle2.x;
        xRectangle2.height = Math.max(this.y + this.height, xRectangle.y + xRectangle.height) - xRectangle2.y;
        return xRectangle2;
    }

    public void grow(double d, double d2) {
        this.reshape(this.x, this.y, this.width + d, this.height + d2);
    }

    public boolean intersects(XRectangle xRectangle) {
        return xRectangle.x >= this.x - xRectangle.width && xRectangle.x <= this.x + this.width && xRectangle.y >= this.y - xRectangle.height && xRectangle.y <= this.y + this.height;
    }

    public Object clone() {
        return new XRectangle(this);
    }

    public void move(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public void reshape(double d, double d2, double d3, double d4) {
        if (d3 < 0.0) {
            d += d3;
            d3 = -d3;
        }
        if (d4 < 0.0) {
            d2 += d4;
            d4 = -d4;
        }
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }
}

