/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver;

import com.vividsolutions.jts.geom.Geometry;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.spatial.dialect.sqlserver.convertors.Encoders;
import org.hibernate.spatial.jts.JTS;
import org.hibernate.spatial.jts.mgeom.MGeometryFactory;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;

public class SqlServer2008GeometryValueBinder
implements ValueBinder<Geometry> {
    public void bind(PreparedStatement st, Geometry value, int index, WrapperOptions options) throws SQLException {
        if (value == null) {
            st.setNull(index, 2002);
        } else {
            Geometry jtsGeom = value;
            Object dbGeom = this.toNative(jtsGeom, st.getConnection());
            st.setObject(index, dbGeom);
        }
    }

    public MGeometryFactory getGeometryFactory() {
        return JTS.getDefaultGeomFactory();
    }

    public Object toNative(Geometry geom, Connection connection) {
        if (geom == null) {
            throw new IllegalArgumentException("Null geometry passed.");
        }
        return Encoders.encode(geom);
    }
}

