/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver.convertors;

import com.vividsolutions.jts.geom.Point;
import org.hibernate.spatial.dialect.sqlserver.convertors.AbstractDecoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.OpenGisType;
import org.hibernate.spatial.dialect.sqlserver.convertors.SqlServerGeometry;
import org.hibernate.spatial.jts.mgeom.MGeometryFactory;

class PointDecoder
extends AbstractDecoder<Point> {
    public PointDecoder(MGeometryFactory factory) {
        super(factory);
    }

    @Override
    protected OpenGisType getOpenGisType() {
        return OpenGisType.POINT;
    }

    @Override
    protected Point createNullGeometry() {
        return this.getGeometryFactory().createPoint(null);
    }

    @Override
    protected Point createGeometry(SqlServerGeometry nativeGeom) {
        return this.createPoint(nativeGeom, 0);
    }

    @Override
    protected Point createGeometry(SqlServerGeometry nativeGeom, int shapeIndex) {
        if (nativeGeom.isEmptyShape(shapeIndex)) {
            return this.createNullGeometry();
        }
        int figureOffset = nativeGeom.getFiguresForShape((int)shapeIndex).start;
        int pntOffset = nativeGeom.getPointsForFigure((int)figureOffset).start;
        return this.createPoint(nativeGeom, pntOffset);
    }

    private Point createPoint(SqlServerGeometry nativeGeom, int pntOffset) {
        return this.getGeometryFactory().createPoint(nativeGeom.getCoordinate(pntOffset));
    }
}

