/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.impl;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesktopApi {
    private static Logger logger = LoggerFactory.getLogger(DesktopApi.class);

    public static boolean browse(URI uri) {
        if (DesktopApi.browseDESKTOP(uri)) {
            return true;
        }
        return DesktopApi.openSystemSpecific(uri.toString());
    }

    public static boolean open(File file) {
        if (DesktopApi.openDESKTOP(file)) {
            return true;
        }
        return DesktopApi.openSystemSpecific(file.getPath());
    }

    public static boolean edit(File file) {
        if (DesktopApi.editDESKTOP(file)) {
            return true;
        }
        return DesktopApi.openSystemSpecific(file.getPath());
    }

    private static boolean openSystemSpecific(String what) {
        EnumOS os = DesktopApi.getOs();
        if (os.isLinux() && DesktopApi.runCommand("xdg-open", "%s", what)) {
            return true;
        }
        if (os.isMac() && DesktopApi.runCommand("open", "%s", what)) {
            return true;
        }
        return os.isWindows() && DesktopApi.runCommand("explorer", "%s", what);
    }

    private static boolean browseDESKTOP(URI uri) {
        DesktopApi.logOut("Trying to use Desktop.getDesktop().browse() with " + uri.toString());
        try {
            if (!Desktop.isDesktopSupported()) {
                DesktopApi.logErr("Platform is not supported.");
                return false;
            }
            if (!Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                DesktopApi.logErr("BROWSE is not supported.");
                return false;
            }
            Desktop.getDesktop().browse(uri);
            return true;
        }
        catch (Throwable t) {
            DesktopApi.logErr("Error using desktop browse.", t);
            return false;
        }
    }

    private static boolean openDESKTOP(File file) {
        DesktopApi.logOut("Trying to use Desktop.getDesktop().open() with " + file.toString());
        try {
            if (!Desktop.isDesktopSupported()) {
                DesktopApi.logErr("Platform is not supported.");
                return false;
            }
            if (!Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                DesktopApi.logErr("OPEN is not supported.");
                return false;
            }
            Desktop.getDesktop().open(file);
            return true;
        }
        catch (Throwable t) {
            DesktopApi.logErr("Error using desktop open.", t);
            return false;
        }
    }

    private static boolean editDESKTOP(File file) {
        DesktopApi.logOut("Trying to use Desktop.getDesktop().edit() with " + file);
        try {
            if (!Desktop.isDesktopSupported()) {
                DesktopApi.logErr("Platform is not supported.");
                return false;
            }
            if (!Desktop.getDesktop().isSupported(Desktop.Action.EDIT)) {
                DesktopApi.logErr("EDIT is not supported.");
                return false;
            }
            Desktop.getDesktop().edit(file);
            return true;
        }
        catch (Throwable t) {
            DesktopApi.logErr("Error using desktop edit.", t);
            return false;
        }
    }

    private static boolean runCommand(String command, String args, String file) {
        DesktopApi.logOut("Trying to exec:\n   cmd = " + command + "\n   args = " + args + "\n   %s = " + file);
        String[] parts = DesktopApi.prepareCommand(command, args, file);
        try {
            Process p = Runtime.getRuntime().exec(parts);
            if (p == null) {
                return false;
            }
            try {
                int retval = p.exitValue();
                if (retval == 0) {
                    DesktopApi.logErr("Process ended immediately.");
                    return false;
                }
                DesktopApi.logErr("Process crashed.");
                return false;
            }
            catch (IllegalThreadStateException itse) {
                DesktopApi.logErr("Process is running.");
                return true;
            }
        }
        catch (IOException e) {
            DesktopApi.logErr("Error running command.", e);
            return false;
        }
    }

    private static String[] prepareCommand(String command, String args, String file) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(command);
        if (args != null) {
            for (String s : args.split(" ")) {
                s = String.format(s, file);
                parts.add(s.trim());
            }
        }
        return parts.toArray(new String[parts.size()]);
    }

    private static void logErr(String msg, Throwable t) {
        logger.warn(msg, t);
    }

    private static void logErr(String msg) {
        logger.warn(msg);
    }

    private static void logOut(String msg) {
        logger.info(msg);
    }

    public static EnumOS getOs() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return EnumOS.windows;
        }
        if (s.contains("mac")) {
            return EnumOS.macos;
        }
        if (s.contains("solaris")) {
            return EnumOS.solaris;
        }
        if (s.contains("sunos")) {
            return EnumOS.solaris;
        }
        if (s.contains("linux")) {
            return EnumOS.linux;
        }
        if (s.contains("unix")) {
            return EnumOS.linux;
        }
        return EnumOS.unknown;
    }

    public static enum EnumOS {
        linux,
        macos,
        solaris,
        unknown,
        windows;


        public boolean isLinux() {
            return this == linux || this == solaris;
        }

        public boolean isMac() {
            return this == macos;
        }

        public boolean isWindows() {
            return this == windows;
        }
    }
}

