/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.ui.mdiManager;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Map;
import org.gvsig.andami.PluginServices;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;
import org.gvsig.utils.NotExistInXMLEntity;
import org.gvsig.utils.XMLEntity;

public class WindowInfo
implements Persistent {
    public static final String PERSISTENCE_DEFINITION_NAME = "WindowInfo";
    public static final int RESIZABLE = 1;
    public static final int MAXIMIZABLE = 2;
    public static final int ICONIFIABLE = 4;
    public static final int MODALDIALOG = 8;
    public static final int MODELESSDIALOG = 16;
    public static final int PALETTE = 32;
    public static final int NOTCLOSABLE = 64;
    public static final Integer EDITOR_PROFILE = 1;
    public static final Integer TOOL_PROFILE = 2;
    public static final Integer PROJECT_PROFILE = 3;
    public static final Integer PROPERTIES_PROFILE = 4;
    public static final Integer DIALOG_PROFILE = 5;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean resizable = false;
    private boolean maximizable = false;
    private boolean iconifiable = false;
    private boolean modal = false;
    private boolean modeless = false;
    private boolean notclosable = false;
    private boolean persistWindow = true;
    private boolean palette = false;
    private String additionalInfo = null;
    private int width = -1;
    private int height = -1;
    private int x = -1;
    private int y = -1;
    private int normalX = 0;
    private int normalY = 0;
    private int normalHeight = -1;
    private int normalWidth = -1;
    private Dimension minSize = null;
    private boolean isMaximized = false;
    private boolean visible = true;
    private boolean isClosed = false;
    private String title;
    private int id;
    private Map selectedTools = null;
    private String defaultGroup = "unico";
    private boolean needPack = false;

    public boolean needPack() {
        return this.needPack;
    }

    public void setNeedPack(boolean needPack) {
        this.needPack = needPack;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public WindowInfo(int code) {
        this.resizable = code % 2 > 0;
        this.maximizable = (code /= 2) % 2 > 0;
        this.iconifiable = (code /= 2) % 2 > 0;
        this.modal = (code /= 2) % 2 > 0;
        this.modeless = (code /= 2) % 2 > 0;
        this.palette = (code /= 2) % 2 > 0;
        boolean bl = this.notclosable = (code /= 2) % 2 > 0;
        if (this.modal && this.modeless) {
            throw new IllegalStateException("modal && modeless");
        }
    }

    public WindowInfo() {
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.support.firePropertyChange("x", this.x, x);
        this.x = x;
        if (!this.isMaximized) {
            this.normalX = x;
        }
    }

    public void updateX(int x) {
        this.x = x;
        if (!this.isMaximized) {
            this.normalX = x;
        }
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.support.firePropertyChange("y", this.y, y);
        this.y = y;
        if (!this.isMaximized) {
            this.normalY = y;
        }
    }

    public void updateY(int y) {
        this.y = y;
        if (!this.isMaximized) {
            this.normalY = y;
        }
    }

    public boolean isIconifiable() {
        return this.iconifiable;
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public boolean isModal() {
        return this.modal;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        if (height != -1) {
            this.support.firePropertyChange("height", this.height, height);
        }
        this.height = height;
        if (!this.isMaximized) {
            this.normalHeight = height;
        }
    }

    public void updateHeight(int height) {
        this.height = height;
        if (!this.isMaximized) {
            this.normalHeight = height;
        }
    }

    public void setWidth(int w) {
        if (w != -1) {
            this.support.firePropertyChange("width", this.width, w);
        }
        this.width = w;
        if (!this.isMaximized) {
            this.normalWidth = w;
        }
    }

    public void updateWidth(int width) {
        this.width = width;
        if (!this.isMaximized) {
            this.normalWidth = width;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.support.firePropertyChange("title", this.title, title);
        this.title = title;
    }

    public void updateTitle(String title) {
        this.title = title;
    }

    public boolean isModeless() {
        return this.modeless;
    }

    public boolean isNotClosable() {
        return this.notclosable;
    }

    public void setNotClosable(boolean b) {
        this.notclosable = b;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isPalette() {
        return this.palette;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setWindowInfo(WindowInfo vi) {
        this.resizable = vi.resizable;
        this.maximizable = vi.maximizable;
        this.isMaximized = vi.isMaximized;
        this.iconifiable = vi.iconifiable;
        this.additionalInfo = vi.additionalInfo;
        this.modal = vi.modal;
        this.modeless = vi.modeless;
        this.notclosable = vi.notclosable;
        if (vi.width != -1) {
            this.width = vi.width;
        }
        if (vi.height != -1) {
            this.height = vi.height;
        }
        this.x = vi.x;
        this.y = vi.y;
        this.visible = vi.visible;
        this.title = vi.title;
        this.id = vi.id;
        if (vi.normalHeight != -1) {
            this.normalHeight = vi.normalHeight;
        }
        if (vi.normalWidth != -1) {
            this.normalWidth = vi.normalWidth;
        }
        this.normalX = vi.normalX;
        this.normalY = vi.normalY;
        this.isClosed = vi.isClosed;
        this.persistWindow = vi.persistWindow;
    }

    public void toPalette(boolean b) {
        this.palette = b;
    }

    public Map getSelectedTools() {
        return this.selectedTools;
    }

    public void setSelectedTool(String selectedTool) {
        if (selectedTool != null) {
            this.selectedTools.put(this.defaultGroup, selectedTool);
        }
    }

    public void setSelectedTools(Map selectedTools) {
        if (selectedTools != null) {
            this.selectedTools = selectedTools;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setClosed(boolean closed) {
        this.support.firePropertyChange("closed", this.isClosed, closed);
        this.isClosed = closed;
    }

    public void updateClosed(boolean closed) {
        this.isClosed = closed;
    }

    public void setNormalX(int normalX) {
        if (!this.isMaximized()) {
            this.setX(normalX);
        } else {
            this.support.firePropertyChange("normalX", this.normalX, normalX);
            this.normalX = normalX;
        }
    }

    public void updateNormalX(int normalX) {
        this.normalX = normalX;
        if (!this.isMaximized()) {
            this.x = normalX;
        }
    }

    public void setNormalY(int normalY) {
        if (!this.isMaximized()) {
            this.setY(normalY);
        } else {
            this.support.firePropertyChange("normalY", this.normalY, normalY);
            this.normalY = normalY;
        }
    }

    public void updateNormalY(int normalY) {
        this.normalY = normalY;
        if (!this.isMaximized()) {
            this.y = normalY;
        }
    }

    public void setNormalHeight(int normalHeight) {
        if (!this.isMaximized) {
            this.setHeight(normalHeight);
        } else {
            this.support.firePropertyChange("normalHeight", this.normalHeight, normalHeight);
            this.normalHeight = normalHeight;
        }
    }

    public void updateNormalHeight(int normalHeight) {
        this.normalHeight = normalHeight;
        if (!this.isMaximized) {
            this.height = normalHeight;
        }
    }

    public void setNormalWidth(int normalWidth) {
        if (!this.isMaximized()) {
            this.setWidth(normalWidth);
        } else {
            this.support.firePropertyChange("normalWidth", this.normalWidth, normalWidth);
            this.normalWidth = normalWidth;
        }
    }

    public void setMinimumSize(Dimension minSize) {
        this.support.firePropertyChange("minimumSize", this.minSize, minSize);
        this.minSize = minSize;
    }

    public void updateMinimumSize(Dimension minSize) {
        this.minSize = minSize;
    }

    public Dimension getMinimumSize() {
        return this.minSize;
    }

    public void updateNormalWidth(int normalWidth) {
        this.normalWidth = normalWidth;
        if (!this.isMaximized()) {
            this.width = normalWidth;
        }
    }

    public void setMaximized(boolean maximized) {
        this.support.firePropertyChange("maximized", this.isMaximized, maximized);
        this.isMaximized = maximized;
    }

    public void updateMaximized(boolean maximized) {
        this.isMaximized = maximized;
    }

    public void setMaximizable(boolean maximizable) {
        this.maximizable = maximizable;
    }

    private void setBounds(int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public void updateBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        if (!this.isMaximized()) {
            this.normalX = x;
            this.normalY = y;
            this.normalWidth = width;
            this.normalHeight = height;
        }
    }

    public void setNormalBounds(int x, int y, int width, int height) {
        this.setNormalX(x);
        this.setNormalY(y);
        this.setNormalWidth(width);
        this.setNormalHeight(height);
    }

    public void updateNormalBounds(int x, int y, int width, int height) {
        this.normalX = x;
        this.normalY = y;
        this.normalWidth = width;
        this.normalHeight = height;
        if (!this.isMaximized()) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }

    public Rectangle getNormalBounds() {
        return new Rectangle(this.getNormalX(), this.getNormalY(), this.getNormalWidth(), this.getNormalHeight());
    }

    public void setNormalBounds(Rectangle normalBounds) {
        this.setNormalBounds(normalBounds.x, normalBounds.y, normalBounds.width, normalBounds.height);
    }

    public void updateNormalBounds(Rectangle normalBounds) {
        this.updateNormalBounds(normalBounds.x, normalBounds.y, normalBounds.width, normalBounds.height);
    }

    public void setBounds(Rectangle bounds) {
        this.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public void updateBounds(Rectangle bounds) {
        this.updateBounds(bounds.x, bounds.y, bounds.width, bounds.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public int getNormalX() {
        if (this.normalX != 0) {
            return this.normalX;
        }
        return this.x;
    }

    public int getNormalY() {
        if (this.normalY != 0) {
            return this.normalY;
        }
        return this.y;
    }

    public int getNormalHeight() {
        if (this.normalHeight != 0) {
            return this.normalHeight;
        }
        return this.height;
    }

    public int getNormalWidth() {
        if (this.normalWidth != 0) {
            return this.normalWidth;
        }
        return this.width;
    }

    public boolean isMaximized() {
        return this.isMaximized;
    }

    public boolean checkPersistence() {
        return this.persistWindow;
    }

    public void setPersistence(boolean persist) {
        this.persistWindow = persist;
    }

    public XMLEntity getXMLEntity() {
        if (!this.checkPersistence()) {
            return null;
        }
        XMLEntity xml = new XMLEntity();
        xml.setName("ViewInfoProperties");
        xml.putProperty("X", this.getX(), false);
        xml.putProperty("Y", this.getY(), false);
        xml.putProperty("Width", this.getWidth(), false);
        xml.putProperty("Height", this.getHeight(), false);
        xml.putProperty("isVisible", this.isVisible(), false);
        xml.putProperty("isResizable", this.isResizable(), false);
        xml.putProperty("isMaximizable", this.isMaximizable(), false);
        xml.putProperty("isModal", this.isModal(), false);
        xml.putProperty("isModeless", this.isModeless(), false);
        xml.putProperty("isClosed", this.isClosed(), false);
        xml.putProperty("AdditionalInfo", this.getAdditionalInfo(), false);
        xml.putProperty("isNotClosable", this.isNotClosable(), false);
        if (this.isMaximized()) {
            xml.putProperty("isMaximized", this.isMaximized(), false);
            xml.putProperty("normalX", this.getNormalX(), false);
            xml.putProperty("normalY", this.getNormalY(), false);
            xml.putProperty("normalWidth", this.getNormalWidth(), false);
            xml.putProperty("normalHeight", this.getNormalHeight(), false);
        }
        return xml;
    }

    public static WindowInfo createFromXMLEntity(XMLEntity xml) {
        WindowInfo result = new WindowInfo();
        try {
            result.setX(xml.getIntProperty("X"));
            result.setY(xml.getIntProperty("Y"));
            result.setHeight(xml.getIntProperty("Height"));
            result.setWidth(xml.getIntProperty("Width"));
            result.setClosed(xml.getBooleanProperty("isClosed"));
            result.setAdditionalInfo(xml.getStringProperty("AdditionalInfo"));
            result.setNotClosable(xml.getBooleanProperty("isNotClosable"));
            if (xml.contains("isMaximized")) {
                boolean maximized = xml.getBooleanProperty("isMaximized");
                result.setMaximized(maximized);
                if (maximized) {
                    result.setNormalBounds(xml.getIntProperty("normalX"), xml.getIntProperty("normalY"), xml.getIntProperty("normalWidth"), xml.getIntProperty("normalHeight"));
                } else {
                    result.setNormalBounds(result.getBounds());
                }
            }
        }
        catch (NotExistInXMLEntity ex) {
            PluginServices.getLogger().warn(PluginServices.getText(null, "Window_properties_not_stored_correctly_Window_state_will_not_be_restored"));
        }
        return result;
    }

    public void getPropertiesFromXMLEntity(XMLEntity xml) {
        this.x = xml.getIntProperty("X");
        this.y = xml.getIntProperty("Y");
        this.height = xml.getIntProperty("Height");
        this.width = xml.getIntProperty("Width");
        this.isClosed = xml.getBooleanProperty("isClosed");
        this.additionalInfo = xml.getStringProperty("AdditionalInfo");
        this.notclosable = xml.getBooleanProperty("isNotClosable");
        if (xml.contains("isMaximized")) {
            boolean maximized;
            this.isMaximized = maximized = xml.getBooleanProperty("isMaximized");
            if (maximized) {
                this.setNormalBounds(xml.getIntProperty("normalX"), xml.getIntProperty("normalY"), xml.getIntProperty("normalWidth"), xml.getIntProperty("normalHeight"));
            }
        }
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("resizable", this.resizable);
        state.set("maximizable", this.maximizable);
        state.set("iconifiable", this.iconifiable);
        state.set("modal", this.modal);
        state.set("modeless", this.modeless);
        state.set("notclosable", this.notclosable);
        state.set("persistWindow", this.persistWindow);
        state.set("palette", this.palette);
        state.set("additionalInfo", this.additionalInfo);
        state.set("width", this.width);
        state.set("height", this.height);
        state.set("x", this.x);
        state.set("y", this.y);
        state.set("normalX", this.normalX);
        state.set("normalY", this.normalY);
        state.set("normalHeight", this.normalHeight);
        state.set("normalWidth", this.normalWidth);
        state.set("minSize", (Object)this.minSize);
        state.set("isMaximized", this.isMaximized);
        state.set("visible", this.visible);
        state.set("isClosed", this.isClosed);
        state.set("title", this.title);
        state.set("id", this.id);
        state.set("selectedTools", this.selectedTools);
        state.set("defaultGroup", this.defaultGroup);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.resizable = state.getBoolean("resizable");
        this.maximizable = state.getBoolean("maximizable");
        this.iconifiable = state.getBoolean("iconifiable");
        this.modal = state.getBoolean("modal");
        this.modeless = state.getBoolean("modeless");
        this.notclosable = state.getBoolean("notclosable");
        this.persistWindow = state.getBoolean("persistWindow");
        this.palette = state.getBoolean("palette");
        this.additionalInfo = state.getString("additionalInfo");
        this.width = state.getInt("width");
        this.height = state.getInt("height");
        this.x = state.getInt("x");
        this.y = state.getInt("y");
        this.normalX = state.getInt("normalX");
        this.normalY = state.getInt("normalY");
        this.normalHeight = state.getInt("normalHeight");
        this.normalWidth = state.getInt("normalWidth");
        this.minSize = (Dimension)state.get("minSize");
        this.isMaximized = state.getBoolean("isMaximized");
        this.visible = state.getBoolean("visible");
        this.isClosed = state.getBoolean("isClosed");
        this.title = state.getString("title");
        this.id = state.getInt("id");
        this.setSelectedTools(state.getMap("selectedTools"));
        this.defaultGroup = state.getString("defaultGroup");
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            DynStruct definition = manager.getDefinition(WindowInfo.PERSISTENCE_DEFINITION_NAME);
            if (definition == null) {
                definition = manager.addDefinition(WindowInfo.class, WindowInfo.PERSISTENCE_DEFINITION_NAME, "WindowInfo persistence definition", null, null);
                definition.addDynFieldBoolean("resizable").setMandatory(true);
                definition.addDynFieldBoolean("maximizable").setMandatory(true);
                definition.addDynFieldBoolean("iconifiable").setMandatory(true);
                definition.addDynFieldBoolean("modal").setMandatory(true);
                definition.addDynFieldBoolean("modeless").setMandatory(true);
                definition.addDynFieldBoolean("notclosable").setMandatory(true);
                definition.addDynFieldBoolean("persistWindow").setMandatory(true);
                definition.addDynFieldBoolean("palette").setMandatory(true);
                definition.addDynFieldString("additionalInfo").setMandatory(false);
                definition.addDynFieldInt("width").setMandatory(true);
                definition.addDynFieldInt("height").setMandatory(true);
                definition.addDynFieldInt("x").setMandatory(true);
                definition.addDynFieldInt("y").setMandatory(true);
                definition.addDynFieldInt("normalX").setMandatory(true);
                definition.addDynFieldInt("normalY").setMandatory(true);
                definition.addDynFieldInt("normalHeight").setMandatory(true);
                definition.addDynFieldInt("normalWidth").setMandatory(true);
                definition.addDynFieldObject("minSize").setMandatory(false).setClassOfValue(Dimension.class);
                definition.addDynFieldBoolean("isMaximized").setMandatory(true);
                definition.addDynFieldBoolean("visible").setMandatory(true);
                definition.addDynFieldBoolean("isClosed").setMandatory(true);
                definition.addDynFieldString("title").setMandatory(true);
                definition.addDynFieldInt("id").setMandatory(true);
                definition.addDynFieldMap("selectedTools").setMandatory(false).setClassOfItems(String.class);
                definition.addDynFieldString("defaultGroup").setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }
}

