/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.ui.splash;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.gvsig.andami.Launcher;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.Messages;
import org.gvsig.andami.ui.theme.Theme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSplashWindow
extends JWindow
implements MouseListener {
    private static final Logger logger = LoggerFactory.getLogger(MultiSplashWindow.class);
    private static final long serialVersionUID = 572592158521767258L;
    private JProgressBar pb;
    private int progress = 0;
    private JLabel lblStatus;
    private Timer timer;
    private int numLogos = 0;
    private ImageIcon[] img = null;
    private Dimension splashDimension;
    private int index = 0;
    private int current;
    private int lastIndex = -1;
    private Theme theme;
    private int[] timers;
    private String version = "";
    private String[] versions = null;
    private Point point = new Point(270, 240);
    private Point[] points = null;
    private int fontsize = 18;
    private int[] fontSizes = null;
    private Color fontcolor = new Color(80, 170, 240);
    private Color[] fontColors = null;
    private final boolean showsplash = (Boolean)Launcher.getArguments().get("splash", true);

    public MultiSplashWindow(Frame f, Theme theme, int progressBarStepCount) {
        super(f);
        this.theme = theme;
        this.timers = theme.getTimers();
        this.lblStatus = new JLabel(Messages.getString("SplashWindow.Iniciando"));
        this.lblStatus.setBorder(BorderFactory.createEtchedBorder());
        this.lblStatus.setBackground(Color.WHITE);
        this.pack();
        this.pb = new JProgressBar(0, progressBarStepCount);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.lblStatus, "North");
        this.getContentPane().add((Component)this.pb, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.init();
        this.setLocation(screenSize.width / 2 - this.splashDimension.width / 2, screenSize.height / 2 - this.splashDimension.height / 2);
        this.index = 0;
        this.setVisible(this.showsplash);
        this.addMouseListener(this);
    }

    public void init() {
        this.img = this.theme.getSplashImages();
        this.numLogos = this.img.length;
        if (this.numLogos == 0) {
            this.numLogos = 1;
            this.img = new ImageIcon[1];
            this.img[0] = PluginServices.getIconTheme().get("splash-default");
            this.timers = new int[1];
            this.timers[0] = 1000;
        }
        this.versions = this.theme.getVersions();
        this.points = this.theme.getPositions();
        this.fontSizes = this.theme.getFontSizes();
        this.fontColors = this.theme.getFontColors();
        int splashWidth = this.img[0].getIconWidth();
        int splashHeight = this.img[0].getIconHeight();
        for (int i = 1; i < this.numLogos; ++i) {
            splashWidth = Math.max(splashWidth, this.img[i].getIconWidth());
            splashHeight = Math.max(splashHeight, this.img[i].getIconHeight());
        }
        this.splashDimension = new Dimension(splashWidth, splashHeight);
        this.setSize(this.splashDimension.width, this.splashDimension.height + 45);
        this.start();
    }

    @Override
    public void paint(Graphics g) {
        FontRenderContext context;
        Rectangle2D bounds;
        if (this.lastIndex == this.current) {
            return;
        }
        super.paint(g);
        if (this.img == null || this.img[this.current] == null) {
            return;
        }
        ImageIcon image = this.img[this.current];
        g.drawImage(image.getImage(), this.getWidth() / 2 - image.getIconWidth() / 2, this.getHeight() / 2 - image.getIconHeight() / 2, this);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        Font font = new Font("SansSerif", 1, this.fontsize);
        if (this.fontSizes.length > 0 && this.fontSizes[this.current] != 0) {
            font = new Font("SansSerif", 1, this.fontSizes[this.current]);
        }
        g.setFont(font);
        Color color = this.fontcolor;
        if (this.fontColors.length > 0 && this.fontColors[this.current] != null) {
            color = this.fontColors[this.current];
        }
        g.setColor(color);
        String ver = this.version;
        if (this.versions.length > 0 && this.versions[this.current] != null) {
            ver = this.versions[this.current];
        }
        Point p = this.point;
        if (this.points.length > 0 && this.points[this.current] != null) {
            p = this.points[this.current];
        }
        int xx = (int)p.getX();
        String s = PluginServices.getText(this, ver);
        if (xx < 0 && (xx = this.splashDimension.width - (int)(bounds = font.getStringBounds(s, context = g.getFontMetrics().getFontRenderContext())).getWidth() + xx) < 1) {
            xx = 1;
        }
        g.drawString(s, xx, (int)p.getY());
        this.lastIndex = this.current;
    }

    public void tick() {
        this.current = this.index++;
        this.timer.setDelay(this.timers[this.current]);
        this.repaint();
        if (this.index >= this.numLogos) {
            this.index = 0;
        }
    }

    public void start() {
        this.timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiSplashWindow.this.tick();
            }
        });
        this.timer.start();
    }

    public void close() {
        if (this.progress != this.pb.getMaximum()) {
            logger.warn("Max value of launch progress can be set to " + this.progress);
        }
        this.setVisible(false);
        this.stop();
        this.dispose();
    }

    public void stop() {
        this.timer.stop();
        this.timer = null;
    }

    public static void main(String[] args) {
        Frame frame = new Frame();
        Theme theme = new Theme();
        MultiSplashWindow ba = new MultiSplashWindow(frame, theme, 5);
        ba.setVisible(true);
        ba.setSize(500, 500);
        ba.init();
        ba.start();
    }

    public void process(int p, String str) {
        this.lblStatus.setText(str);
        if (this.progress < p) {
            this.progress = p;
        }
        if (this.pb.getValue() != this.progress && this.progress <= this.pb.getMaximum()) {
            this.pb.setValue(this.progress);
        }
        this.doLayout();
        this.repaint();
    }

    public void process(final String str) {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        MultiSplashWindow.this.process(str);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        this.lblStatus.setText(str);
        this.lblStatus.paintImmediately(this.lblStatus.getVisibleRect());
        ++this.progress;
        if (this.progress <= this.pb.getMaximum()) {
            this.pb.setValue(this.progress);
            this.pb.paintImmediately(this.pb.getVisibleRect());
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.setVisible(false);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

