/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.ui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.status.IUnsavedData;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.gui.beans.swing.JButton;
import org.gvsig.tools.swing.api.ToolsSwingUtils;

public class UnsavedDataPanel
extends JPanel
implements IWindow,
ActionListener {
    private static final long serialVersionUID = -4745219917358767905L;
    private static ImageIcon blanckIcon = null;
    private JPanel pResources = null;
    private JPanel pButtons = null;
    private JScrollPane pScrollList = null;
    private myList list = null;
    private JLabel lblDescription = null;
    private JButton botSave = null;
    private JButton botDiscard = null;
    private JButton botDontExit = null;
    private JPanel pActionButtons = null;
    private JPanel pSelectionButtons = null;
    private JButton botSelectAll = null;
    private JButton botDeselectAll = null;
    private ArrayList listeners = new ArrayList();
    private JLabel lblResourceDescription = null;
    private IUnsavedData[] unsavedDataList;
    private String windowTitle = PluginServices.getText(this, "save_resources");
    private String prompt = PluginServices.getText(this, "select_resources_to_save_before_exit");

    public UnsavedDataPanel(IUnsavedData[] unsavedDatalist) {
        this.initialize();
        this.setUnsavedDataArray(unsavedDatalist);
    }

    public UnsavedDataPanel(String prompt) {
        this.initialize();
        this.setUnsavedDataArray(new IUnsavedData[0]);
        this.prompt = prompt;
    }

    private void initialize() {
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(5);
        borderLayout.setVgap(5);
        this.lblDescription = new JLabel();
        this.lblDescription.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.lblDescription.setText(this.prompt);
        this.lblDescription.setPreferredSize(new Dimension(497, 30));
        this.lblDescription.setName("lblDescription");
        this.setLayout(borderLayout);
        this.add((Component)this.getPResources(), "Center");
        this.add((Component)this.getPButtons(), "South");
        this.add((Component)this.lblDescription, "North");
        this.setPreferredSize(ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)15, (int)70));
    }

    private JPanel getPResources() {
        if (this.pResources == null) {
            this.pResources = new JPanel();
            this.pResources.setLayout(new BorderLayout());
            this.pResources.add((Component)this.getPScrollList(), "Center");
            Dimension dim = this.pResources.getPreferredSize();
            dim.height = ToolsSwingUtils.rows2px((int)10);
            this.pResources.setPreferredSize(dim);
        }
        return this.pResources;
    }

    private JLabel getLblResourceDescription() {
        if (this.lblResourceDescription == null) {
            this.lblResourceDescription = new JLabel();
            this.lblResourceDescription.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.lblResourceDescription.setText("");
            this.lblResourceDescription.setPreferredSize(new Dimension(38, 50));
            this.lblResourceDescription.setName("lblResourceDescription");
        }
        return this.lblResourceDescription;
    }

    private JPanel getPButtons() {
        if (this.pButtons == null) {
            BorderLayout borderLayout2 = new BorderLayout();
            borderLayout2.setHgap(5);
            borderLayout2.setVgap(5);
            this.pButtons = new JPanel();
            this.pButtons.setLayout(borderLayout2);
            this.pButtons.add((Component)this.getPSelectionButtons(), "North");
            this.pButtons.add((Component)this.getPActionButtons(), "South");
        }
        return this.pButtons;
    }

    private JScrollPane getPScrollList() {
        if (this.pScrollList == null) {
            this.pScrollList = new JScrollPane();
            this.pScrollList.setPreferredSize(new Dimension(350, 350));
            this.pScrollList.setViewportView(this.getList());
        }
        return this.pScrollList;
    }

    private myList getList() {
        if (this.list == null) {
            this.list = new myList();
        }
        return this.list;
    }

    private JButton getBotSave() {
        if (this.botSave == null) {
            this.botSave = new JButton();
            this.botSave.setName("botSave");
            this.botSave.setToolTipText(PluginServices.getText(this, "save_selected_resources_and_exit"));
            this.botSave.setText(PluginServices.getText(this, "save"));
            this.botSave.setActionCommand("Accept");
            this.botSave.addActionListener((ActionListener)this);
        }
        return this.botSave;
    }

    private JButton getBotDiscard() {
        if (this.botDiscard == null) {
            this.botDiscard = new JButton();
            this.botDiscard.setName("botDiscard");
            this.botDiscard.setToolTipText(PluginServices.getText(this, "discard_changes_and_exit"));
            this.botDiscard.setText(PluginServices.getText(this, "discard_changes"));
            this.botDiscard.setActionCommand("Discard");
            this.botDiscard.addActionListener((ActionListener)this);
        }
        return this.botDiscard;
    }

    private JButton getBotDontExit() {
        if (this.botDontExit == null) {
            this.botDontExit = new JButton();
            this.botDontExit.setName("botDontExit");
            this.botDontExit.setToolTipText(PluginServices.getText(this, "cancel_the_application_termination"));
            this.botDontExit.setText(PluginServices.getText(this, "cancelar"));
            this.botDontExit.setActionCommand("Cancel");
            this.botDontExit.addActionListener((ActionListener)this);
        }
        return this.botDontExit;
    }

    private JPanel getPActionButtons() {
        if (this.pActionButtons == null) {
            GridLayout gl = new GridLayout(1, 3, 8, 0);
            this.pActionButtons = new JPanel();
            this.pActionButtons.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
            this.pActionButtons.setLayout(gl);
            this.pActionButtons.setName("pActionButtons");
            this.pActionButtons.add((Component)this.getBotSave());
            this.pActionButtons.add((Component)this.getBotDiscard());
            this.pActionButtons.add((Component)this.getBotDontExit());
        }
        return this.pActionButtons;
    }

    private JPanel getPSelectionButtons() {
        if (this.pSelectionButtons == null) {
            GridLayout gl = new GridLayout(2, 3, 8, 8);
            this.pSelectionButtons = new JPanel();
            this.pSelectionButtons.setBorder(BorderFactory.createEmptyBorder(5, 8, 8, 8));
            this.pSelectionButtons.setLayout(gl);
            this.pSelectionButtons.setName("pSelectionButtons");
            this.pSelectionButtons.add((Component)this.getBotSelectAll());
            this.pSelectionButtons.add(new JLabel());
            this.pSelectionButtons.add(new JLabel());
            this.pSelectionButtons.add((Component)this.getBotDeselectAll());
            this.pSelectionButtons.add(new JLabel());
            this.pSelectionButtons.add(new JLabel());
        }
        return this.pSelectionButtons;
    }

    private JButton getBotSelectAll() {
        if (this.botSelectAll == null) {
            this.botSelectAll = new JButton();
            this.botSelectAll.setText(PluginServices.getText(this, "select_all"));
            this.botSelectAll.setName("botSelectAll");
            this.botSelectAll.setToolTipText(PluginServices.getText(this, "select_all_resources"));
            this.botSelectAll.setActionCommand("SelectAll");
            this.botSelectAll.addActionListener((ActionListener)this);
        }
        return this.botSelectAll;
    }

    private JButton getBotDeselectAll() {
        if (this.botDeselectAll == null) {
            this.botDeselectAll = new JButton();
            this.botDeselectAll.setName("botDeselectAll");
            this.botDeselectAll.setToolTipText(PluginServices.getText(this, "deselect_all_resources"));
            this.botDeselectAll.setText(PluginServices.getText(this, "deselect_all"));
            this.botDeselectAll.setActionCommand("DeselectAll");
            this.botDeselectAll.addActionListener((ActionListener)this);
        }
        return this.botDeselectAll;
    }

    @Override
    public WindowInfo getWindowInfo() {
        WindowInfo wi = new WindowInfo(11);
        wi.setTitle(this.windowTitle);
        Dimension dim = this.getPreferredSize();
        wi.setHeight(dim.height);
        wi.setWidth(dim.width);
        return wi;
    }

    public void setWindowTitle(String windowTitle) {
        this.windowTitle = windowTitle;
    }

    public void setCancelText(String text, String tooltipText) {
        this.getBotDontExit().setToolTipText(tooltipText);
        this.getBotDontExit().setText(text);
    }

    public void setDiscardText(String text, String tooltipText) {
        this.getBotDiscard().setToolTipText(tooltipText);
        this.getBotDiscard().setText(text);
    }

    public void setAcceptText(String text, String tooltipText) {
        this.getBotSave().setToolTipText(tooltipText);
        this.getBotSave().setText(text);
    }

    public void setHeaderText(String text) {
        this.lblDescription.setText(text);
    }

    public void addActionListener(UnsavedDataPanelListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(UnsavedDataPanelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "Cancel") {
            this.fireDontExitEvent();
            return;
        }
        if (e.getActionCommand() == "Accept") {
            this.fireAcceptEvent();
            return;
        }
        if (e.getActionCommand() == "Discard") {
            this.fireDiscardEvent();
            return;
        }
        if (e.getActionCommand() == "SelectAll") {
            this.selectAll();
            return;
        }
        if (e.getActionCommand() == "DeselectAll") {
            this.deselectAll();
            return;
        }
    }

    public void close() {
        PluginServices.getMDIManager().closeWindow(this);
    }

    private void fireAcceptEvent() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((UnsavedDataPanelListener)iter.next()).accept(this);
        }
    }

    private void fireDiscardEvent() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((UnsavedDataPanelListener)iter.next()).discard(this);
        }
    }

    private void fireDontExitEvent() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((UnsavedDataPanelListener)iter.next()).cancel(this);
        }
    }

    private void setSelectedsAll(boolean selected) {
        myList theList = this.getList();
        for (int i = 0; i < theList.getItemsCount(); ++i) {
            myUnsavedItem item = theList.getItem(i);
            item.setSelected(selected);
        }
        theList.doLayout();
    }

    public void deselectAll() {
        this.setSelectedsAll(false);
    }

    public void selectAll() {
        this.setSelectedsAll(true);
    }

    public void setUnsavedDataArray(IUnsavedData[] unsavedDatalist) {
        this.unsavedDataList = unsavedDatalist;
        myList theList = this.getList();
        theList.addItems(unsavedDatalist);
        theList.validate();
    }

    public void setUnsavedData(List<IUnsavedData> unsavedDatalist) {
        this.setUnsavedDataArray(unsavedDatalist.toArray(new IUnsavedData[0]));
    }

    public List<IUnsavedData> getSelectedsUnsavedDataList() {
        return Arrays.asList(this.getSelectedsUnsavedData());
    }

    private IUnsavedData[] getUnsavedData(boolean selected) {
        myList theList = this.getList();
        ArrayList<IUnsavedData> aList = new ArrayList<IUnsavedData>();
        for (int i = 0; i < theList.getItemsCount(); ++i) {
            myUnsavedItem item = theList.getItem(i);
            if (item.isSelected() != selected) continue;
            aList.add(item.getData());
        }
        IUnsavedData[] result = new IUnsavedData[aList.size()];
        System.arraycopy(aList.toArray(), 0, result, 0, aList.size());
        return result;
    }

    public IUnsavedData[] getSelectedsUnsavedData() {
        return this.getUnsavedData(true);
    }

    public IUnsavedData[] getUnselectedsUnsavedData() {
        return this.getUnsavedData(false);
    }

    @Override
    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    private class myUnsavedItem
    extends JPanel {
        private static final long serialVersionUID = -6280057775368437349L;
        private JCheckBox chkChecked;
        private JLabel lblText;
        private IUnsavedData dataItem;

        public myUnsavedItem(IUnsavedData dataItem) {
            this.initialize();
            this.setData(dataItem);
        }

        private void initialize() {
            this.setOpaque(false);
            BorderLayout layout = new BorderLayout();
            layout.setHgap(5);
            this.setLayout(layout);
            this.add((Component)this.getChkChecked(), "West");
            this.add((Component)this.getLblText(), "Center");
        }

        private JLabel getLblText() {
            if (this.lblText == null) {
                this.lblText = new JLabel();
                this.lblText.setName("lblText");
            }
            return this.lblText;
        }

        private JCheckBox getChkChecked() {
            if (this.chkChecked == null) {
                this.chkChecked = new JCheckBox();
                this.chkChecked.setName("chkChecked");
                this.chkChecked.setSelected(true);
                this.chkChecked.setOpaque(false);
            }
            return this.chkChecked;
        }

        public boolean isSelected() {
            return this.getChkChecked().isSelected();
        }

        public void setSelected(boolean selected) {
            this.getChkChecked().setSelected(selected);
        }

        public void setData(IUnsavedData dataItem) {
            this.dataItem = dataItem;
            JLabel lbl = this.getLblText();
            if (dataItem.getIcon() != null) {
                ImageIcon ii = IconThemeHelper.getImageIcon(dataItem.getIcon());
                lbl.setIcon(ii);
            } else {
                lbl.setIcon(this.getBlanckIcon());
            }
            lbl.setText(dataItem.getResourceName());
            this.getChkChecked().setSelected(true);
        }

        public IUnsavedData getData() {
            return this.dataItem;
        }

        public String getDescription() {
            return this.dataItem.getDescription();
        }

        private ImageIcon getBlanckIcon() {
            if (blanckIcon == null) {
                BufferedImage buff = new BufferedImage(16, 16, 2);
                blanckIcon = new ImageIcon(buff);
            }
            return blanckIcon;
        }
    }

    private class myList
    extends JPanel {
        private static final long serialVersionUID = 3179254463477354501L;
        private GridBagConstraints constraints;
        private GridBagConstraints constraintsLast;

        public myList() {
            this.initialize();
        }

        private void initialize() {
            this.setLayout(new GridBagLayout());
            this.setBackground(UIManager.getColor("List.background"));
            this.constraints = new GridBagConstraints();
            this.constraints.fill = 2;
            this.constraints.gridwidth = 0;
            this.constraints.weightx = 0.0;
            this.constraints.gridx = 0;
            this.constraints.gridy = 0;
            this.constraints.anchor = 17;
            this.constraints.insets = new Insets(3, 3, 0, 0);
            this.constraintsLast = new GridBagConstraints();
            this.constraintsLast.fill = 1;
            this.constraintsLast.gridheight = 0;
            this.constraintsLast.gridwidth = 0;
            this.constraintsLast.gridx = 0;
            this.constraintsLast.weightx = 1.0;
            this.constraintsLast.weighty = 1.0;
            this.constraintsLast.anchor = 23;
        }

        public void addItems(IUnsavedData[] itemList) {
            this.removeAll();
            if (itemList.length == 0) {
                return;
            }
            for (int i = 0; i < itemList.length; ++i) {
                this.constraints.gridy = i;
                this.add((Component)this.newItem(itemList[i]), this.constraints);
            }
            this.constraintsLast.gridy = itemList.length;
            this.add((Component)new JLabel(), this.constraintsLast);
        }

        public int getItemsCount() {
            return this.getComponentCount() - 1;
        }

        public myUnsavedItem getItem(int i) {
            if (i >= this.getComponentCount()) {
                return null;
            }
            return (myUnsavedItem)this.getComponent(i);
        }

        private myUnsavedItem newItem(IUnsavedData itemData) {
            myUnsavedItem item = new myUnsavedItem(itemData);
            item.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    myUnsavedItem item = (myUnsavedItem)e.getComponent();
                    UnsavedDataPanel.this.getLblResourceDescription().setText(item.getDescription());
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }
            });
            return item;
        }
    }

    public class UnsavedDataPanelListener {
        public void cancel(UnsavedDataPanel panel) {
        }

        public void accept(UnsavedDataPanel panel) {
        }

        public void discard(UnsavedDataPanel panel) {
        }
    }
}

