/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.gui.preference.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.ColorTableLibrary;
import org.gvsig.fmap.dal.coverage.exception.FilePaletteException;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.raster.mainplugin.config.Configuration;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.raster.gui.preference.combocolortable.PaintItem;
import org.gvsig.raster.tools.app.basic.raster.gui.preference.combocolortable.PreferenceColorTableIconPainter;
import org.gvsig.raster.util.BasePanel;

public class PreferenceLoadLayer
extends BasePanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JComboBox comboBoxColorTable = null;
    private JRadioButton radioButtonRealce = null;
    private JRadioButton radioButtonColorTable = null;
    private JLabel labelLoadLayer = null;
    private ButtonGroup buttonGroup = null;

    public PreferenceLoadLayer() {
        this.init();
        this.translate();
    }

    protected void translate() {
        this.setBorder(BorderFactory.createTitledBorder(this.getText(this, "carga_capas")));
        this.getLabelLoadLayer().setText(this.getText(this, "loadlayer_aplicar") + ":");
        this.getRadioButtonRealce().setText(this.getText(this, "realce"));
        this.getRadioButtonColorTable().setText(this.getText(this, "tabla_color"));
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 2, 5);
        this.add(this.getLabelLoadLayer(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.add(this.getRadioButtonRealce(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 5, 5, 2);
        this.add(this.getRadioButtonColorTable(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 5, 5);
        this.add(this.getComboBoxColorTable(), gridBagConstraints);
    }

    public String getPalettesPath() {
        return System.getProperty("user.home") + File.separator + "gvSIG" + File.separator + "colortable";
    }

    public ButtonGroup getButtonGroup() {
        if (this.buttonGroup == null) {
            this.buttonGroup = new ButtonGroup();
        }
        return this.buttonGroup;
    }

    public JRadioButton getRadioButtonRealce() {
        if (this.radioButtonRealce == null) {
            this.radioButtonRealce = new JRadioButton();
            this.getButtonGroup().add(this.radioButtonRealce);
            this.radioButtonRealce.addActionListener(this);
            this.radioButtonRealce.setSelected(true);
            this.radioButtonRealce.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.radioButtonRealce.setMargin(new Insets(0, 0, 0, 0));
        }
        return this.radioButtonRealce;
    }

    public JRadioButton getRadioButtonColorTable() {
        if (this.radioButtonColorTable == null) {
            this.radioButtonColorTable = new JRadioButton();
            this.getButtonGroup().add(this.radioButtonColorTable);
            this.radioButtonColorTable.addActionListener(this);
            this.radioButtonColorTable.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.radioButtonColorTable.setMargin(new Insets(0, 0, 0, 0));
        }
        return this.radioButtonColorTable;
    }

    public JLabel getLabelLoadLayer() {
        if (this.labelLoadLayer == null) {
            this.labelLoadLayer = new JLabel();
        }
        return this.labelLoadLayer;
    }

    public JComboBox getComboBoxColorTable() {
        if (this.comboBoxColorTable == null) {
            this.comboBoxColorTable = new JComboBox();
            ColorTableLibrary lib = RasterLocator.getManager().getDataStructFactory().getColorTableLibrary();
            ArrayList fileList = null;
            try {
                fileList = lib.getPaletteFileList(this.getPalettesPath());
                for (int i = 0; i < fileList.size(); ++i) {
                    ArrayList paletteItems = new ArrayList();
                    String paletteName = lib.loadPalette(this.getPalettesPath(), (String)fileList.get(i), paletteItems);
                    if (paletteItems.size() <= 0) continue;
                    ColorTable colorTable = lib.createColorTable();
                    colorTable.setName(paletteName);
                    colorTable.createPaletteFromColorItems(paletteItems, true);
                    colorTable.setInterpolated(true);
                    ArrayList<Object> array = new ArrayList<Object>();
                    array.add(paletteName);
                    array.add(new PreferenceColorTableIconPainter(colorTable));
                    this.comboBoxColorTable.addItem(array);
                }
            }
            catch (FilePaletteException e) {
                RasterSwingLibrary.messageBoxError((String)e.getMessage(), (Object)this, (Exception)((Object)e));
            }
            this.comboBoxColorTable.setRenderer(new ListCellRenderer(){

                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    ArrayList array = (ArrayList)value;
                    PaintItem paintItem = new PaintItem((String)array.get(0), (PreferenceColorTableIconPainter)array.get(1), isSelected);
                    return paintItem;
                }
            });
        }
        return this.comboBoxColorTable;
    }

    private void setColorTableEnabled(boolean enabled) {
        this.getComboBoxColorTable().setEnabled(enabled);
    }

    public void initializeDefaults() {
        this.getRadioButtonRealce().setSelected(true);
        this.setColorTableEnabled(false);
        this.selectComboName("Default");
    }

    private boolean selectComboName(String name) {
        if (name != null) {
            for (int i = 0; i < this.getComboBoxColorTable().getItemCount(); ++i) {
                if (!((String)((ArrayList)this.getComboBoxColorTable().getItemAt(i)).get(0)).equals(name)) continue;
                this.getComboBoxColorTable().setSelectedIndex(i);
                return true;
            }
        }
        return false;
    }

    public void initializeValues() {
        String colorTable = Configuration.getValue((String)"loadlayer_usecolortable", (String)null);
        boolean finded = this.selectComboName(colorTable);
        if (!finded) {
            this.getRadioButtonRealce().setSelected(true);
            this.setColorTableEnabled(false);
            Configuration.setValue((String)"loadlayer_usecolortable", (Object)null);
            this.selectComboName("Default");
        } else {
            this.getRadioButtonColorTable().setSelected(true);
            this.setColorTableEnabled(true);
        }
    }

    public void storeValues() {
        if (this.getRadioButtonColorTable().isSelected()) {
            Configuration.setValue((String)"loadlayer_usecolortable", (Object)((String)((ArrayList)this.getComboBoxColorTable().getSelectedItem()).get(0)));
        } else {
            Configuration.setValue((String)"loadlayer_usecolortable", null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.getRadioButtonColorTable().isSelected()) {
            this.setColorTableEnabled(true);
        } else {
            this.setColorTableEnabled(false);
        }
    }
}

