/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.gui.wizard;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.prepareAction.PrepareContext;
import org.gvsig.app.prepareAction.PrepareDataStoreParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterFileStoreParameters;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.raster.gui.wizard.FileOpenVRTException;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class PrepareDataStoreParametersRaw
implements PrepareDataStoreParameters {
    public DataStoreParameters prepare(DataStoreParameters storeParamters, PrepareContext context) {
        if (!(storeParamters instanceof RasterFileStoreParameters)) {
            return storeParamters;
        }
        RasterFileStoreParameters rasterParams = (RasterFileStoreParameters)storeParamters;
        File file = rasterParams.getFile();
        if (file == null) {
            return null;
        }
        if (RasterLocator.getManager().getFileUtils().getExtensionFromFileName(file.getAbsolutePath()).equals("vrt")) {
            try {
                this.checkFileVRT(file);
            }
            catch (FileOpenVRTException e) {
                RasterSwingLibrary.messageBoxError((String)(PluginServices.getText((Object)this, (String)"error_abrir_fichero") + " " + file.getName() + "\n\n" + PluginServices.getText((Object)this, (String)"informacion_adicional") + ":\n\n  " + e.getMessage()), (Object)this, (Exception)e);
                return null;
            }
        }
        rasterParams.setFile(file);
        return rasterParams;
    }

    private void checkFileVRT(File file) throws FileOpenVRTException {
        KXmlParser parser = new KXmlParser();
        boolean end = false;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            parser.setInput((Reader)fileReader);
            int currentTag = parser.nextTag();
            parser.require(2, null, "VRTDataset");
            while (!end) {
                switch (currentTag) {
                    case 2: {
                        if (!this.compareName(parser, "VRTRasterBand")) break;
                        this.checkSubTreeVRTRasterBand(parser, file);
                        break;
                    }
                    case 3: {
                        if (!this.compareName(parser, "VRTRasterBand")) break;
                        end = true;
                        break;
                    }
                }
                if (end) continue;
                currentTag = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            throw new FileOpenVRTException(PluginServices.getText((Object)this, (String)"el_fichero") + " " + file.getName().toString() + " " + Messages.getText((String)"esta_formato_desconocido"));
        }
        catch (IOException e) {
            throw new FileOpenVRTException(PluginServices.getText((Object)this, (String)"no_puede_abrir_fichero") + " " + file.getName().toString());
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void checkSubTreeVRTRasterBand(KXmlParser parser, File file) throws XmlPullParserException, IOException, FileOpenVRTException {
        boolean end = false;
        int currentTag = parser.nextTag();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (this.compareName(parser, "SourceFilename")) {
                        this.checkTagSourceFileName(parser, file);
                        end = true;
                        break;
                    }
                    if (!this.compareName(parser, "SimpleSource") && !this.compareName(parser, "ComplexSource") && !this.compareName(parser, "AveragedSource")) break;
                    this.checkSubTreeSource(parser, file);
                    break;
                }
                case 3: {
                    if (!this.compareName(parser, "SourceFilename") && !this.compareName(parser, "SimpleSource") && !this.compareName(parser, "ComplexSource") && !this.compareName(parser, "AveragedSource")) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private void checkSubTreeSource(KXmlParser parser, File file) throws XmlPullParserException, IOException, FileOpenVRTException {
        boolean end = false;
        int currentTag = parser.nextTag();
        while (!end) {
            switch (currentTag) {
                case 2: {
                    if (this.compareName(parser, "SourceFilename")) {
                        this.checkTagSourceFileName(parser, file);
                    }
                }
                case 3: {
                    if (!this.compareName(parser, "SourceFilename")) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            currentTag = parser.next();
        }
    }

    private void checkTagSourceFileName(KXmlParser parser, File file) throws XmlPullParserException, IOException, FileOpenVRTException {
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (!parser.getAttributeName(i).equals("relativetoVRT") || !parser.getAttributeValue(i).equals("1")) continue;
            String nameFile = parser.nextText();
            nameFile = file.getParent() + File.separator + nameFile;
            File tryFile = new File(nameFile);
            if (tryFile.exists()) continue;
            throw new FileOpenVRTException(Messages.getText((String)"no_existe_fichero") + " " + nameFile);
        }
    }

    public boolean compareName(KXmlParser parser, String name) {
        String s = parser.getName();
        return s.compareTo(name) == 0 || s.compareTo("ows:" + name) == 0;
    }

    public String getDescription() {
        return "Prepare Raster Raw Stores";
    }

    public String getName() {
        return "PrepareRaw";
    }

    public Object create() {
        return this;
    }

    public Object create(Object[] args) {
        return this;
    }

    public Object create(Map args) {
        return this;
    }

    public void post(DataStoreParameters storeParameters, PrepareContext context) {
    }

    public void pre(DataStoreParameters storeParameters, PrepareContext context) {
    }
}

