/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.raster.process;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.cresques.cts.IProjection;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.view.BaseViewDocument;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.ROIException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.process.BaseIncrementableTask;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.parameter.NewRasterStoreParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RemoteStoreParameters;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.util.RasterUtils;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.mainplugin.RasterMainPluginUtils;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.util.RasterNotLoadException;
import org.slf4j.LoggerFactory;

public class ClippingProcess
extends DataProcess {
    public static final String PROCESS_LABEL = "ClippingProcess";
    public static String FILENAME = "filename";
    public static String SUFFIX = "suffix";
    public static String VIEWNAME = "viewname";
    public static String PX_COORDS = "pixelcoordinates";
    public static String WORLD_COORDS = "realcoordinates";
    public static String RASTER_STORE = "layer";
    public static String DRAWABLE_BANDS = "drawablebands";
    public static String ONE_LYE_PER_BAND = "onelayerperband";
    public static String INTERP_METHOD = "interpolationmethod";
    public static String AT = "affinetransform";
    public static String COLOR_INTERPR = "colorInterpretation";
    public static String SELECTED_ROIS = "selectedrois";
    public static String RESOLUTION = "resolution";
    public static String DRIVER_PARAMS = "driverparams";
    public static String VIEW_PROJ = "viewProjection";
    private String fileName = "";
    private String suffix = ".tif";
    private RasterDataStore dataStore = null;
    private boolean oneLayerPerBand = false;
    private int[] drawableBands = new int[]{0, 1, 2};
    private double[] pValues = null;
    private int interpolationMethod = 0;
    private String viewName = "";
    private Params params = null;
    private ColorInterpretation colorInterp = null;
    private ArrayList<ROI> selectedRois = null;
    private AffineTransform affineTransform = null;
    private double[] wcValues = null;
    private RasterManager rManager = RasterLocator.getManager();
    private BaseIncrementableTask processIncrement = null;
    private int resolutionWidth = 0;
    private int resolutionHeight = 0;
    private Buffer buffer = null;
    private IProjection viewProjection = null;

    public static void registerParameters() {
        ClippingProcess.registerInputParameter((String)FILENAME, String.class, (String)PROCESS_LABEL);
        ClippingProcess.registerInputParameter((String)SUFFIX, String.class, (String)PROCESS_LABEL);
        ClippingProcess.registerInputParameter((String)VIEWNAME, String.class, (String)PROCESS_LABEL);
        ClippingProcess.registerInputParameter((String)PX_COORDS, Double.class, (String)PROCESS_LABEL);
        ClippingProcess.registerInputParameter((String)WORLD_COORDS, Double.class, (String)PROCESS_LABEL);
        ClippingProcess.registerInputParameter((String)RASTER_STORE, RasterDataStore.class, (String)PROCESS_LABEL);
        ClippingProcess.registerInputParameter((String)DRAWABLE_BANDS, Integer[].class, (String)PROCESS_LABEL);
        ClippingProcess.registerInputParameter((String)ONE_LYE_PER_BAND, Boolean.class, (String)PROCESS_LABEL);
        ClippingProcess.registerInputParameter((String)INTERP_METHOD, Integer.class, (String)PROCESS_LABEL);
        ClippingProcess.registerInputParameter((String)AT, AffineTransform.class, (String)PROCESS_LABEL);
        ClippingProcess.registerInputParameter((String)COLOR_INTERPR, ColorInterpretation.class, (String)PROCESS_LABEL);
        ClippingProcess.registerInputParameter((String)SELECTED_ROIS, ArrayList.class, (String)PROCESS_LABEL);
        ClippingProcess.registerInputParameter((String)RESOLUTION, Integer[].class, (String)PROCESS_LABEL);
        ClippingProcess.registerInputParameter((String)DRIVER_PARAMS, Params.class, (String)PROCESS_LABEL);
        ClippingProcess.registerInputParameter((String)VIEW_PROJ, IProjection.class, (String)PROCESS_LABEL);
        ClippingProcess.registerOutputParameter((String)FILENAME, String.class, (String)PROCESS_LABEL);
    }

    public void init() {
        this.fileName = this.getStringParam("filename");
        this.suffix = this.getStringParam("suffix");
        this.viewName = this.getStringParam("viewname");
        this.pValues = this.getDoubleArrayParam("pixelcoordinates");
        this.wcValues = this.getDoubleArrayParam("realcoordinates");
        this.dataStore = this.getParam("layer") != null ? (RasterDataStore)this.getParam("layer") : null;
        this.drawableBands = this.getIntArrayParam("drawablebands");
        this.oneLayerPerBand = this.getBooleanParam("onelayerperband");
        this.interpolationMethod = this.getIntParam("interpolationmethod");
        this.affineTransform = (AffineTransform)this.getParam("affinetransform");
        this.colorInterp = (ColorInterpretation)this.getParam("colorInterpretation");
        this.selectedRois = (ArrayList)this.getParam("selectedrois");
        if (this.getIntArrayParam("resolution") != null) {
            this.resolutionWidth = this.getIntArrayParam("resolution")[0];
            this.resolutionHeight = this.getIntArrayParam("resolution")[1];
        }
        this.params = (Params)this.getParam("driverparams");
        this.viewProjection = this.getParam("viewProjection") != null ? (IProjection)this.getParam("viewProjection") : null;
    }

    private void saveToRmf(String fileName) {
        for (int limitNumberOfRequests = 20; this.dataStore == null && limitNumberOfRequests > 0; --limitNumberOfRequests) {
        }
        if (this.dataStore == null) {
            return;
        }
        if (this.dataStore.getNoDataValue() != null) {
            NoData nodata = this.dataStore.getNoDataValue();
            nodata.setFileName(fileName);
            nodata.save();
        }
        ColorTable colorTable = this.dataStore.getColorTable();
        try {
            this.rManager.getProviderServices().saveObjectToRmfFile(fileName, ColorTable.class, (Object)colorTable);
        }
        catch (RmfSerializerException e) {
            RasterSwingLibrary.messageBoxError((String)"error_salvando_rmf", (Object)((Object)this), (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws ProcessInterruptedException {
        block80: {
            RasterDataStore dstoreCopy = null;
            RasterUtils util = RasterLocator.getManager().getRasterUtils();
            try {
                long t2;
                Rectangle r;
                Extent bbox;
                long t1 = new Date().getTime();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                this.insertLineLog(Messages.getText((String)"leyendo_raster"));
                dstoreCopy = this.dataStore.newNotTiledDataStore();
                RasterQuery query = this.rManager.createQuery();
                query.setDrawableBands(this.drawableBands);
                if (dstoreCopy.getParameters() instanceof RemoteStoreParameters && !((RemoteStoreParameters)dstoreCopy.getParameters()).isSizeFixed()) {
                    this.insertLineLog(Messages.getText((String)"downloading_image"));
                    ((RemoteStoreParameters)dstoreCopy.getParameters()).setWidth(this.resolutionWidth);
                    ((RemoteStoreParameters)dstoreCopy.getParameters()).setHeight(this.resolutionHeight);
                    bbox = RasterLocator.getManager().getDataStructFactory().createExtent(this.wcValues[0], this.wcValues[1], this.wcValues[2], this.wcValues[3]);
                    query.setAreaOfInterest(bbox, this.resolutionWidth, this.resolutionHeight);
                    try {
                        this.buffer = dstoreCopy.query(query);
                    }
                    catch (QueryException e) {
                        RasterSwingLibrary.messageBoxError((String)"No se ha podido asignar la vista al inicial el proceso de recorte.", (Object)((Object)this), (Exception)((Object)e));
                    }
                } else if (this.interpolationMethod != 0) {
                    try {
                        if (this.pValues != null) {
                            if (util.isBufferTooBig(new double[]{this.pValues[0], this.pValues[3], this.pValues[2], this.pValues[1]}, this.drawableBands.length)) {
                                query.setReadOnly(true);
                            }
                            r = new Rectangle((int)this.pValues[0], (int)this.pValues[1], (int)Math.abs(this.pValues[2] - this.pValues[0]) + 1, (int)Math.abs(this.pValues[3] - this.pValues[1]) + 1);
                            query.setAreaOfInterest(r);
                        } else if (this.wcValues != null) {
                            query.setReadOnly(true);
                            Extent e = RasterLocator.getManager().getDataStructFactory().createExtent(this.wcValues[0], this.wcValues[1], this.wcValues[2], this.wcValues[3]);
                            query.setAreaOfInterest(e);
                        }
                        this.buffer = dstoreCopy.query(query);
                    }
                    catch (QueryException e) {
                        RasterSwingLibrary.messageBoxError((String)"No se ha podido asignar la vista al inicial el proceso de recorte.", (Object)((Object)this), (Exception)((Object)e));
                    }
                    this.insertLineLog(Messages.getText((String)"interpolando"));
                    Buffer bufTmp = this.buffer;
                    this.processIncrement = bufTmp.getIncrementableTask(0);
                    this.buffer = bufTmp.getAdjustedWindow(this.resolutionWidth, this.resolutionHeight, this.interpolationMethod);
                    if (bufTmp != this.buffer) {
                        bufTmp.dispose();
                    }
                } else {
                    try {
                        if (util.isBufferTooBig(new double[]{0.0, 0.0, this.resolutionWidth, this.resolutionHeight}, this.drawableBands.length)) {
                            query.setReadOnly(true);
                        }
                        if (this.pValues != null) {
                            r = new Rectangle((int)this.pValues[0], (int)this.pValues[3], (int)Math.abs(this.pValues[2] - this.pValues[0]) + 1, (int)Math.abs(this.pValues[1] - this.pValues[3]) + 1);
                            query.setAreaOfInterest(r, this.resolutionWidth, this.resolutionHeight);
                        } else if (this.wcValues != null) {
                            bbox = RasterLocator.getManager().getDataStructFactory().createExtent(this.wcValues[0], this.wcValues[1], this.wcValues[2], this.wcValues[3]);
                            query.setAreaOfInterest(bbox, this.resolutionWidth, this.resolutionHeight);
                        }
                        this.buffer = dstoreCopy.query(query);
                    }
                    catch (QueryException e) {
                        RasterSwingLibrary.messageBoxError((String)"No se ha podido asignar la vista al inicial el proceso de recorte.", (Object)((Object)this), (Exception)((Object)e));
                    }
                }
                if (this.selectedRois != null && !query.isReadOnly() && this.selectedRois.size() > 0) {
                    int despX = 0;
                    int despY = 0;
                    if (this.pValues != null) {
                        despX = (int)this.pValues[0];
                        despY = (int)this.pValues[1];
                    } else if (this.wcValues != null) {
                        despX = (int)dstoreCopy.worldToRaster((Point2D)new Point2D.Double(this.wcValues[0], this.wcValues[1])).getX();
                        despY = (int)dstoreCopy.worldToRaster((Point2D)new Point2D.Double(this.wcValues[0], this.wcValues[1])).getY();
                    }
                    this.drawOnlyROIs(this.buffer, this.selectedRois, despX, despY);
                }
                this.insertLineLog(Messages.getText((String)"salvando_imagen"));
                DataManager manager = DALLocator.getDataManager();
                String provider = "Gdal Store";
                DataServerExplorerParameters eparams = manager.createServerExplorerParameters("FilesystemExplorer");
                String finalFileName = "";
                NewRasterStoreParameters sparams = null;
                this.processIncrement = RasterLocator.getManager().createDataServerWriter();
                if (this.oneLayerPerBand) {
                    int i;
                    long[] milis = new long[this.drawableBands.length];
                    String[] fileNames = new String[this.drawableBands.length];
                    for (i = 0; i < this.drawableBands.length; ++i) {
                        fileNames[i] = this.fileName + "_B" + this.drawableBands[i] + this.suffix;
                        int index = fileNames[i].lastIndexOf(File.separator);
                        if (index < 0) {
                            index = fileNames[i].length();
                        }
                        String path = fileNames[i].substring(0, index);
                        String file = fileNames[i].substring(index + 1, fileNames[i].length());
                        eparams.setDynValue("initialpath", (Object)path);
                        DataServerExplorer serverExplorer = manager.openServerExplorer(eparams.getExplorerName(), eparams);
                        sparams = (NewRasterStoreParameters)serverExplorer.getAddParameters(provider);
                        sparams.setDataServer((DataServerWriter)this.processIncrement);
                        sparams.setDestination(path, file);
                        sparams.setBuffer(this.buffer);
                        sparams.setColorInterpretation(new String[]{"Gray"});
                        sparams.setWktProjection(dstoreCopy.getWktProjection());
                        sparams.setBand(i);
                        sparams.setAffineTransform(this.affineTransform);
                        sparams.setDriverParams(this.params);
                        serverExplorer.add(provider, (NewDataStoreParameters)sparams, true);
                        this.saveToRmf(fileNames[i]);
                        t2 = new Date().getTime();
                        milis[i] = t2 - t1;
                        t1 = new Date().getTime();
                    }
                    if (this.incrementableTask != null) {
                        this.incrementableTask.processFinalize();
                        this.incrementableTask = null;
                    }
                    if (this.viewName != null && RasterSwingLibrary.messageBoxYesOrNot((String)"cargar_toc", (Object)((Object)this))) {
                        try {
                            for (i = 0; i < this.drawableBands.length; ++i) {
                                FLayer lyr = RasterMainPluginUtils.loadLayer((String)this.viewName, (String)fileNames[i], null);
                                if (lyr == null || !(lyr instanceof DefaultFLyrRaster)) continue;
                                if (this.dataStore.getProjection() != null) {
                                    ((DefaultFLyrRaster)lyr).setRois(this.dataStore.getRois(this.dataStore.getProjection()));
                                    continue;
                                }
                                ((DefaultFLyrRaster)lyr).setRois(this.dataStore.getRois(this.viewProjection));
                            }
                        }
                        catch (RasterNotLoadException e) {
                            RasterSwingLibrary.messageBoxError((String)"error_load_layer", (Object)((Object)this), (Exception)((Object)e));
                        }
                    }
                    for (int i2 = 0; i2 < this.drawableBands.length; ++i2) {
                        if (this.externalActions == null) continue;
                        this.externalActions.end((Object)new Object[]{this.fileName + "_B" + this.drawableBands[i2] + this.suffix, new Long(milis[i2])});
                    }
                    break block80;
                }
                if (this.isUsingFile(this.fileName)) {
                    this.incrementableTask.hideWindow();
                    RasterSwingLibrary.messageBoxError((String)"error_opened_file", (Object)((Object)this));
                    return;
                }
                File f = new File(this.fileName);
                if (f.exists()) {
                    f.delete();
                }
                f = null;
                finalFileName = this.suffix != null ? (this.fileName.endsWith(this.suffix) ? this.fileName : this.fileName + this.suffix) : this.fileName;
                int index = finalFileName.lastIndexOf(File.separator);
                if (index < 0) {
                    index = finalFileName.length();
                }
                String path = finalFileName.substring(0, index);
                String file = finalFileName.substring(index + 1, finalFileName.length());
                eparams.setDynValue("initialpath", (Object)path);
                DataServerExplorer serverExplorer = manager.openServerExplorer(eparams.getExplorerName(), eparams);
                try {
                    provider = this.rManager.createWriter(finalFileName).getProviderName();
                }
                catch (NotSupportedExtensionException e1) {
                    RasterSwingLibrary.messageBoxError((String)"no_driver_escritura", (Object)((Object)this), (Exception)((Object)e1));
                }
                catch (RasterDriverException e1) {
                    RasterSwingLibrary.messageBoxError((String)"no_driver_escritura", (Object)((Object)this), (Exception)((Object)e1));
                }
                sparams = (NewRasterStoreParameters)serverExplorer.getAddParameters(provider);
                sparams.setDataServer((DataServerWriter)this.processIncrement);
                sparams.setDestination(path, file);
                sparams.setBuffer(this.buffer);
                if (this.colorInterp != null) {
                    sparams.setColorInterpretation(this.colorInterp.getValues());
                }
                sparams.setWktProjection(dstoreCopy.getWktProjection());
                sparams.setAffineTransform(this.affineTransform);
                sparams.setDriverParams(this.params);
                sparams.setBand(-1);
                serverExplorer.add(provider, (NewDataStoreParameters)sparams, true);
                this.saveToRmf(finalFileName);
                t2 = new Date().getTime();
                if (this.incrementableTask != null) {
                    this.incrementableTask.processFinalize();
                    this.incrementableTask = null;
                }
                try {
                    Thread.sleep(600L);
                }
                catch (InterruptedException e) {
                    throw new ProcessInterruptedException((Throwable)e);
                }
                this.cutFinalize(finalFileName, t2 - t1);
            }
            catch (RasterDriverException e) {
                RasterSwingLibrary.messageBoxError((String)"error_writer", (Object)((Object)this), (Exception)((Object)e));
            }
            catch (ValidateDataParametersException e) {
                RasterSwingLibrary.messageBoxError((String)"error_georasterwriter", (Object)((Object)this));
            }
            catch (ProviderNotRegisteredException e) {
                RasterSwingLibrary.messageBoxError((String)"error_georasterwriter", (Object)((Object)this), (Exception)((Object)e));
            }
            catch (InitializeException e) {
                RasterSwingLibrary.messageBoxError((String)"error_georasterwriter", (Object)((Object)this), (Exception)((Object)e));
            }
            catch (DataException e) {
                RasterSwingLibrary.messageBoxError((String)"error_georasterwriter", (Object)((Object)this), (Exception)((Object)e));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (dstoreCopy != null) {
                    try {
                        dstoreCopy.close();
                    }
                    catch (CloseException e) {
                        LoggerFactory.getLogger(ClippingProcess.class).debug(Messages.getText((String)"error_writer"), (Throwable)e);
                    }
                }
                this.buffer = null;
            }
        }
    }

    private void drawOnlyROIs(Buffer buffer, List<ROI> rois, int despX, int despY) {
        for (int i = 0; i < buffer.getWidth(); ++i) {
            for (int j = 0; j < buffer.getHeight(); ++j) {
                boolean inside = false;
                for (int k = 0; k < rois.size(); ++k) {
                    ROI roi = rois.get(k);
                    if (!roi.isInsideOfPolygon(i + despX, j + despY)) continue;
                    inside = true;
                }
                if (inside) continue;
                for (int l = 0; l < buffer.getBandCount(); ++l) {
                    if (buffer.getDataType() == 0) {
                        buffer.setElem(j, i, l, buffer.getNoDataValue().isDefined() ? buffer.getNoDataValue().getValue().byteValue() : RasterLibrary.defaultByteNoDataValue);
                        continue;
                    }
                    if (buffer.getDataType() == 2) {
                        buffer.setElem(j, i, l, buffer.getNoDataValue().isDefined() ? buffer.getNoDataValue().getValue().shortValue() : RasterLibrary.defaultShortNoDataValue);
                        continue;
                    }
                    if (buffer.getDataType() == 3) {
                        buffer.setElem(j, i, l, buffer.getNoDataValue().isDefined() ? buffer.getNoDataValue().getValue().intValue() : RasterLibrary.defaultIntegerNoDataValue);
                        continue;
                    }
                    if (buffer.getDataType() == 4) {
                        buffer.setElem(j, i, l, buffer.getNoDataValue().isDefined() ? buffer.getNoDataValue().getValue().floatValue() : RasterLibrary.defaultFloatNoDataValue);
                        continue;
                    }
                    if (buffer.getDataType() != 5) continue;
                    buffer.setElem(j, i, l, buffer.getNoDataValue().isDefined() ? buffer.getNoDataValue().getValue().doubleValue() : RasterLibrary.defaultDoubleNoDataValue);
                }
            }
        }
    }

    private boolean isUsingFile(String fileName) {
        List docs = ProjectManager.getInstance().getCurrentProject().getDocuments();
        for (int i = 0; i < docs.size(); ++i) {
            if (!(docs.get(i) instanceof BaseViewDocument)) continue;
            FLayers lyrs = ((BaseViewDocument)docs.get(i)).getMapContext().getLayers();
            for (int j = 0; j < lyrs.getLayersCount(); ++j) {
                DefaultFLyrRaster lyr;
                if (!(lyrs.getLayer(j) instanceof DefaultFLyrRaster) || (lyr = (DefaultFLyrRaster)lyrs.getLayer(j)).getDataStore() == null || !fileName.equals(lyr.getDataStore().getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void cutFinalize(String fileName, long milis) {
        if (!new File(fileName).exists()) {
            return;
        }
        if (this.viewName != null && RasterSwingLibrary.messageBoxYesOrNot((String)"cargar_toc", null)) {
            try {
                FLayer lyr = RasterMainPluginUtils.loadLayer((String)this.viewName, (String)fileName, null);
                if (lyr != null && lyr instanceof DefaultFLyrRaster) {
                    if (this.dataStore.getProjection() != null) {
                        ((DefaultFLyrRaster)lyr).setRois(this.dataStore.getRois(this.dataStore.getProjection()));
                    } else {
                        ((DefaultFLyrRaster)lyr).setRois(this.dataStore.getRois(this.viewProjection));
                    }
                }
            }
            catch (RasterNotLoadException e) {
                RasterSwingLibrary.messageBoxError((String)"error_load_layer", (Object)((Object)this), (Exception)((Object)e));
            }
            catch (ROIException e) {
                RasterSwingLibrary.messageBoxError((String)"error_load_layer", (Object)((Object)this), (Exception)((Object)e));
            }
        }
        if (this.externalActions != null) {
            this.externalActions.end((Object)new Object[]{fileName, new Long(milis)});
        }
    }

    public int getPercent() {
        return this.processIncrement != null ? this.processIncrement.getPercent() : 0;
    }

    public String getTitle() {
        return Messages.getText((String)"incremento_recorte");
    }

    protected void finalize() throws Throwable {
        this.fileName = null;
        this.suffix = null;
        this.dataStore = null;
        this.drawableBands = null;
        this.pValues = null;
        this.viewName = null;
        this.params = null;
        this.colorInterp = null;
        this.affineTransform = null;
        this.wcValues = null;
        this.buffer = null;
        this.processIncrement = null;
        if (this.selectedRois != null) {
            this.selectedRois.clear();
            this.selectedRois = null;
        }
        super.finalize();
    }
}

