/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.colortable.data;

import java.util.ArrayList;
import java.util.Hashtable;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.util.PropertyEvent;
import org.gvsig.fmap.dal.coverage.util.PropertyListener;

public class ColorTableData {
    private ArrayList<PropertyListener> actionCommandListeners = new ArrayList();
    private Hashtable<String, Object> options = new Hashtable();

    public ColorTable getColorTable() {
        return (ColorTable)this.options.get("colorTable");
    }

    public void setColorTable(ColorTable colorTable) {
        this.setOption("colorTable", colorTable);
    }

    public double getMinim() {
        Double d = (Double)this.options.get("minim");
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public double getMaxim() {
        Double d = (Double)this.options.get("maxim");
        if (d != null) {
            return d;
        }
        return 255.0;
    }

    public boolean isLimitsEnabled() {
        Boolean b = (Boolean)this.options.get("limits");
        if (b != null) {
            return b;
        }
        return false;
    }

    public void setMinim(double value) {
        this.setOption("minim", new Double(value));
    }

    public void setMaxim(double value) {
        this.setOption("maxim", new Double(value));
    }

    public void setLimitsEnabled(boolean value) {
        this.setOption("limits", new Boolean(value));
    }

    public boolean isInterpolated() {
        Boolean n = (Boolean)this.options.get("interpolated");
        if (n != null) {
            return n;
        }
        return true;
    }

    public void setInterpolated(boolean value) {
        this.setOption("interpolated", new Boolean(value));
    }

    public boolean isEnabled() {
        Boolean n = (Boolean)this.options.get("enabled");
        if (n != null) {
            return n;
        }
        return true;
    }

    public void setEnabled(boolean value) {
        this.setOption("enabled", new Boolean(value));
    }

    public void refreshPreview() {
        this.setOption("refreshPreview", new Boolean(true));
    }

    private void setOption(String name, Object value) {
        this.options.put(name, value);
        this.callValueChangedListeners(name, value);
    }

    public void addValueChangedListener(PropertyListener listener) {
        if (!this.actionCommandListeners.contains(listener)) {
            this.actionCommandListeners.add(listener);
        }
    }

    public void removeValueChangedListener(PropertyListener listener) {
        this.actionCommandListeners.remove(listener);
    }

    private void callValueChangedListeners(String name, Object value) {
        for (PropertyListener listener : this.actionCommandListeners) {
            listener.actionValueChanged(new PropertyEvent((Object)this, name, value, null));
        }
    }
}

