/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.colortable.ui.library;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.ColorItem;
import org.gvsig.fmap.dal.coverage.datastruct.ColorTableLibrary;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.raster.tools.app.basic.raster.bean.stretchselector.StretchSelectorData;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.library.AddLibraryPanel;

public class AddLibraryWindow
extends JOptionPane {
    private static final long serialVersionUID = 1L;
    private AddLibraryPanel libraryPanel = null;
    private int limit_question = 500;

    private Object getMessageComponent() {
        return this.getLibraryPanel();
    }

    public AddLibraryPanel getLibraryPanel() {
        if (this.libraryPanel == null) {
            this.libraryPanel = new AddLibraryPanel();
        }
        return this.libraryPanel;
    }

    public int showConfirm(Component parentComponent) {
        return AddLibraryWindow.showConfirmDialog(parentComponent, this.getMessageComponent(), PluginServices.getText((Object)this, (String)"nueva_libreria_title"), 2, -1);
    }

    public ColorTable getColorTable() {
        ColorTableLibrary lib = RasterLocator.getManager().getDataStructFactory().getColorTableLibrary();
        ColorTable colorTable = lib.createColorTable();
        colorTable.setName(this.getLibraryPanel().getLibraryName().getText());
        ArrayList<ColorItem> items = new ArrayList<ColorItem>();
        StretchSelectorData stretchListData = this.getLibraryPanel().getStretchListPanel().getData();
        double start = stretchListData.getMinimum();
        double end = stretchListData.getMaximum();
        if (start > end) {
            double aux = start;
            start = end;
            end = aux;
        }
        double num = this.getLibraryPanel().getStretchListPanel().getInterval();
        boolean quest = false;
        if (this.getLibraryPanel().getStretchListPanel().getIntervalNumber().isSelected()) {
            quest = num > (double)this.limit_question;
        } else {
            boolean bl = quest = (end - start) / num > (double)this.limit_question;
        }
        if (quest && JOptionPane.showConfirmDialog(this, PluginServices.getText((Object)this, (String)"addlibrary_supera_limite"), PluginServices.getText((Object)this, (String)"confirmar"), 0) == 1) {
            return null;
        }
        if (this.getLibraryPanel().getStretchListPanel().getIntervalNumber().isSelected()) {
            for (double i = 0.0; i <= num; i += 1.0) {
                ColorItem colorItem = lib.createColorItem();
                colorItem.setValue(start + (end - start) / num * i);
                items.add(colorItem);
            }
        } else {
            for (double i = start; i <= end; i += num) {
                ColorItem colorItem = lib.createColorItem();
                colorItem.setValue(i);
                items.add(colorItem);
            }
        }
        colorTable.createPaletteFromColorItems(items, false);
        return colorTable;
    }
}

