/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.colortable.ui.library;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.ColorTableLibrary;
import org.gvsig.fmap.dal.coverage.exception.FilePaletteException;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.gui.ColorTablePainter;
import org.gvsig.gui.ColorTablesFactory;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.library.ColorTableIconPainter;
import org.gvsig.raster.tools.app.basic.tool.colortable.ui.library.ColorTableLibraryPanel;

public class RasterColorTablesFactory
implements ColorTablesFactory {
    private ColorTableLibrary tableLib = null;

    public RasterColorTablesFactory() {
        RasterManager rManager = RasterLocator.getManager();
        this.tableLib = rManager.getDataStructFactory().getColorTableLibrary();
    }

    public List<ColorTablePainter> createColorTables() {
        try {
            ArrayList<ColorTablePainter> result = new ArrayList<ColorTablePainter>();
            ArrayList fileList = this.tableLib.getPaletteFileList(ColorTableLibraryPanel.palettesPath);
            for (int i = 0; i < fileList.size(); ++i) {
                ArrayList paletteItems = new ArrayList();
                String paletteName = this.tableLib.loadPalette(ColorTableLibraryPanel.palettesPath, (String)fileList.get(i), paletteItems);
                if (paletteItems.size() <= 0) continue;
                ColorTable colorTable = this.tableLib.createColorTable();
                colorTable.setName(paletteName);
                colorTable.createPaletteFromColorItems(paletteItems, true);
                colorTable.setInterpolated(true);
                ColorTableIconPainter painter = new ColorTableIconPainter(colorTable);
                result.add(painter);
            }
            return result;
        }
        catch (FilePaletteException e) {
            RasterSwingLibrary.messageBoxError((String)e.getMessage(), (Object)this, (Exception)((Object)e));
            return null;
        }
    }
}

