/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.enhanced.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.fmap.dal.coverage.exception.HistogramException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.preview.PreviewBasePanelTab;
import org.gvsig.raster.tools.app.basic.tool.enhanced.graphics.InputHistogram;
import org.gvsig.raster.tools.app.basic.tool.enhanced.graphics.OutputHistogram;
import org.gvsig.raster.tools.app.basic.tool.enhanced.ui.EnhancedListener;
import org.gvsig.tools.locator.LocatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicsPanel
extends JPanel
implements PreviewBasePanelTab,
KeyListener {
    private static final long serialVersionUID = 1L;
    private Logger log = LoggerFactory.getLogger(GraphicsPanel.class);
    private InputHistogram input = null;
    private OutputHistogram output = null;
    private JPanel controls = null;
    private JLabel llevels = null;
    private JFormattedTextField tlevels = null;
    private JCheckBox cbRGB = null;
    private HistogramComputer hist = null;
    private BufferHistogram histRGB = null;
    private double[] minList = null;
    private double[] maxList = null;
    private FLyrRaster lyr = null;

    public GraphicsPanel(FLyrRaster lyr) {
        try {
            this.lyr = lyr;
            this.hist = lyr.getDataStore().getHistogramComputer();
            this.histRGB = RasterLocator.getManager().getRasterUtils().convertHistogramToRGB(this.hist.getBufferHistogram());
            this.minList = lyr.getDataStore().getStatistics().getMin();
            this.maxList = lyr.getDataStore().getStatistics().getMax();
            if (this.minList == null) {
                this.minList = new double[]{0.0};
            }
            if (this.maxList == null) {
                this.maxList = new double[]{255.0};
            }
        }
        catch (HistogramException e) {
            this.hist = null;
        }
        catch (LocatorException e) {
        }
        catch (ProcessInterruptedException e) {
            e.printStackTrace();
        }
        this.init();
        if (lyr.getDataStore().getDataType()[0] == 0) {
            this.getRGB().setSelected(true);
        } else {
            this.getRGB().setEnabled(false);
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"histograms"), 0, 0, null, null));
        GridBagConstraints gridBagConstraints = null;
        JLabel label1 = new JLabel(Messages.getText((String)"input_hist"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 10;
        label1.setHorizontalAlignment(0);
        label1.setPreferredSize(new Dimension(150, 14));
        this.add((Component)label1, gridBagConstraints);
        JLabel label2 = new JLabel(Messages.getText((String)"output_hist"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.anchor = 10;
        label2.setHorizontalAlignment(0);
        label2.setPreferredSize(new Dimension(150, 14));
        this.add((Component)label2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.getInputHistogram(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.getControls(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.getOutputHistogram(), gridBagConstraints);
        this.setLevelsEnabled(false);
    }

    public HistogramComputer getHistogram() {
        return this.hist;
    }

    public InputHistogram getInputHistogram() {
        if (this.input == null) {
            try {
                this.input = new InputHistogram(this.hist.getBufferHistogram(), this.lyr, this.minList, this.maxList);
                this.input.setHistogram(this.hist.getBufferHistogram(), this.minList, this.maxList);
            }
            catch (ProcessInterruptedException e) {
                this.log.debug("Proceso de calculo de histograma interrumpido", (Object)this, (Object)e);
            }
            catch (HistogramException e) {
                this.log.debug("Excepci\u00f3n en el c\u00e1lculo del histograma", (Object)this, (Object)e);
            }
        }
        return this.input;
    }

    public void updateHistogram() {
        if (this.getRGB().isSelected()) {
            double[] min = new double[this.minList.length];
            double[] max = new double[this.maxList.length];
            for (int i = 0; i < this.minList.length; ++i) {
                min[i] = 0.0;
                max[i] = 255.0;
            }
            this.input.setHistogram(this.histRGB, min, max);
        } else {
            try {
                this.input.setHistogram(this.hist.getBufferHistogram(), this.minList, this.maxList);
            }
            catch (ProcessInterruptedException e) {
                this.log.debug("Proceso de calculo de histograma interrumpido", (Object)this, (Object)e);
            }
            catch (HistogramException e) {
                this.log.debug("Excepci\u00f3n en el c\u00e1lculo del histograma", (Object)this, (Object)e);
            }
        }
    }

    public OutputHistogram getOutputHistogram() {
        if (this.output == null) {
            try {
                this.output = new OutputHistogram(this.hist.getBufferHistogram(), this.lyr, this.minList, this.maxList);
            }
            catch (ProcessInterruptedException e) {
                this.log.debug("Proceso de calculo de histograma interrumpido", (Object)this, (Object)e);
            }
            catch (HistogramException e) {
                this.log.debug("Excepci\u00f3n en el c\u00e1lculo del histograma", (Object)this, (Object)e);
            }
        }
        return this.output;
    }

    public JPanel getControls() {
        if (this.controls == null) {
            this.controls = new JPanel();
            this.controls.setLayout(new GridBagLayout());
            this.llevels = new JLabel(Messages.getText((String)"levels"));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.insets = new Insets(0, 5, 0, 5);
            gbc.fill = 1;
            this.controls.add((Component)this.llevels, gbc);
            gbc.gridy = 1;
            this.controls.add((Component)this.getLevels(), gbc);
            gbc.gridy = 2;
            this.controls.add((Component)this.getRGB(), gbc);
        }
        return this.controls;
    }

    public void setLevelsEnabled(boolean enabled) {
        this.getLevels().setEnabled(enabled);
        if (enabled) {
            this.getLevels().setBackground(Color.WHITE);
        } else {
            this.getLevels().setBackground(this.getControls().getBackground());
        }
    }

    public JFormattedTextField getLevels() {
        if (this.tlevels == null) {
            NumberFormat doubleDisplayFormat = NumberFormat.getNumberInstance();
            doubleDisplayFormat.setMinimumFractionDigits(0);
            NumberFormat doubleEditFormat = NumberFormat.getNumberInstance();
            this.tlevels = new JFormattedTextField(new DefaultFormatterFactory(new NumberFormatter(doubleDisplayFormat), new NumberFormatter(doubleDisplayFormat), new NumberFormatter(doubleEditFormat)));
            this.tlevels.addKeyListener(this);
        }
        return this.tlevels;
    }

    public JCheckBox getRGB() {
        if (this.cbRGB == null) {
            this.cbRGB = new JCheckBox("RGB");
        }
        return this.cbRGB;
    }

    public JPanel getPanel() {
        return this;
    }

    public String getTitle() {
        return "";
    }

    public void setListener(EnhancedListener listener) {
        this.getInputHistogram().setListener(listener);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Long lValue = (Long)this.getLevels().getValue();
        int value = lValue.intValue();
        boolean change = false;
        switch (e.getKeyCode()) {
            case 38: {
                ++value;
                change = true;
                break;
            }
            case 40: {
                --value;
                change = true;
            }
        }
        if (change) {
            if (value > 30) {
                value = 30;
            }
            if (value < 2) {
                value = 2;
            }
            if (!this.getLevels().getValue().equals(new Long(value))) {
                this.getLevels().setValue(new Long(value));
                this.getLevels().postActionEvent();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

