/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.filter;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ListModel;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Param;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterManagerException;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.FilterUIListener;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterListManager;
import org.gvsig.fmap.dal.coverage.grid.RegistrableFilterListener;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.gui.beans.propertiespanel.PropertiesComponent;
import org.gvsig.gui.beans.propertiespanel.PropertiesComponentListener;
import org.gvsig.gui.beans.propertiespanel.PropertyStruct;
import org.gvsig.gui.beans.treelist.event.TreeListChangeEvent;
import org.gvsig.gui.beans.treelist.event.TreeListEvent;
import org.gvsig.gui.beans.treelist.listeners.TreeListChangeListener;
import org.gvsig.gui.beans.treelist.listeners.TreeListComponentListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.raster.bean.previewbase.ParamStruct;
import org.gvsig.raster.tools.app.basic.raster.process.FilterProcess;
import org.gvsig.raster.tools.app.basic.raster.process.IProcessActions;
import org.gvsig.raster.tools.app.basic.tool.filter.ui.FilterPanel;
import org.gvsig.raster.util.RasterNotLoadException;

public class FilterListener
implements ActionListener,
TreeListComponentListener,
TreeListChangeListener,
PropertiesComponentListener,
FilterUIListener,
IProcessActions {
    private FilterPanel filterPanel = null;
    private int actualParam = -1;
    private ArrayList<ParamStruct> paramsList = new ArrayList();

    public FilterListener(FilterPanel filterPanel) {
        this.filterPanel = filterPanel;
    }

    public void refreshDataProperties() {
        if (this.actualParam == -1) {
            return;
        }
        ArrayList listValues = this.getFilterPanel().getPropertiesComponent().getValues();
        Params params = this.paramsList.get(this.actualParam).getFilterParam();
        for (int j = 0; j < listValues.size(); ++j) {
            PropertyStruct ps = (PropertyStruct)listValues.get(j);
            params.changeParamValue(ps.getKey(), ps.getNewValue());
        }
    }

    private int getParamSelected(String filterName) {
        for (int i = 0; i < this.paramsList.size(); ++i) {
            if (!this.paramsList.get(i).getFilterName().equals(filterName)) continue;
            return i;
        }
        return -1;
    }

    public void changePanel(String filter) {
        Params params;
        int posParam = this.getParamSelected(filter);
        this.refreshDataProperties();
        this.actualParam = posParam;
        PropertiesComponent propertiesComponent = new PropertiesComponent();
        if (posParam != -1 && (params = this.paramsList.get(this.actualParam).getFilterParam()) != null) {
            Param paramPanel = params.getParamById("Panel");
            if (paramPanel != null && paramPanel.getDefaultValue() instanceof RegistrableFilterListener) {
                ((RegistrableFilterListener)paramPanel.getDefaultValue()).addFilterUIListener((FilterUIListener)this);
            }
            RasterToolsUtil.loadPropertiesFromWriterParams(propertiesComponent, params, new String[]{"FilterName"});
        }
        this.getFilterPanel().setNewPropertiesComponent(propertiesComponent, filter);
    }

    public void addNewParam(String name, Params params, Class<?> classFilter) {
        ParamStruct param = new ParamStruct();
        param.setFilterName(name);
        param.setFilterParam(params);
        param.setFilterClass(classFilter);
        this.paramsList.add(param);
    }

    public void actionChangeProperties(EventObject e) {
        this.refreshDataProperties();
        this.getFilterPanel().refreshPreview();
    }

    public void actionChangeSelection(TreeListChangeEvent e) {
        this.changePanel(e.getItem());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getFilterPanel().refreshPreview();
    }

    public void elementAdded(TreeListEvent e) {
        this.getFilterPanel().refreshPreview();
    }

    public void elementMoved(TreeListEvent e) {
        this.getFilterPanel().refreshPreview();
    }

    public void elementRemoved(TreeListEvent e) {
        this.getFilterPanel().refreshPreview();
    }

    public ArrayList<ParamStruct> getParamsList() {
        return this.paramsList;
    }

    public ArrayList<ParamStruct> applyFilters(FLyrRaster layerRaster) {
        ArrayList<ParamStruct> listFilterUsed = new ArrayList<ParamStruct>();
        int initDataType = layerRaster.getRender().getFilterList().getInitDataType();
        RasterFilterList filterList = RasterLocator.getManager().createEmptyFilterList(initDataType);
        filterList.setEnv(layerRaster.getRender().getFilterList().getEnv());
        filterList.setInitDataType(initDataType);
        List registeredFilters = filterList.getRegisteredFilterList();
        List filtersInit = this.getFilterPanel().getLayerVisualStatus().getLast().getFilterStatus();
        for (int i = 0; i < filtersInit.size(); ++i) {
            if (((RasterFilter)filtersInit.get(i)).isVisible()) continue;
            RasterFilter obj = null;
            for (int j = 0; j < registeredFilters.size(); ++j) {
                Class classFilter = (Class)registeredFilters.get(j);
                try {
                    obj = (RasterFilter)classFilter.newInstance();
                    if (!obj.getName().equals(((RasterFilter)filtersInit.get(i)).getName())) continue;
                    break;
                }
                catch (InstantiationException e) {
                    RasterSwingLibrary.messageBoxError((String)"error_creando_filtro", (Object)this, (Exception)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    RasterSwingLibrary.messageBoxError((String)"error_creando_filtro", (Object)this, (Exception)e);
                }
            }
            if (obj == null) continue;
            try {
                Params params = (Params)((RasterFilter)filtersInit.get(i)).getUIParams(((RasterFilter)filtersInit.get(i)).getName()).clone();
                int[] renderBands = layerRaster.getRender().getRenderColorInterpretation().buildRenderBands();
                String rgb = renderBands[0] + " " + renderBands[1] + " " + renderBands[2];
                params.setParam("RenderBands", (Object)rgb, 0, null);
                params.setParam("alphaBand", (Object)new Integer(layerRaster.getAlphaBandNumber()), 0, null);
                ParamStruct newParam = new ParamStruct();
                newParam.setFilterClass(obj.getClass());
                newParam.setFilterName(((RasterFilter)filtersInit.get(i)).getName());
                newParam.setFilterParam(params);
                listFilterUsed.add(newParam);
                continue;
            }
            catch (CloneNotSupportedException params) {
                // empty catch block
            }
        }
        ListModel list = this.getFilterPanel().getMainPanel().getTreeListContainer().getListModel();
        for (int i = 0; i < list.getSize(); ++i) {
            Hashtable hastTable = this.getFilterPanel().getMainPanel().getTreeListContainer().getMap();
            for (int j = 0; j < this.paramsList.size(); ++j) {
                boolean active = true;
                Param param = this.paramsList.get(j).getFilterParam().getParamById("enabled");
                if (param != null && param.getDefaultValue() instanceof Boolean && !((Boolean)param.getDefaultValue()).booleanValue()) {
                    active = false;
                }
                if (!active || !this.paramsList.get(j).getFilterName().equals(hastTable.get(list.getElementAt(i)))) continue;
                try {
                    Params params = (Params)this.paramsList.get(j).getFilterParam().clone();
                    int[] renderBands = layerRaster.getRender().getRenderColorInterpretation().buildRenderBands();
                    String rgb = renderBands[0] + " " + renderBands[1] + " " + renderBands[2];
                    params.setParam("RenderBands", (Object)rgb, 0, null);
                    params.setParam("alphaBand", (Object)new Integer(layerRaster.getAlphaBandNumber()), 0, null);
                    ParamStruct newParam = new ParamStruct();
                    newParam.setFilterClass(this.paramsList.get(j).getFilterClass());
                    newParam.setFilterName(this.paramsList.get(j).getFilterName());
                    newParam.setFilterParam(params);
                    listFilterUsed.add(newParam);
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
        }
        return listFilterUsed;
    }

    public void drawImage(FLyrRaster rendering) {
        rendering.getRender().getFilterList().clear();
        if (this.getFilterPanel().getCBShowFilters().isSelected()) {
            RasterFilterList filterList = rendering.getRender().getFilterList();
            ArrayList<ParamStruct> listFilterUsed = this.applyFilters(rendering);
            ArrayList<Throwable> exc = new ArrayList<Throwable>();
            for (int i = 0; i < listFilterUsed.size(); ++i) {
                try {
                    RasterFilterListManager filterManager = filterList.getManagerByFilterClass(listFilterUsed.get(i).getFilterClass());
                    filterManager.addFilter(listFilterUsed.get(i).getFilterClass(), listFilterUsed.get(i).getFilterParam());
                    continue;
                }
                catch (FilterTypeException e) {
                    exc.add(e);
                    continue;
                }
                catch (FilterManagerException e1) {
                    exc.add(e1);
                }
            }
            if (exc.size() != 0) {
                RasterSwingLibrary.messageBoxError((String)PluginServices.getText((Object)this, (String)"error_adding_filters"), (Object)this, exc);
                exc.clear();
            }
        }
    }

    public void accept() {
        RasterDataStore raster = this.getFilterPanel().getLayer().getDataStore();
        if (raster == null) {
            return;
        }
        String path = null;
        if (!this.getFilterPanel().getNewLayerPanel().isOnlyViewSelected() && (path = this.getFilterPanel().getNewLayerPanel().getFileSelected()) == null) {
            return;
        }
        FLyrRaster rendering = this.getFilterPanel().getLayer();
        ArrayList<ParamStruct> listFilterUsed = this.applyFilters(rendering);
        if (this.filterPanel.getNewLayerPanel().isOnlyViewSelected()) {
            try {
                ParamStruct.addSelectedFilters(rendering.getRender().getFilterList(), listFilterUsed);
                this.getFilterPanel().getLayer().getRender().setFilterList(rendering.getRender().getFilterList());
                this.getFilterPanel().getLayer().getMapContext().invalidate();
            }
            catch (FilterTypeException e) {
                RasterSwingLibrary.messageBoxError((String)PluginServices.getText((Object)this, (String)"error_adding_filters"), (Object)this, (Exception)((Object)e));
            }
            catch (FilterManagerException e) {
                RasterSwingLibrary.messageBoxError((String)PluginServices.getText((Object)this, (String)"error_adding_filters"), (Object)this, (Exception)((Object)e));
            }
        } else {
            FilterProcess filterProcess = new FilterProcess();
            filterProcess.setActions(this);
            filterProcess.addParam("rendering", rendering);
            filterProcess.addParam("filename", path);
            filterProcess.addParam("rasterdatasource", raster);
            filterProcess.addParam("layer", this.getFilterPanel().getLayer());
            filterProcess.addParam("listfilterused", listFilterUsed);
            filterProcess.start();
            filterProcess = null;
        }
    }

    public FilterPanel getFilterPanel() {
        return this.filterPanel;
    }

    public void loadLayerInToc(String fileName) {
        if (!this.getFilterPanel().getNewLayerPanel().isNewLayerSelected()) {
            return;
        }
        if (!new File(fileName).exists()) {
            return;
        }
        try {
            RasterToolsUtil.loadLayer(this.getFilterPanel().getViewName(), fileName, null);
        }
        catch (RasterNotLoadException e) {
            RasterSwingLibrary.messageBoxError((String)"error_cargar_capa", (Object)this, (Exception)((Object)e));
        }
        if (this.filterPanel != null) {
            this.filterPanel.updateNewLayerText();
        }
    }

    public void actionValuesCompleted(EventObject e) {
        this.actionChangeProperties(e);
    }

    @Override
    public void end(Object param) {
        this.loadLayerInToc((String)param);
    }

    @Override
    public void interrupted() {
    }
}

