/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.filter.mask;

import java.util.ArrayList;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterAddException;
import org.gvsig.fmap.dal.coverage.grid.filter.BaseRasterFilter;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.tools.app.basic.tool.filter.mask.MaskListManager;
import org.gvsig.raster.tools.app.basic.tool.filter.mask.MaskUI;

public class MaskFilter
extends BaseRasterFilter {
    public static String[] names = new String[]{MaskListManager.ID};
    protected MaskUI maskUI = null;
    protected ArrayList<ROI> rois = null;
    protected boolean inverse = false;
    protected Extent bufferExtent = null;
    protected NoData noData = null;
    protected double cellsize = 0.0;

    public MaskFilter() {
        this.setName(names[0]);
    }

    public String getGroup() {
        return "mascaras";
    }

    public String[] getNames() {
        return names;
    }

    public Params getUIParams(String nameFilter) {
        Params params = RasterLocator.getManager().createParams("Panel", (Object)this.getMaskUI(), -1, null);
        params.setParam("FilterName", (Object)nameFilter, -1, null);
        return params;
    }

    private MaskUI getMaskUI() {
        if (this.maskUI == null) {
            this.maskUI = new MaskUI();
            FLyrRaster raster = (FLyrRaster)this.getEnv().get("initRaster");
            this.maskUI.setRois(this.rois);
            this.maskUI.setLayer(raster);
        }
        return this.maskUI;
    }

    public void pre() throws FilterAddException {
        super.pre();
        Boolean inverseBoolean = (Boolean)this.params.get("inverse");
        if (inverseBoolean != null) {
            this.inverse = inverseBoolean;
        }
        this.rois = (ArrayList)this.params.get("rois");
        if (this.raster.getDataExtent() == null) {
            throw new FilterAddException("Buffer extension cannot be null");
        }
        this.bufferExtent = RasterLocator.getManager().getDataStructFactory().createExtent(this.raster.getDataExtent());
        this.cellsize = this.raster.getDataExtent().getWidth() / (double)this.raster.getWidth();
        this.createBufferResult(this.raster.getDataType(), this.raster.getBandCount());
    }

    public void process(int x, int y) {
    }

    public void post() {
        this.rasterResult.setNoDataValue(this.noData);
    }

    public int getInRasterDataType() {
        return 0;
    }

    public int getOutRasterDataType() {
        return 0;
    }
}

