/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.filter.mask;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.AbstractRasterFilterManager;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.RegistrableFilterListener;
import org.gvsig.raster.roi.ROI;
import org.gvsig.raster.tools.app.basic.tool.filter.mask.MaskByteFilter;
import org.gvsig.raster.tools.app.basic.tool.filter.mask.MaskFilter;
import org.gvsig.raster.tools.app.basic.tool.filter.mask.MaskUI;

public class MaskListManager
extends AbstractRasterFilterManager {
    public static String ID = "Mask";

    public MaskListManager(RasterFilterList filterList) {
        super(filterList);
    }

    public String getManagerID() {
        return ID;
    }

    public static void register() {
        AbstractRasterFilterManager.register((String)ID, MaskListManager.class, MaskUI.class);
    }

    public boolean isDataTypeSupported(int dataType) {
        return true;
    }

    public Class<?> getFilterClassByID(String id) {
        if (id.compareTo("mask") == 0) {
            return MaskFilter.class;
        }
        return null;
    }

    public void addMaskFilter(List<ROI> rois, NoData noData, Boolean inverse, Boolean transp) throws FilterTypeException {
        MaskByteFilter filter = new MaskByteFilter();
        if (filter != null) {
            filter.addParam("rois", rois);
            filter.addParam("nodata", noData);
            filter.addParam("inverse", inverse);
            filter.addParam("transparency", transp);
            this.getFilterList().add((RasterFilter)filter);
        }
    }

    public List<Class<?>> getRasterFilterList() {
        ArrayList filters = new ArrayList();
        filters.add(MaskFilter.class);
        return filters;
    }

    public RasterFilter createFilter(Params params) {
        ArrayList rois = (ArrayList)params.getParamById("rois").getDefaultValue();
        NoData nodata = (NoData)params.getParamById("nodata").getDefaultValue();
        Boolean inverse = (Boolean)params.getParamById("inverse").getDefaultValue();
        Boolean transparency = (Boolean)params.getParamById("transparency").getDefaultValue();
        MaskByteFilter filter = new MaskByteFilter();
        filter.addParam("rois", rois);
        filter.addParam("inverse", inverse);
        filter.addParam("transparency", transparency);
        filter.addParam("nodata", nodata);
        return filter;
    }

    public void addFilter(Params params) throws FilterTypeException {
        this.addFilter(MaskFilter.class, params);
    }

    public void addFilter(Class<?> classFilter, Params params) throws FilterTypeException {
        if (classFilter.equals(MaskFilter.class)) {
            int i;
            ArrayList rois = new ArrayList();
            Boolean inverse = new Boolean(false);
            Boolean transp = new Boolean(false);
            NoData nodata = RasterLocator.getManager().getDataStructFactory().createNoData(null, null, null, 1);
            Params paramsUI = null;
            for (i = 0; i < params.getNumParams(); ++i) {
                if (!params.getParam(i).getId().equals("Panel") || !(params.getParam(i).getDefaultValue() instanceof RegistrableFilterListener)) continue;
                paramsUI = ((RegistrableFilterListener)params.getParam(i).getDefaultValue()).getParams();
            }
            if (paramsUI != null) {
                for (i = 0; i < paramsUI.getNumParams(); ++i) {
                    if (paramsUI.getParam(i).getId().equals("rois")) {
                        rois = (ArrayList)paramsUI.getParam(i).getDefaultValue();
                    }
                    if (paramsUI.getParam(i).getId().equals("inverse")) {
                        inverse = (Boolean)paramsUI.getParam(i).getDefaultValue();
                    }
                    if (paramsUI.getParam(i).getId().equals("nodata")) {
                        nodata = (NoData)paramsUI.getParam(i).getDefaultValue();
                    }
                    if (!paramsUI.getParam(i).getId().equals("transparency")) continue;
                    transp = (Boolean)paramsUI.getParam(i).getDefaultValue();
                }
            }
            this.addMaskFilter(rois, nodata, inverse, transp);
        }
    }

    public int createFilterListFromStrings(List<String> filters, String fil, int filteri) throws FilterTypeException {
        return filteri;
    }

    public List<String> getStringsFromFilterList(List<String> filterList, RasterFilter rf) {
        return filterList;
    }
}

