/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.geolocation.behavior;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.ITransformIO;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.RotationBehavior;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.ScaleBehavior;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.ShearBehavior;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.TransformationBehavior;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.TranslateBehavior;

public class GeoRasterBehavior
extends Behavior {
    private Image curImage = null;
    private Image notValid = IconThemeHelper.getImage((String)"not-valid-cursor");
    private IView theView = null;
    private TransformationBehavior[] behavior = new TransformationBehavior[4];
    private FLyrRaster lyr = null;

    public GeoRasterBehavior(PanListener zili, ITransformIO windowIO) {
        this.curImage = zili.getImageCursor();
        this.behavior[0] = new TranslateBehavior(this, this.curImage, windowIO);
        this.behavior[1] = new ScaleBehavior(this, this.curImage, windowIO);
        this.behavior[2] = new RotationBehavior(this, this.curImage, windowIO);
        this.behavior[3] = new ShearBehavior(this, this.curImage, windowIO);
    }

    public GeoRasterBehavior(PanListener zili, ITransformIO windowIO, FLyrRaster lyr) {
        this(zili, windowIO);
        this.lyr = lyr;
    }

    public void setLayer(FLyrRaster lyr) {
        this.lyr = lyr;
    }

    public void setITransformIO(ITransformIO gld) {
        for (int i = 0; i < this.behavior.length; ++i) {
            this.behavior[i].setITransformIO(gld);
        }
    }

    public FLyrRaster getLayer() {
        if (this.lyr != null) {
            return this.lyr;
        }
        IWindow w = PluginServices.getMDIManager().getActiveWindow();
        if (w instanceof IView) {
            this.theView = (IView)w;
            FLayers lyrs = this.theView.getMapControl().getMapContext().getLayers();
            for (int i = 0; i < lyrs.getActives().length; ++i) {
                if (!(lyrs.getActives()[i] instanceof FLyrRaster)) continue;
                return (FLyrRaster)lyrs.getActives()[i];
            }
        }
        return null;
    }

    public void mouseMoved(MouseEvent e) throws BehaviorException {
        this.behavior[0].setActiveTool(false);
        this.behavior[1].setActiveTool(false);
        this.behavior[2].setActiveTool(false);
        this.behavior[3].setActiveTool(false);
        if (this.behavior[1].mouseMoved(e) || this.behavior[0].mouseMoved(e) || this.behavior[2].mouseMoved(e) || !this.behavior[3].mouseMoved(e)) {
            // empty if block
        }
    }

    public void mousePressed(MouseEvent e) throws BehaviorException {
        if (this.behavior[1].isActiveTool()) {
            this.behavior[1].mousePressed(e);
        } else if (this.behavior[0].isActiveTool()) {
            this.behavior[0].mousePressed(e);
        } else if (this.behavior[2].isActiveTool()) {
            this.behavior[2].mousePressed(e);
        } else if (this.behavior[3].isActiveTool()) {
            this.behavior[3].mousePressed(e);
        }
    }

    public void mouseReleased(MouseEvent e) throws BehaviorException {
        if (this.behavior[1].isActiveTool()) {
            this.behavior[1].mouseReleased(e);
        } else if (this.behavior[0].isActiveTool()) {
            this.behavior[0].mouseReleased(e);
        } else if (this.behavior[2].isActiveTool()) {
            this.behavior[2].mouseReleased(e);
        } else if (this.behavior[3].isActiveTool()) {
            this.behavior[3].mouseReleased(e);
        }
    }

    public void paintComponent(MapControlDrawer mapControlDrawer) {
        super.paintComponent(mapControlDrawer);
        if (this.behavior[1].isActiveTool()) {
            this.behavior[1].paintComponent(mapControlDrawer);
        } else if (this.behavior[0].isActiveTool()) {
            this.behavior[0].paintComponent(mapControlDrawer);
        } else if (this.behavior[2].isActiveTool()) {
            this.behavior[2].paintComponent(mapControlDrawer);
        } else if (this.behavior[3].isActiveTool()) {
            this.behavior[3].paintComponent(mapControlDrawer);
        }
    }

    public void mouseDragged(MouseEvent e) throws BehaviorException {
        if (this.behavior[1].isActiveTool()) {
            this.behavior[1].mouseDragged(e);
        } else if (this.behavior[0].isActiveTool()) {
            this.behavior[0].mouseDragged(e);
        } else if (this.behavior[2].isActiveTool()) {
            this.behavior[2].mouseDragged(e);
        } else if (this.behavior[3].isActiveTool()) {
            this.behavior[3].mouseDragged(e);
        }
    }

    public ToolListener getListener() {
        return null;
    }

    public MapControl getMapControl() {
        return super.getMapControl();
    }

    public void mouseClicked(MouseEvent e) throws BehaviorException {
        super.mouseClicked(e);
    }

    public void mouseEntered(MouseEvent e) throws BehaviorException {
        super.mouseEntered(e);
    }

    public void mouseExited(MouseEvent e) throws BehaviorException {
        super.mouseExited(e);
    }

    public void mouseWheelMoved(MouseWheelEvent e) throws BehaviorException {
        super.mouseWheelMoved(e);
    }

    public void setMapControl(MapControl mc) {
        super.setMapControl(mc);
    }

    public void setCursorImage(Image cursor) {
        this.curImage = cursor;
    }

    public Image getImageCursor() {
        return this.curImage;
    }

    public void resetDefaultCursor() {
        this.curImage = this.notValid;
    }
}

