/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.geolocation.behavior;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.GeoRasterBehavior;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.ITransformIO;
import org.gvsig.raster.tools.app.basic.tool.geolocation.behavior.TransformationBehavior;

public class RotationBehavior
extends TransformationBehavior {
    private int PX_SELEC_BASE = 12;
    private int LONG_CORNER_BASE = 18;
    private int PX_SELEC = this.PX_SELEC_BASE;
    private int LONG_CORNER = this.LONG_CORNER_BASE;
    private Color rectangleColor = Color.RED;
    private RectangleListener listener;
    private Image rotImg = IconThemeHelper.getImage((String)"rotate-cursor");
    private Point2D beforePoint = null;
    private Point2D nextPoint = null;
    private boolean isRotable = false;
    private AffineTransform boxRot = null;
    private double rotation = 0.0;
    private boolean[] cornerActive = new boolean[]{false, false, false, false};
    private boolean init = false;
    private double incrRot = 0.005;

    public RotationBehavior(GeoRasterBehavior grb, Image curImage, ITransformIO windowIO) {
        this.grBehavior = grb;
        this.defaultImage = curImage;
        this.trIO = windowIO;
    }

    private void init() {
        ViewPort vp = this.grBehavior.getMapControl().getMapContext().getViewPort();
        this.lyr = this.grBehavior.getLayer();
        if (this.lyr == null) {
            return;
        }
        Extent ext = this.lyr.getDataStore().getExtent();
        AffineTransform atImg = this.lyr.getDataStore().getAffineTransform();
        Point2D.Double ul = new Point2D.Double(ext.getULX(), ext.getULY());
        Point2D.Double lr = new Point2D.Double(ext.getLRX(), ext.getLRY());
        Point2D.Double ulPx = new Point2D.Double();
        Point2D.Double lrPx = new Point2D.Double();
        Point2D ulVp = new Point2D.Double();
        Point2D lrVp = new Point2D.Double();
        double esc = 1.0;
        try {
            atImg.inverseTransform(ul, ulPx);
            atImg.inverseTransform(lr, lrPx);
            ulVp = vp.fromMapPoint((Point2D)ul);
            lrVp = vp.fromMapPoint((Point2D)lr);
            esc = Math.abs(((Point2D)lrPx).getX() - ((Point2D)ulPx).getX()) / Math.abs(lrVp.getX() - ulVp.getX());
        }
        catch (NoninvertibleTransformException e1) {
            return;
        }
        this.PX_SELEC = (int)((double)this.PX_SELEC_BASE * esc);
        this.LONG_CORNER = (int)((double)this.LONG_CORNER_BASE * esc);
        this.init = true;
    }

    @Override
    public void paintComponent(MapControlDrawer mapcontrolDrawer) {
        if (this.lyr == null) {
            this.lyr = this.grBehavior.getLayer();
        }
        if (this.isRotable && this.lyr != null) {
            try {
                ViewPort vp = this.grBehavior.getMapControl().getMapContext().getViewPort();
                AffineTransform at = new AffineTransform(this.lyr.getAffineTransform());
                Extent ext = this.lyr.getFullRasterExtent();
                Point2D.Double center = new Point2D.Double(this.lyr.getDataStore().getWidth() / 2.0, this.lyr.getDataStore().getHeight() / 2.0);
                at.transform(center, center);
                Point2D.Double ul = new Point2D.Double(ext.getULX(), ext.getULY());
                Point2D.Double lr = new Point2D.Double(ext.getLRX(), ext.getLRY());
                AffineTransform T1 = new AffineTransform(1.0, 0.0, 0.0, 1.0, -((Point2D)center).getX(), -((Point2D)center).getY());
                AffineTransform R1 = new AffineTransform();
                R1.setToRotation(this.rotation);
                AffineTransform T2 = new AffineTransform(1.0, 0.0, 0.0, 1.0, ((Point2D)center).getX(), ((Point2D)center).getY());
                T2.concatenate(R1);
                T2.concatenate(T1);
                T2.transform(ul, ul);
                T2.transform(lr, lr);
                at.preConcatenate(T2);
                this.boxRot = new AffineTransform(at);
                at.preConcatenate(vp.getAffineTransform());
                vp.getAffineTransform().transform(ul, ul);
                at.inverseTransform(ul, ul);
                vp.getAffineTransform().transform(lr, lr);
                at.inverseTransform(lr, lr);
                mapcontrolDrawer.transform(at);
                mapcontrolDrawer.setColor(this.rectangleColor);
                mapcontrolDrawer.setComposite((Composite)AlphaComposite.getInstance(3, 0.1f));
                mapcontrolDrawer.fillRect((int)((Point2D)ul).getX(), (int)((Point2D)ul).getY(), (int)((Point2D)lr).getX(), (int)((Point2D)lr).getY());
                mapcontrolDrawer.setComposite((Composite)AlphaComposite.getInstance(3, 1.0f));
                mapcontrolDrawer.drawRect((int)((Point2D)ul).getX(), (int)((Point2D)ul).getY(), (int)((Point2D)lr).getX(), (int)((Point2D)lr).getY());
                mapcontrolDrawer.transform(at.createInverse());
            }
            catch (NoninvertibleTransformException e1) {
                RasterSwingLibrary.messageBoxError((String)"error_transformacion1", (Object)this, (Exception)e1);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            ViewPort vp = this.grBehavior.getMapControl().getMapContext().getViewPort();
            this.beforePoint = vp.toMapPoint((Point2D)e.getPoint());
            if (this.lyr == null) {
                this.lyr = this.grBehavior.getLayer();
            }
            this.isRotable = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) throws BehaviorException {
        if (e.getButton() == 1) {
            if (this.boxRot != null) {
                this.lyr.setAffineTransform(this.boxRot);
            }
            this.rotation = 0.0;
            this.grBehavior.getMapControl().getMapContext().invalidate();
            this.isRotable = false;
            super.mouseReleased(e);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        ViewPort vp = this.grBehavior.getMapControl().getMapContext().getViewPort();
        this.nextPoint = vp.toMapPoint((Point2D)e.getPoint());
        this.rotation = (this.cornerActive[0] || this.cornerActive[2]) && this.beforePoint.getY() < this.nextPoint.getY() || (this.cornerActive[1] || this.cornerActive[3]) && this.beforePoint.getY() >= this.nextPoint.getY() ? (this.rotation += this.incrRot) : (this.rotation -= this.incrRot);
        this.beforePoint = vp.toMapPoint((Point2D)e.getPoint());
        if (this.boxRot != null) {
            this.trIO.loadTransform(this.boxRot);
        }
        this.grBehavior.getMapControl().repaint();
    }

    public void setListener(ToolListener listener) {
        this.listener = (RectangleListener)listener;
    }

    public ToolListener getListener() {
        return this.listener;
    }

    @Override
    public boolean mouseMoved(MouseEvent ev) throws BehaviorException {
        if (!this.init) {
            this.init();
        }
        ViewPort vp = this.grBehavior.getMapControl().getMapContext().getViewPort();
        this.resetBorderSelected();
        this.lyr = this.grBehavior.getLayer();
        if (this.lyr == null) {
            this.setActiveTool(false);
            return false;
        }
        AffineTransform atImg = this.lyr.getAffineTransform();
        Point2D e = vp.toMapPoint(ev.getX(), ev.getY());
        try {
            atImg.inverseTransform(e, e);
        }
        catch (NoninvertibleTransformException e1) {
            return false;
        }
        Point2D.Double p1 = new Point2D.Double(0.0, 0.0);
        Point2D.Double p2 = new Point2D.Double(this.lyr.getDataStore().getWidth(), this.lyr.getDataStore().getHeight());
        if (e.getX() > ((Point2D)p1).getX() - (double)this.PX_SELEC && e.getX() <= ((Point2D)p1).getX() + (double)this.LONG_CORNER && e.getY() <= ((Point2D)p1).getY() && e.getY() > ((Point2D)p1).getY() - (double)this.PX_SELEC || e.getX() <= ((Point2D)p1).getX() && e.getX() > ((Point2D)p1).getX() - (double)this.PX_SELEC && e.getY() > ((Point2D)p1).getY() && e.getY() <= ((Point2D)p1).getY() + (double)this.LONG_CORNER) {
            this.grBehavior.setCursorImage(this.rotImg);
            this.setActiveTool(true);
            this.cornerActive[1] = true;
            return true;
        }
        if (e.getX() >= ((Point2D)p2).getX() - (double)this.LONG_CORNER && e.getX() < ((Point2D)p2).getX() + (double)this.PX_SELEC && e.getY() <= ((Point2D)p1).getY() && e.getY() > ((Point2D)p1).getY() - (double)this.PX_SELEC || e.getX() >= ((Point2D)p2).getX() && e.getX() < ((Point2D)p2).getX() + (double)this.PX_SELEC && e.getY() > ((Point2D)p1).getY() && e.getY() <= ((Point2D)p1).getY() + (double)this.LONG_CORNER) {
            this.grBehavior.setCursorImage(this.rotImg);
            this.setActiveTool(true);
            this.cornerActive[0] = true;
            return true;
        }
        if (e.getX() > ((Point2D)p1).getX() - (double)this.PX_SELEC && e.getX() <= ((Point2D)p1).getX() + (double)this.LONG_CORNER && e.getY() >= ((Point2D)p2).getY() && e.getY() < ((Point2D)p2).getY() + (double)this.PX_SELEC || e.getX() <= ((Point2D)p1).getX() && e.getX() > ((Point2D)p1).getX() - (double)this.PX_SELEC && e.getY() < ((Point2D)p2).getY() && e.getY() >= ((Point2D)p2).getY() - (double)this.LONG_CORNER) {
            this.grBehavior.setCursorImage(this.rotImg);
            this.setActiveTool(true);
            this.cornerActive[3] = true;
            return true;
        }
        if (e.getX() < ((Point2D)p2).getX() + (double)this.PX_SELEC && e.getX() >= ((Point2D)p2).getX() - (double)this.LONG_CORNER && e.getY() >= ((Point2D)p2).getY() && e.getY() < ((Point2D)p2).getY() + (double)this.PX_SELEC || e.getX() >= ((Point2D)p2).getX() && e.getX() <= ((Point2D)p2).getX() + (double)this.PX_SELEC && e.getY() < ((Point2D)p2).getY() && e.getY() >= ((Point2D)p2).getY() - (double)this.LONG_CORNER) {
            this.grBehavior.setCursorImage(this.rotImg);
            this.setActiveTool(true);
            this.cornerActive[2] = true;
            return true;
        }
        this.grBehavior.resetDefaultCursor();
        this.grBehavior.getMapControl().repaint();
        return false;
    }

    private void resetBorderSelected() {
        for (int i = 0; i < this.cornerActive.length; ++i) {
            this.cornerActive[i] = false;
        }
    }
}

