/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.layerdatatype;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.BasicAPISwingPanel;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.raster.tools.algorithm.swing.AlgorithmSwingLocator;
import org.gvsig.raster.tools.app.basic.MainWindow;
import org.gvsig.raster.tools.app.basic.tool.layerdatatype.ProcessEndActions;

public class LayerDatatypeTocMenuEntry
extends AbstractTocContextMenuAction
implements IGenericToolBarMenuItem,
ActionListener {
    private static LayerDatatypeTocMenuEntry singleton = null;
    private MainWindow window = null;
    private BasicAPISwingPanel panel = null;
    private FLyrRaster inputLayer = null;

    private LayerDatatypeTocMenuEntry() {
    }

    public static LayerDatatypeTocMenuEntry getSingleton() {
        if (singleton == null) {
            singleton = new LayerDatatypeTocMenuEntry();
        }
        return singleton;
    }

    public String getGroup() {
        return "RasterExport";
    }

    public int getGroupOrder() {
        return 50;
    }

    public int getOrder() {
        return 2;
    }

    public String getText() {
        return Messages.getText((String)"change_datatype");
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof ILayerState)) {
            return false;
        }
        return ((ILayerState)selectedItems[0]).isOpen();
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof IRasterLayerActions)) {
            return false;
        }
        return ((IRasterLayerActions)selectedItems[0]).isActionEnabled(1);
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        FLayer fLayer = null;
        if (selectedItems.length != 1) {
            return;
        }
        fLayer = selectedItems[0];
        if (!(fLayer instanceof FLyrRaster)) {
            return;
        }
        this.inputLayer = (FLyrRaster)fLayer;
        this.panel = AlgorithmSwingLocator.getSwingManager().createLayerDatatypePanel((Object)this.inputLayer.getDataStore(), this.getDataType(this.inputLayer), this.inputLayer.getName());
        this.window = new MainWindow(this.panel.getComponent(), null, Messages.getText((String)"change_datatype"), 350, 290, this);
        PluginServices.getMDIManager().addCentredWindow((IWindow)this.window);
    }

    private String getDataType(FLyrRaster fLayer) {
        int dt = fLayer.getDataStore().getDataType()[0];
        if (dt == 0) {
            return "BYTE";
        }
        if (dt == 2) {
            return "SHORT";
        }
        if (dt == 3) {
            return "INTEGER";
        }
        if (dt == 4) {
            return "FLOAT";
        }
        if (dt == 5) {
            return "DOUBLE";
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.window.getButtonsPanel().getButton(3) || e.getSource() == this.window.getButtonsPanel().getButton(1)) {
            DataProcess task = null;
            try {
                task = (DataProcess)this.panel.getResult();
            }
            catch (Exception e1) {
                Messages.getText((String)"error_getting_process");
            }
            task.setActions((IProcessActions)new ProcessEndActions(this.window, (FLayer)this.inputLayer));
            task.init();
            task.start();
        }
    }

    public Icon getIcon() {
        return IconThemeHelper.getImageIcon((String)"datatype-icon");
    }
}

