/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.multiresolution;

import java.awt.Component;
import java.awt.Image;
import java.awt.geom.Point2D;
import javax.swing.JOptionPane;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.raster.fmap.layers.Multiresolution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolutionLevelListener
implements PointListener {
    private static final Logger logger = LoggerFactory.getLogger(ResolutionLevelListener.class);
    private Image izoomin = null;

    public void point(PointEvent event) throws BehaviorException {
        Envelope r;
        IWindow theView = PluginServices.getMDIManager().getActiveWindow();
        if (!(theView instanceof AbstractViewPanel)) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText(this.getClass(), (String)"window_not_valid"));
            return;
        }
        MapControl mapCtrl = ((AbstractViewPanel)theView).getMapControl();
        FLayers layers = mapCtrl.getMapContext().getLayers();
        Multiresolution lyrMultires = null;
        for (int i = 0; i < layers.getLayersCount(); ++i) {
            if (!layers.getLayer(i).isActive() || !(layers.getLayer(i) instanceof Multiresolution) || !((Multiresolution)layers.getLayer(i)).isEnabledMultiresolution()) continue;
            lyrMultires = (Multiresolution)layers.getLayer(i);
        }
        if (lyrMultires == null) {
            boolean thereAreLayersSelected = false;
            for (int i = 0; i < layers.getLayersCount(); ++i) {
                if (!layers.getLayer(i).isActive()) continue;
                thereAreLayersSelected = true;
            }
            String message = null;
            message = !thereAreLayersSelected ? PluginServices.getText(this.getClass(), (String)"there_arent_selected") : PluginServices.getText(this.getClass(), (String)"no_resolution_level");
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), message);
            return;
        }
        if (event.getEvent().getButton() == 1 && !lyrMultires.increaseZoomLevel()) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText(this.getClass(), (String)"max_zoom_reached"));
            return;
        }
        if (event.getEvent().getButton() == 3 && !lyrMultires.decreaseZoomLevel()) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText(this.getClass(), (String)"min_zoom_reached"));
            return;
        }
        ViewPort viewPort = mapCtrl.getMapContext().getViewPort();
        Point2D center = viewPort.toMapPoint(event.getPoint());
        try {
            r = lyrMultires.getCoordsInLevel(center, lyrMultires.getZoomLevel(), viewPort.getImageWidth(), viewPort.getImageHeight());
        }
        catch (CreateEnvelopeException e) {
            return;
        }
        viewPort.setEnvelope(r);
        if (PluginServices.getMainFrame() != null) {
            PluginServices.getMainFrame().enableControls();
        }
    }

    public void pointDoubleClick(PointEvent event) throws BehaviorException {
    }

    public boolean cancelDrawing() {
        logger.debug("cancelDrawing true");
        return true;
    }

    public Image getImageCursor() {
        if (this.izoomin == null) {
            this.izoomin = IconThemeHelper.getImage((String)"point-cursor");
        }
        return this.izoomin;
    }
}

