/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.properties.control;

import java.util.ArrayList;
import java.util.EventObject;
import org.gvsig.fmap.dal.coverage.datastruct.TransparencyRange;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.mainplugin.properties.RasterPropertiesTocMenuEntry;
import org.gvsig.raster.tools.app.basic.RasterExtension;
import org.gvsig.raster.tools.app.basic.tool.properties.control.TranspByPixelEventListener;
import org.gvsig.raster.tools.app.basic.tool.properties.panel.TransparencyPanel;

public class TransparencyListener
implements TranspByPixelEventListener {
    private Transparency transparency = null;
    private TransparencyPanel tPanel = null;

    public TransparencyListener(TransparencyPanel tp) {
        this.tPanel = tp;
        this.tPanel.getPTranspByPixel().addValueChangedListener(this);
    }

    private void setValuesFromTransparencyToPanel() {
        if (this.transparency.getOpacity() != 255) {
            this.tPanel.getOpacityPanel().setControlEnabled(true);
            this.tPanel.getOpacityPanel().setValue((double)(this.transparency.getOpacity() * 100 / 255));
        } else {
            this.tPanel.getOpacityPanel().setControlEnabled(false);
            this.tPanel.getOpacityPanel().setValue(100.0);
        }
        this.tPanel.getPTranspByPixel().getListener().setEventsDisabled(true);
        if (this.transparency.getTransparencyRange().size() > 0) {
            this.tPanel.getPTranspByPixel().clear();
            this.tPanel.getPTranspByPixel().setControlEnabled(true);
            for (int i = 0; i < this.transparency.getTransparencyRange().size(); ++i) {
                TransparencyRange range = (TransparencyRange)this.transparency.getTransparencyRange().get(i);
                this.tPanel.getPTranspByPixel().addStringElement(range);
            }
        } else {
            this.tPanel.getPTranspByPixel().clear();
            this.tPanel.getPTranspByPixel().setControlEnabled(false);
        }
        this.tPanel.getPTranspByPixel().getListener().setEventsDisabled(false);
    }

    private void setValuesFromPanelToTransparency() {
        if (this.transparency == null) {
            return;
        }
        if (this.tPanel.getOpacityPanel().getCheck().isSelected()) {
            this.transparency.setOpacity((int)Math.round(this.tPanel.getOpacityPanel().getValue() * 255.0 / 100.0));
        } else {
            this.transparency.setOpacity(255);
        }
        if (this.tPanel.getPTranspByPixel().getActiveCheck().isSelected()) {
            this.transparency.clearListOfTransparencyRange();
            ArrayList<TransparencyRange> entries = this.tPanel.getPTranspByPixel().getEntries();
            for (int i = 0; i < entries.size(); ++i) {
                this.transparency.setTransparencyRange(entries.get(i));
            }
        } else {
            this.transparency.clearListOfTransparencyRange();
        }
        this.transparency.activeTransparency();
        if (this.tPanel.getLayer() != null) {
            this.tPanel.getLayer().getMapContext().invalidate();
        }
    }

    public void apply() {
        this.onlyApply();
        this.saveStatus();
    }

    public void onlyApply() {
        if (RasterPropertiesTocMenuEntry.enableEvents) {
            this.setValuesFromPanelToTransparency();
        }
    }

    private void saveStatus() {
        this.tPanel.getPanelGroup().getProperties().put("opacity", new Integer(this.transparency.getOpacity()));
        this.tPanel.getPanelGroup().getProperties().put("transparencyActive", new Boolean(this.transparency.isTransparencyActive()));
        ArrayList newArray = new ArrayList();
        for (int i = 0; i < this.transparency.getTransparencyRange().size(); ++i) {
            newArray.add(this.transparency.getTransparencyRange().get(i));
        }
        this.tPanel.getPanelGroup().getProperties().put("transparencyRange", newArray);
    }

    public void restoreStatus() {
        this.transparency.setOpacity(((Integer)this.tPanel.getPanelGroup().getProperties().get("opacity")).intValue());
        this.transparency.setTransparencyActive(((Boolean)this.tPanel.getPanelGroup().getProperties().get("transparencyActive")).booleanValue());
        ArrayList newArray = (ArrayList)this.tPanel.getPanelGroup().getProperties().get("transparencyRange");
        this.transparency.clearListOfTransparencyRange();
        for (int i = 0; i < newArray.size(); ++i) {
            this.transparency.setTransparencyRange((TransparencyRange)newArray.get(i));
        }
        if (this.tPanel.getLayer() != null) {
            this.tPanel.getLayer().getMapContext().invalidate();
        }
    }

    public void accept() {
        this.onlyApply();
    }

    public void cancel() {
        this.restoreStatus();
    }

    @Override
    public void actionPixelListChanged(EventObject e) {
        if (!RasterExtension.autoRefreshView) {
            return;
        }
        this.onlyApply();
    }

    public void setLayer(FLyrRaster layer) {
        this.transparency = layer.getRender().getRenderingTransparency();
        this.saveStatus();
        this.setValuesFromTransparencyToPanel();
    }
}

