/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.properties.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.gvsig.gui.beans.slidertext.SliderTextContainer;
import org.gvsig.i18n.Messages;

public class EnhancedWithTrimPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 9023137365069951866L;
    private JCheckBox active = null;
    private SliderTextContainer trimSlider = null;
    private JCheckBox removeCheck = null;
    private JCheckBox trimCheck = null;

    public EnhancedWithTrimPanel() {
        this.init();
    }

    private void init() {
        this.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"realce"), 0, 0, null, null));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.getActive(), gbc);
        gbc.gridy = 1;
        this.add((Component)this.getRemoveCheck(), gbc);
        gbc.gridy = 2;
        this.add((Component)this.getTrimCheck(), gbc);
        gbc.gridy = 3;
        this.add((Component)this.getTrimSlider(), gbc);
        this.getActive().addActionListener(this);
        this.getTrimCheck().addActionListener(this);
    }

    public JCheckBox getActive() {
        if (this.active == null) {
            this.active = new JCheckBox(Messages.getText((String)"activar"));
            this.active.setSelected(false);
            this.setControlEnabled(false);
        }
        return this.active;
    }

    public JCheckBox getRemoveCheck() {
        if (this.removeCheck == null) {
            this.removeCheck = new JCheckBox(Messages.getText((String)"eliminar_extremos"));
        }
        return this.removeCheck;
    }

    public JCheckBox getTrimCheck() {
        if (this.trimCheck == null) {
            this.trimCheck = new JCheckBox(Messages.getText((String)"recorte_de_colas"));
        }
        return this.trimCheck;
    }

    public SliderTextContainer getTrimSlider() {
        if (this.trimSlider == null) {
            this.trimSlider = new SliderTextContainer(0, 50, 0, false);
            this.trimSlider.setDecimal(true);
            this.trimSlider.setBorder("");
        }
        return this.trimSlider;
    }

    public void setControlEnabled(boolean enabled) {
        if (enabled && this.getTrimCheck().isSelected()) {
            this.getTrimSlider().setControlEnabled(true);
        } else {
            this.getTrimSlider().setControlEnabled(false);
        }
        this.getRemoveCheck().setEnabled(enabled);
        this.getTrimCheck().setEnabled(enabled);
        this.getActive().setSelected(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getActive()) {
            if (this.getActive().isSelected()) {
                this.setControlEnabled(true);
            } else {
                this.setControlEnabled(false);
            }
        }
        if (e.getSource() == this.getTrimCheck()) {
            this.getTrimSlider().setControlEnabled(this.getTrimCheck().isSelected());
        }
    }

    public boolean isRemoveEndsSelected() {
        return this.getRemoveCheck().isSelected();
    }

    public boolean isTailTrimCheckSelected() {
        return this.getTrimCheck().isSelected();
    }

    public double getTrimValue() {
        return this.getTrimSlider().getValue();
    }

    public void setTailTrimCheckActive(boolean active) {
        this.getTrimCheck().setSelected(active);
        this.getTrimSlider().setControlEnabled(active);
    }

    public void setRemoveEndsActive(boolean active) {
        this.getRemoveCheck().setSelected(active);
    }

    public void setTailTrimValue(double value) {
        this.getTrimSlider().setValue(value);
    }
}

