/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.properties.panel;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.RasterExtension;
import org.gvsig.raster.util.BasePanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoDataPanel
extends BasePanel
implements ActionListener {
    private static final long serialVersionUID = 7645641060812458944L;
    private Logger log = LoggerFactory.getLogger(NoDataPanel.class);
    private static final String NULL_NODATA = "not_defined";
    private static final String NAN_NODATA = "NaN";
    private JLabel jLabelValue = null;
    private JButton buttonSave = null;
    private JButton buttonDelete = null;
    private JButton buttonDefaultValue = null;
    private JButton buttonRestore = null;
    private JFormattedTextField jTextFieldValue = null;
    private JPanel panelCenter = null;
    private JPanel panelUp = null;
    private JPanel panelDown = null;
    private JCheckBox jCheckBoxNoDataEnabled = null;
    private NoData noData = null;
    private int dataType = 32;
    private FLyrRaster lyr = null;

    public NoDataPanel() {
        this.init();
        this.translate();
    }

    protected void translate() {
        this.getButtonSave().setText(this.getText(this, "guardar"));
        this.getButtonSave().setToolTipText(this.getText(this, "guardar_box_value"));
        this.getButtonRestore().setText(this.getText(this, "restore"));
        this.getButtonRestore().setToolTipText(this.getText(this, "restore_native_value"));
        this.getButtonDefaultValue().setText(this.getText(this, "default_value"));
        this.getButtonDefaultValue().setToolTipText(this.getText(this, "set_configuration_value"));
        this.getButtonDelete().setText(this.getText(this, "delete"));
        this.getButtonDelete().setToolTipText(this.getText(this, "delete_value"));
        this.getCheckBoxNoDataEnabled().setText(this.getText(this, "tratar_nodata_transparente"));
        this.getCheckBoxNoDataEnabled().setToolTipText(this.getCheckBoxNoDataEnabled().getText());
        this.getLabelValue().setText(this.getText(this, "value") + ":");
    }

    private JButton getButtonSave() {
        if (this.buttonSave == null) {
            this.buttonSave = new JButton();
            this.buttonSave.addActionListener(this);
        }
        return this.buttonSave;
    }

    private JButton getButtonDelete() {
        if (this.buttonDelete == null) {
            this.buttonDelete = new JButton();
            this.buttonDelete.addActionListener(this);
        }
        return this.buttonDelete;
    }

    private JButton getButtonDefaultValue() {
        if (this.buttonDefaultValue == null) {
            this.buttonDefaultValue = new JButton();
            this.buttonDefaultValue.addActionListener(this);
        }
        return this.buttonDefaultValue;
    }

    private JButton getButtonRestore() {
        if (this.buttonRestore == null) {
            this.buttonRestore = new JButton();
            this.buttonRestore.addActionListener(this);
        }
        return this.buttonRestore;
    }

    private JFormattedTextField getTextFieldValue() {
        if (this.jTextFieldValue == null) {
            DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance(Locale.ENGLISH);
            nf.applyPattern("##########.######");
            nf.setMaximumFractionDigits(6);
            this.jTextFieldValue = new JFormattedTextField(nf);
        }
        return this.jTextFieldValue;
    }

    private JLabel getLabelValue() {
        if (this.jLabelValue == null) {
            this.jLabelValue = new JLabel();
        }
        return this.jLabelValue;
    }

    protected void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add(this.getPanelUp(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.add(this.getPanelCenter(), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add(this.getPanelDown(), gridBagConstraints);
    }

    public JCheckBox getCheckBoxNoDataEnabled() {
        if (this.jCheckBoxNoDataEnabled == null) {
            this.jCheckBoxNoDataEnabled = new JCheckBox();
            this.jCheckBoxNoDataEnabled.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.jCheckBoxNoDataEnabled.setMargin(new Insets(0, 0, 0, 0));
            this.jCheckBoxNoDataEnabled.addActionListener(this);
        }
        return this.jCheckBoxNoDataEnabled;
    }

    private void setCheckBoxValue(double d) {
        this.getTextFieldValue().setText(d + "");
    }

    private String getCheckBoxValue() {
        String value = this.getTextFieldValue().getText();
        try {
            new Double(value);
        }
        catch (NumberFormatException e) {
            RasterSwingLibrary.messageBoxError((String)"nodatavalue_not_valid", (Object)this);
            return null;
        }
        return this.getTextFieldValue().getText();
    }

    public void setEnabledComponents(boolean b) {
        this.getTextFieldValue().setEnabled(b);
        this.getLabelValue().setEnabled(b);
        this.getButtonDelete().setEnabled(b);
        this.getButtonRestore().setEnabled(b);
        this.getButtonSave().setEnabled(b);
        this.getButtonDefaultValue().setEnabled(b);
    }

    public NoData getNoDataValue() {
        return this.noData;
    }

    private void loadNoDataFromText(String text) {
        if (text == null) {
            text = this.getCheckBoxValue();
        }
        if (text == null || text.compareTo(this.getText(this, NULL_NODATA)) == 0) {
            this.noData.setValue(null);
            this.noData.save();
            return;
        }
        if (text.compareTo(NAN_NODATA) == 0) {
            this.noData.setValue((Number)Double.NaN);
            this.noData.save();
            return;
        }
        Number number = null;
        try {
            switch (this.dataType) {
                case 0: {
                    if (text.contains(".")) {
                        text = text.substring(0, text.lastIndexOf("."));
                    }
                    number = new Byte(text);
                    break;
                }
                case 2: {
                    if (text.contains(".")) {
                        text = text.substring(0, text.lastIndexOf("."));
                    }
                    number = new Short(text);
                    break;
                }
                case 3: {
                    if (text.contains(".")) {
                        text = text.substring(0, text.lastIndexOf("."));
                    }
                    number = new Integer(text);
                    break;
                }
                case 4: {
                    number = new Float(text);
                    break;
                }
                case 5: {
                    number = new Double(text);
                }
            }
            this.noData.setValue(number);
            this.noData.save();
        }
        catch (NumberFormatException e1) {
            this.log.info("A number format exception in Nodata panel has happend", (Throwable)e1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getButtonSave()) {
            this.loadNoDataFromText(null);
        }
        if (e.getSource() == this.getButtonDefaultValue()) {
            switch (this.dataType) {
                case 0: {
                    this.loadNoDataFromText(RasterLibrary.defaultByteNoDataValue + "");
                    break;
                }
                case 2: {
                    this.loadNoDataFromText(RasterLibrary.defaultShortNoDataValue + "");
                    break;
                }
                case 3: {
                    this.loadNoDataFromText(RasterLibrary.defaultIntegerNoDataValue + "");
                    break;
                }
                case 4: {
                    this.loadNoDataFromText(RasterLibrary.defaultFloatNoDataValue + "");
                    break;
                }
                case 5: {
                    this.loadNoDataFromText(RasterLibrary.defaultDoubleNoDataValue + "");
                }
            }
            if (this.noData.isDefined()) {
                this.setCheckBoxValue(this.noData.getValue().doubleValue());
            }
        }
        if (e.getSource() == this.getButtonDelete()) {
            this.noData.delete();
            this.noData.save();
            this.getTextFieldValue().setText(this.getText(this, NULL_NODATA));
        }
        if (e.getSource() == this.getButtonRestore()) {
            this.noData.restore();
            this.noData.save();
            if (this.noData.isDefined()) {
                this.setCheckBoxValue(this.noData.getValue().doubleValue());
            } else {
                this.getTextFieldValue().setText(this.getText(this, NULL_NODATA));
            }
        }
        if (e.getSource() == this.getCheckBoxNoDataEnabled() && RasterExtension.autoRefreshView) {
            this.lyr.setNoDataTransparent(this.getCheckBoxNoDataEnabled().isSelected());
        }
        if (RasterExtension.autoRefreshView) {
            if (this.lyr == null || this.lyr.getDataStore() == null) {
                return;
            }
            this.lyr.setNoDataTransparent(this.getCheckBoxNoDataEnabled().isSelected());
            this.lyr.getMapContext().invalidate();
        }
    }

    public void setLayer(FLyrRaster layer) {
        this.lyr = layer;
        this.noData = layer.getNoDataValue();
        this.dataType = layer.getDataStore().getDataType()[0];
        if (this.noData.isDefined()) {
            this.setCheckBoxValue(this.noData.getValue().doubleValue());
        } else {
            this.getTextFieldValue().setText(this.getText(this, NULL_NODATA));
        }
        this.getCheckBoxNoDataEnabled().setSelected(this.noData.isNoDataTransparent());
    }

    public JPanel getPanelCenter() {
        if (this.panelCenter == null) {
            this.panelCenter = new JPanel();
            this.panelCenter.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.panelCenter.add((Component)this.getLabelValue(), gridBagConstraints);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            this.panelCenter.add((Component)this.getTextFieldValue(), gridBagConstraints);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridx = 2;
            this.panelCenter.add((Component)this.getButtonSave(), gridBagConstraints);
            gridBagConstraints.gridx = 3;
            this.panelCenter.add((Component)this.getButtonDelete(), gridBagConstraints);
        }
        return this.panelCenter;
    }

    public JPanel getPanelUp() {
        if (this.panelUp == null) {
            this.panelUp = new JPanel();
            this.panelUp.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.panelUp.add((Component)this.getCheckBoxNoDataEnabled(), gridBagConstraints);
        }
        return this.panelUp;
    }

    public JPanel getPanelDown() {
        if (this.panelDown == null) {
            this.panelDown = new JPanel();
            this.panelDown.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            this.panelDown.add((Component)this.getButtonDefaultValue(), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            this.panelDown.add((Component)this.getButtonRestore(), gridBagConstraints);
        }
        return this.panelDown;
    }
}

