/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.roi;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.layers.vectorial.GraphicLayer;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.raster.roi.ROI;
import org.gvsig.tools.dispose.DisposableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ROIFeatureManager {
    protected static final Logger logger = LoggerFactory.getLogger(ROIFeatureManager.class);
    private Map<String, List<FeatureReference>> roiNameToFeatureList = Collections.synchronizedMap(new HashMap());
    private final String layerId;

    public ROIFeatureManager(String layerId) {
        this.layerId = layerId;
    }

    public Map<String, List<FeatureReference>> getRoiNameToFeatureList() {
        return Collections.unmodifiableMap(this.roiNameToFeatureList);
    }

    public EditableFeature addROIFeature(ROI roi, GraphicLayer graphicLayer, Geometry geometry, ISymbol symbol) throws DataException {
        int symbolPos = graphicLayer.addSymbol(symbol);
        EditableFeature feature = this.createEditableFeature(graphicLayer.getFeatureStore(), roi, geometry, symbolPos);
        this.addROIFeature(roi, feature.getReference());
        return feature;
    }

    public void addROIFeature(ROI roi, FeatureReference feature) {
        List<FeatureReference> featureList = this.roiNameToFeatureList.get(roi.getName());
        if (featureList == null) {
            featureList = new ArrayList<FeatureReference>();
            this.roiNameToFeatureList.put(roi.getName(), featureList);
        }
        featureList.add(feature);
    }

    public boolean clear(GraphicLayer layer) {
        return this.clear(layer, false);
    }

    public void clearFeaturesFromGraphicLayer(GraphicLayer layer) {
        this.clear(layer, true);
    }

    private boolean clear(GraphicLayer layer, boolean onlyRemoveFromLayer) {
        boolean anythingCleared = false;
        ArrayList<String> roiNameList = new ArrayList<String>();
        for (String roiName : this.roiNameToFeatureList.keySet()) {
            roiNameList.add(roiName);
        }
        for (int i = 0; i < roiNameList.size(); ++i) {
            String roiName;
            roiName = (String)roiNameList.get(i);
            boolean bl = anythingCleared = this.removeGraphics(layer, this.getROIId(roiName)) ? true : anythingCleared;
            if (!onlyRemoveFromLayer) continue;
            this.roiNameToFeatureList.remove(roiName);
        }
        return anythingCleared;
    }

    public boolean removeROI(String roiName, GraphicLayer layer) {
        this.removeGraphics(layer, this.getROIId(roiName));
        return this.roiNameToFeatureList.remove(roiName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeColor(GraphicLayer lyr, String roiName, Color color) {
        DisposableIterator iterator = null;
        FeatureSet featureSet = null;
        FeatureStore store = lyr.getFeatureStore();
        try {
            store.beginComplexNotification();
            if (!store.isEditing()) {
                store.edit();
            }
            featureSet = store.getFeatureSet();
            iterator = featureSet.fastIterator();
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                Object obj = feature.get("groupId");
                if (!(obj instanceof String) || !((String)obj).equals(this.getROIId(roiName))) continue;
                int symbolPos = feature.getInt("idsym");
                ISymbol symbol = lyr.getSymbol(symbolPos);
                symbol.setColor(color);
            }
            store.finishEditing();
            store.endComplexNotification();
        }
        catch (DataException e) {
            logger.error("Error clearing all the geometry of the graphic layer", (Throwable)e);
        }
        finally {
            if (featureSet != null) {
                featureSet.dispose();
            }
            if (iterator != null) {
                iterator.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeGraphics(GraphicLayer lyr, String prefix) {
        boolean anythingCleared = false;
        DisposableIterator iterator = null;
        FeatureSet featureSet = null;
        FeatureStore store = lyr.getFeatureStore();
        try {
            store.beginComplexNotification();
            if (!store.isEditing()) {
                store.edit();
            }
            featureSet = store.getFeatureSet();
            iterator = featureSet.fastIterator();
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                Object obj = feature.get("groupId");
                if (!(obj instanceof String) || !((String)obj).startsWith(prefix)) continue;
                anythingCleared = true;
                iterator.remove();
            }
            store.finishEditing();
            store.endComplexNotification();
        }
        catch (DataException e) {
            logger.error("Error clearing all the geometry of the graphic layer", (Throwable)e);
        }
        finally {
            if (featureSet != null) {
                featureSet.dispose();
            }
            if (iterator != null) {
                iterator.dispose();
            }
        }
        return anythingCleared;
    }

    public String getROIId(String roiName) {
        return this.getROIPrefix().concat(roiName);
    }

    private String getROIPrefix() {
        return this.layerId.concat("-");
    }

    public void changeROIName(String oldName, String newName, GraphicLayer layer) throws DataException {
        List<FeatureReference> featureList = this.roiNameToFeatureList.remove(oldName);
        if (featureList != null) {
            this.roiNameToFeatureList.put(newName, featureList);
            String newroiid = this.getROIId(newName);
            FeatureStore store = layer.getFeatureStore();
            store.edit();
            for (int i = 0; i < featureList.size(); ++i) {
                FeatureReference ref = featureList.get(i);
                EditableFeature editable = ref.getFeature().getEditable();
                editable.set("groupId", (Object)newroiid);
                store.update(editable);
            }
            store.finishEditing();
        }
    }

    public List<FeatureReference> getROIFeatures(String roiName) {
        return Collections.unmodifiableList(this.roiNameToFeatureList.get(roiName));
    }

    private EditableFeature createEditableFeature(FeatureStore store, ROI roi, Geometry geometry, int symbolPos) throws DataException {
        EditableFeature feature = store.createNewFeature();
        feature.set("groupId", (Object)this.getROIId(roi.getName()));
        feature.setGeometry("geom", geometry);
        feature.setInt("idsym", symbolPos);
        return feature;
    }
}

