/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.roi;

import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.toc.AbstractTocContextMenuAction;
import org.gvsig.app.project.documents.view.toc.ITocItem;
import org.gvsig.fmap.dal.coverage.exception.GridException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.gui.beans.buttonspanel.ButtonsPanelListener;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.ILayerState;
import org.gvsig.raster.mainplugin.toolbar.IGenericToolBarMenuItem;
import org.gvsig.raster.swing.RasterSwingLocator;
import org.gvsig.raster.swing.roi.ROIPanel;
import org.gvsig.raster.tools.app.basic.RasterToolsUtil;
import org.gvsig.raster.tools.app.basic.tool.roi.ROIDataModel;
import org.gvsig.raster.tools.app.basic.tool.roi.ui.ROIWindow;
import org.gvsig.raster.tools.app.basic.tool.roi.ui.listener.ROIPanelListener;
import org.gvsig.raster.tools.app.basic.tool.roi.ui.listener.ROIsTablePanelListener;

public class ROIManagerTocMenuEntry
extends AbstractTocContextMenuAction
implements IGenericToolBarMenuItem {
    private static ROIManagerTocMenuEntry singleton = null;

    private ROIManagerTocMenuEntry() {
    }

    public static ROIManagerTocMenuEntry getSingleton() {
        if (singleton == null) {
            singleton = new ROIManagerTocMenuEntry();
        }
        return singleton;
    }

    public String getGroup() {
        return "RasterLayer";
    }

    public int getGroupOrder() {
        return 10;
    }

    public int getOrder() {
        return 60;
    }

    public String getText() {
        return RasterToolsUtil.getText((Object)this, "regiones_interes");
    }

    public boolean isEnabled(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        if (!(selectedItems[0] instanceof ILayerState)) {
            return false;
        }
        return ((ILayerState)selectedItems[0]).isOpen();
    }

    public boolean isVisible(ITocItem item, FLayer[] selectedItems) {
        if (selectedItems == null || selectedItems.length != 1) {
            return false;
        }
        return selectedItems[0] instanceof FLyrRaster;
    }

    public void execute(ITocItem item, FLayer[] selectedItems) {
        FLayer fLayer = null;
        if (selectedItems.length != 1) {
            return;
        }
        fLayer = selectedItems[0];
        if (!(fLayer instanceof FLyrRaster)) {
            return;
        }
        ROIPanel panel = RasterSwingLocator.getSwingManager().createROIPanel();
        ROIDataModel dataModel = new ROIDataModel(this.getLFLyrVects());
        dataModel.setROIPanel(panel);
        ROIWindow window = new ROIWindow(panel.getComponent(), "ROI", 500, 265);
        try {
            dataModel.setLayer(selectedItems[0]);
        }
        catch (GridException gridException) {
            // empty catch block
        }
        ROIPanelListener panelListener = new ROIPanelListener(window, dataModel);
        ROIsTablePanelListener tableListener = new ROIsTablePanelListener(panel, dataModel, window);
        tableListener.setPathToROI(this.getROIDefaultPath(fLayer));
        tableListener.setDefaultROIFileName(this.getDefaultROIFileName(fLayer));
        panel.addButtonsListener((ActionListener)tableListener, (ButtonsPanelListener)panelListener);
        panel.addTableListeners((ListSelectionListener)tableListener, (TableModelListener)tableListener);
        window.addIWindowListener(panelListener);
        RasterToolsUtil.addWindow(window);
    }

    private String getDefaultROIFileName(FLayer fLayer) {
        return fLayer.getName() + "_ROI.shp";
    }

    private File getROIDefaultPath(FLayer layer) {
        File path = this.getROIPathFromLayer(layer);
        if (path != null) {
            return path;
        }
        return this.getPathFromLayer(layer);
    }

    private File getPathFromLayer(FLayer layer) {
        URI uri;
        if (!(layer instanceof FLyrRaster)) {
            return null;
        }
        URI[] uriList = ((FLyrRaster)layer).getDataStore().getURIByProvider();
        if (uriList != null && uriList.length > 0 && "FILE".equalsIgnoreCase((uri = uriList[0]).getScheme())) {
            return new File(uri).getParentFile();
        }
        return null;
    }

    private File getROIPathFromLayer(FLayer layer) {
        String path;
        String uri;
        if (!(layer instanceof FLyrRaster)) {
            return null;
        }
        List uriList = ((FLyrRaster)layer).getDataStore().getROIFileListFromRmf();
        if (uriList != null && uriList.size() > 0 && (uri = (path = ((File)uriList.get(0)).getAbsolutePath()).substring(0, path.lastIndexOf(File.separator))) != null) {
            return new File(uri);
        }
        return null;
    }

    public List<FLyrVect> getLFLyrVects() {
        ArrayList<FLyrVect> list = new ArrayList<FLyrVect>();
        IWindow[] w = PluginServices.getMDIManager().getAllWindows();
        for (int i = 0; i < w.length; ++i) {
            if (!(w[i] instanceof AbstractViewPanel)) continue;
            FLayers lys = ((AbstractViewPanel)w[i]).getMapControl().getMapContext().getLayers();
            for (int j = 0; j < lys.getLayersCount(); ++j) {
                if (!(lys.getLayer(j) instanceof FLyrVect)) continue;
                list.add((FLyrVect)lys.getLayer(j));
            }
        }
        return list;
    }

    public Icon getIcon() {
        return IconThemeHelper.getImageIcon((String)"layer-modify-roi");
    }
}

