/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.tools.app.basic.tool.saveraster.operation;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JOptionPane;
import org.gvsig.andami.PluginServices;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.datastruct.ViewPortData;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.process.TaskEventManager;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.RasterWriter;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.gvsig.raster.tools.app.basic.raster.process.RasterProcess;
import org.gvsig.raster.tools.app.basic.tool.saveraster.operation.CopyDataset;
import org.gvsig.raster.tools.app.basic.tool.saveraster.operation.ExternalCancellable;
import org.gvsig.raster.tools.app.basic.tool.saveraster.operation.RasterizerLayer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveRasterProcess
extends RasterProcess {
    private ViewPort viewPort = null;
    private Dimension dimension = null;
    private RasterizerLayer rasterizerLayer = null;
    private String fileName = "";
    private Params writerParams = null;
    private CopyDataset jp2Copy = null;
    private boolean supportImage = false;
    private ArrayList<FLyrRaster> layers = null;
    private RasterManager rManager = RasterLocator.getManager();
    private Logger logger = LoggerFactory.getLogger((String)RasterProcess.class.toString());

    @Override
    public void init() {
        this.viewPort = (ViewPort)this.getParam("viewport");
        this.dimension = (Dimension)this.getParam("dimension");
        this.rasterizerLayer = (RasterizerLayer)this.getParam("rasterizerlayer");
        this.fileName = this.getStringParam("filename");
        this.writerParams = (Params)this.getParam("writerparams");
        this.supportImage = this.getBooleanParam("remotelayers") && this.fileName.endsWith(".jp2");
        this.layers = (ArrayList)this.getParam("layers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() throws ProcessInterruptedException {
        TaskEventManager task = this.rManager.getRasterTask();
        if (this.layers != null) {
            for (int i = 0; i < this.layers.size(); ++i) {
                this.layers.get(i).setReadingData(Thread.currentThread().getId() + "");
            }
        }
        this.jp2Copy = null;
        long t1 = new Date().getTime();
        Envelope env = this.viewPort.getAdjustedEnvelope();
        Extent ex = this.rManager.getDataStructFactory().createExtent(env.getMinimum(0), env.getMaximum(1), env.getMaximum(0), env.getMinimum(1));
        Dimension imgSz = this.viewPort.getImageSize();
        ViewPortData vpData = this.rManager.getDataStructFactory().createViewPortData(this.viewPort.getProjection(), ex, (Dimension2D)imgSz);
        AffineTransform at = new AffineTransform(vpData.getExtent().width() / (double)imgSz.width, 0.0, 0.0, -(vpData.getExtent().height() / (double)imgSz.height), vpData.getExtent().getULX(), vpData.getExtent().getULY());
        String oldFileName = this.fileName;
        if (this.supportImage) {
            this.fileName = this.fileName.substring(0, Math.min(this.fileName.lastIndexOf(File.separator) + 1, this.fileName.length() - 1));
            this.fileName = this.fileName + this.rManager.getFileUtils().usesOnlyLayerName() + ".tif";
            this.writerParams = this.getWriterParams(this.fileName);
        }
        try {
            this.write(this.fileName, at, this.writerParams, this.rasterizerLayer);
            if (task.getEvent() != null) {
                task.manageEvent(task.getEvent());
            }
            if (this.supportImage) {
                try {
                    this.insertLineLog(Messages.getText((String)"saving_jp2"));
                    this.jp2Copy = new CopyDataset(this.fileName, oldFileName, this.incrementableTask);
                    this.jp2Copy.copy();
                    new File(this.fileName).delete();
                    new File(this.rManager.getFileUtils().getRMFNameFromFileName(this.fileName)).delete();
                }
                catch (LoadLayerException loadLayerException) {
                }
                catch (ProcessException e) {
                    this.logger.debug(RasterLocator.getManager().getRasterUtils().getTrace((Exception)((Object)e)));
                    RasterSwingLibrary.messageBoxError((String)"error_processing", (Object)this, (Exception)((Object)e));
                }
                this.jp2Copy = null;
            }
            long t2 = new Date().getTime();
            try {
                this.saveRasterFinalize(oldFileName, t2 - t1);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        catch (IOException ev) {
            if (this.incrementableTask != null) {
                this.incrementableTask.processFinalize();
                this.incrementableTask = null;
            }
            RasterSwingLibrary.messageBoxError((String)"error_processing", (Object)this, (Exception)ev);
            return;
        }
        catch (OutOfMemoryError ev) {
            if (this.incrementableTask != null) {
                this.incrementableTask.processFinalize();
                this.incrementableTask = null;
            }
            RasterSwingLibrary.messageBoxError((String)"memoria_excedida", (Object)this, (Exception)new IOException("Out of memory en salvar a raster"));
        }
        finally {
            if (this.layers != null) {
                for (int i = 0; i < this.layers.size(); ++i) {
                    this.layers.get(i).setReadingData(null);
                }
            }
        }
    }

    private void write(String name, AffineTransform at, Params writerParams, DataServerWriter rasterizerLayer) throws IOException, ProcessInterruptedException {
        TaskEventManager task = this.rManager.getRasterTask();
        RasterWriter geoRasterWriter = null;
        try {
            geoRasterWriter = this.rManager.createWriter(rasterizerLayer, name, 3, at, this.dimension.width, this.dimension.height, -1, writerParams, null);
        }
        catch (NotSupportedExtensionException e) {
            RasterSwingLibrary.messageBoxError((String)"extension_no_soportada", (Object)((Component)PluginServices.getMainFrame()), (Exception)((Object)e));
        }
        catch (RasterDriverException e) {
            RasterSwingLibrary.messageBoxError((String)"no_driver_escritura", (Object)((Component)PluginServices.getMainFrame()), (Exception)((Object)e));
        }
        if (task.getEvent() != null) {
            task.manageEvent(task.getEvent());
        }
        geoRasterWriter.setCancellableRasterDriver((org.gvsig.fmap.dal.coverage.store.ExternalCancellable)new ExternalCancellable(this.incrementableTask));
        geoRasterWriter.dataWrite();
        geoRasterWriter.writeClose();
    }

    private Params getWriterParams(String name) {
        RasterWriter writer = null;
        String ext = this.rManager.getFileUtils().getExtensionFromFileName(name);
        try {
            if (writer == null) {
                writer = this.rManager.createWriter(name);
            } else {
                String oldType;
                String newType = this.rManager.getProviderServices().getWriteDriverType(ext);
                if (!newType.equals(oldType = writer.getDriverName())) {
                    writer = this.rManager.createWriter(name);
                }
            }
            if (writer == null) {
                JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"no_driver_escritura"));
            }
            return writer.getParams();
        }
        catch (NotSupportedExtensionException e1) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"no_driver_escritura"));
            return null;
        }
        catch (RasterDriverException e1) {
            JOptionPane.showMessageDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)this, (String)"no_driver_escritura"));
            return null;
        }
    }

    private void saveRasterFinalize(String fileName, long milis) {
        if (this.incrementableTask != null) {
            this.incrementableTask.hideWindow();
        }
        this.externalActions.end(new Object[]{fileName, new Long(milis)});
    }

    public int getPercent() {
        if (this.rasterizerLayer != null) {
            return this.rasterizerLayer.getPercent();
        }
        return 0;
    }

    public String getTitle() {
        if (this.rasterizerLayer != null) {
            return this.rasterizerLayer.getTitle();
        }
        return null;
    }

    @Override
    public String getLog() {
        if (this.rasterizerLayer != null) {
            return this.rasterizerLayer.getLog();
        }
        return null;
    }

    @Override
    public String getLabel() {
        if (this.rasterizerLayer != null) {
            return this.rasterizerLayer.getLabel();
        }
        return null;
    }
}

