/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.cts.gt2;

import javax.media.jai.ParameterList;
import org.cresques.impl.cts.gt2.CSDatum;
import org.cresques.impl.cts.gt2.CoordSys;
import org.geotools.cs.AxisInfo;
import org.geotools.cs.GeographicCoordinateSystem;
import org.geotools.cs.Projection;
import org.geotools.units.Unit;
import org.opengis.referencing.FactoryException;

public class CSLambertCC
extends CoordSys {
    public CSLambertCC(CSDatum datum, double meridian, double origin, double sp1, double sp2, double est, double nort) {
        super(datum);
        this.geogCS = new GeographicCoordinateSystem((CharSequence)datum.getName(null), datum.getDatum());
        Unit linearUnit = Unit.METRE;
        ParameterList params = this.csFactory.createProjectionParameterList("Lambert_Conformal_Conic_2SP");
        params.setParameter("semi_major", datum.getDatum().getEllipsoid().getSemiMajorAxis());
        params.setParameter("semi_minor", datum.getDatum().getEllipsoid().getSemiMinorAxis());
        params.setParameter("central_meridian", meridian);
        params.setParameter("latitude_of_origin", origin);
        params.setParameter("standard_parallel_1", sp1);
        params.setParameter("standard_parallel_2", sp2);
        params.setParameter("false_easting", est);
        params.setParameter("false_northing", nort);
        try {
            Projection projection = this.csFactory.createProjection((CharSequence)"Lambert", "Lambert_Conformal_Conic_2SP", params);
            this.projCS = this.csFactory.createProjectedCoordinateSystem((CharSequence)projection.getName().toString(), this.geogCS, projection, linearUnit, AxisInfo.X, AxisInfo.Y);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }

    public CSLambertCC(CSDatum datum, double meridian, double origin, double sf, double est, double nort) {
        super(datum);
        this.geogCS = new GeographicCoordinateSystem((CharSequence)datum.getName(null), datum.getDatum());
        Unit linearUnit = Unit.METRE;
        ParameterList params = this.csFactory.createProjectionParameterList("Lambert_Conformal_Conic_1SP");
        params.setParameter("semi_major", datum.getDatum().getEllipsoid().getSemiMajorAxis());
        params.setParameter("semi_minor", datum.getDatum().getEllipsoid().getSemiMinorAxis());
        params.setParameter("central_meridian", meridian);
        params.setParameter("latitude_of_origin", origin);
        params.setParameter("scale_factor", sf);
        params.setParameter("false_easting", est);
        params.setParameter("false_northing", nort);
        try {
            Projection projection = this.csFactory.createProjection((CharSequence)"Lambert", "Lambert_Conformal_Conic_1SP", params);
            this.projCS = this.csFactory.createProjectedCoordinateSystem((CharSequence)projection.getName().toString(), this.geogCS, projection, linearUnit, AxisInfo.X, AxisInfo.Y);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
    }

    @Override
    public double getScale(double minX, double maxX, double w, double dpi) {
        double scale = super.getScale(minX, maxX, w, dpi);
        if (this.projCS != null) {
            scale = (maxX - minX) * (dpi / 2.54 * 100.0) / w;
        }
        return scale;
    }

    @Override
    public String toString() {
        return this.projCS.toString();
    }
}

