/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.geo;

import org.cresques.cts.IDatum;

public class Ellipsoid
implements IDatum {
    public static final Ellipsoid wgs72 = new Ellipsoid("WGS72", 6378135.0, 298.26);
    public static final Ellipsoid wgs84 = new Ellipsoid("WGS84", 6378137.0, 298.257223563);
    public static final Ellipsoid grs80 = new Ellipsoid("GRS80", 6378137.0, 298.257222101);
    public static final Ellipsoid hayford = new Ellipsoid("Hayford", 6378388.0, 297.0);
    public static final Ellipsoid struve = new Ellipsoid("Struve", 6378298.0, 299.73);
    public static final Ellipsoid ed50 = new Ellipsoid("ED50", 6378388.0, 297.0);
    public static final Ellipsoid clarke66 = new Ellipsoid("CLARKE 1866", 6378206.4, 294.9786982);
    private String pName = null;
    private double pMajor = 0.0;
    private double pFlat = 0.0;
    public double a;
    public double b;
    public double f;
    public double e;
    public double e2;
    public double ep;
    public double ep2;

    public Ellipsoid(String name, double major, double flat) {
        this.pName = name;
        this.pMajor = major;
        this.pFlat = flat;
        this.a = this.pMajor;
        this.f = this.pFlat;
        this.ainvto();
    }

    public String getName() {
        return this.pName;
    }

    private void ainvto() {
        this.b = this.a * (this.pFlat - 1.0) / this.pFlat;
        this.e2 = (2.0 * this.pFlat - 1.0) / (this.pFlat * this.pFlat);
        this.e = Math.sqrt(this.e2);
        this.ep2 = this.e2 / (1.0 - this.e2);
        this.ep = Math.sqrt(this.ep2);
    }

    private void abto() {
        if (Math.abs(this.a - this.b) < 1.0E-20) {
            this.pFlat = 0.0;
            this.e2 = 0.0;
        } else {
            this.pFlat = this.a / (this.a - this.b);
            this.e2 = (2.0 * this.pFlat - 1.0) / (this.pFlat * this.pFlat);
        }
        this.e = Math.sqrt(this.e2);
        this.ep2 = this.e2 / (1.0 - this.e2);
        this.ep = Math.sqrt(this.ep2);
    }

    public double[] getParam() {
        double[] elipar = new double[8];
        elipar[1] = this.pMajor;
        elipar[2] = this.pFlat;
        elipar[3] = this.b;
        elipar[4] = this.e;
        elipar[5] = this.e2;
        elipar[6] = this.ep;
        elipar[7] = this.ep2;
        return elipar;
    }

    public double getESemiMajorAxis() {
        return this.pMajor;
    }

    public double getEIFlattening() {
        return this.pFlat;
    }
}

