/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.geo;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.TreeMap;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IDatum;
import org.cresques.cts.IProjection;
import org.cresques.geo.ViewPortData;
import org.cresques.impl.geo.Ellipsoid;
import org.cresques.impl.geo.GeoPoint;
import org.cresques.impl.geo.Geodetic;
import org.cresques.impl.geo.Graticule;
import org.cresques.impl.geo.ProjPoint;
import org.cresques.impl.geo.Projection;
import org.cresques.px.Extent;

public class Mercator
extends Projection {
    static String name = "Mercator";
    static String abrev = "Mer";
    private static TreeMap projPool = new TreeMap();
    public static final Mercator hayford = new Mercator(Ellipsoid.hayford);
    public static final Mercator wgs84 = new Mercator(Ellipsoid.wgs84);
    private double a;
    private double f;
    private double b;
    private double Eps2;
    private double EE2;
    private double EE3;
    private double Epps2;

    public Mercator(Ellipsoid eli) {
        super(eli);
        this.grid = new Graticule(this);
        double[] p = eli.getParam();
        this.a = p[1];
        this.f = 1.0 / p[2];
        this.b = p[3];
        this.Eps2 = p[5];
        this.EE2 = this.Eps2 * this.Eps2;
        this.EE3 = this.EE2 * this.Eps2;
        this.Epps2 = p[7];
    }

    @Override
    public String getAbrev() {
        return abrev;
    }

    public static Mercator getProjection(Ellipsoid eli) {
        Mercator ret = null;
        if (projPool.containsKey(eli.getName())) {
            ret = (Mercator)projPool.get(eli.getName());
        } else {
            ret = eli == Ellipsoid.hayford ? hayford : (eli == Ellipsoid.wgs84 ? wgs84 : new Mercator(eli));
            projPool.put(eli.getName(), ret);
        }
        return ret;
    }

    public static IProjection getProjectionByName(IDatum eli, String name) {
        if (name.indexOf("ME") < 0) {
            return null;
        }
        return Mercator.getProjection((Ellipsoid)eli);
    }

    @Override
    public Point2D createPoint(double x, double y) {
        return new ProjPoint(this, x, y);
    }

    @Override
    public Point2D toGeo(Point2D mPt) {
        GeoPoint gPt = new GeoPoint();
        return this.toGeo((ProjPoint)mPt, gPt);
    }

    public GeoPoint toGeo(ProjPoint mPt, GeoPoint gPt) {
        double x1;
        double t = Math.pow(Math.E, -mPt.getY() / this.a);
        double x = 1.5707963267948966 - 2.0 * Math.atan(t);
        do {
            x1 = x;
        } while ((x = 1.5707963267948966 - 2.0 * Math.atan(t * Math.pow((1.0 - Math.sqrt(this.Eps2) * Math.sin(x)) / (1.0 + Math.sqrt(this.Eps2) * Math.sin(x)), Math.sqrt(this.Eps2) / 2.0))) - x1 > 1.0E-10);
        double lat = 1.5707963267948966 - 2.0 * Math.atan(t * Math.pow((1.0 - Math.sqrt(this.Eps2) * Math.sin(x)) / (1.0 + Math.sqrt(this.Eps2) * Math.sin(x)), Math.sqrt(this.Eps2) / 2.0));
        double lng = mPt.getX() / this.a;
        gPt.setLocation(lng * 180.0 / Math.PI, lat * 180.0 / Math.PI);
        gPt.proj = Geodetic.getProjection(((Projection)mPt.proj).eli);
        return gPt;
    }

    @Override
    public Point2D fromGeo(Point2D gPt, Point2D mPt) {
        double sl = Math.sin(((GeoPoint)gPt).Latitude.ToRadians());
        double cl = Math.cos(((GeoPoint)gPt).Latitude.ToRadians());
        double tl = (1.0 + sl) / (1.0 - sl);
        double x = this.a * ((GeoPoint)gPt).Longitude.ToRadians();
        double y = Math.pow((1.0 - Math.sqrt(this.Eps2) * sl) / (1.0 + Math.sqrt(this.Eps2) * sl), Math.sqrt(this.Eps2));
        y = this.a / 2.0 * Math.log(tl * y);
        ((ProjPoint)mPt).setLocation(x, y);
        ((ProjPoint)mPt).proj = this;
        return mPt;
    }

    private void generateGrid(Graphics2D g, Extent extent, AffineTransform mat) {
        Point2D pt1 = extent.getMin();
        double step = 3.0;
        double x = pt1.getX();
        double dist = 0.0;
        ProjPoint ppt1 = (ProjPoint)this.createPoint(x, pt1.getY());
        ProjPoint ppt2 = (ProjPoint)this.createPoint(x + 100.0, pt1.getY() - 100.0);
        GeoPoint gp1 = (GeoPoint)ppt1.toGeo();
        GeoPoint gp2 = (GeoPoint)ppt2.toGeo();
        this.generateGrid(g, extent, mat, step);
    }

    private void generateGrid(Graphics2D g, Extent extent, AffineTransform mat, double step) {
        this.grid = new Graticule(this);
        Point2D pt1 = extent.getMin();
        Point2D pt2 = extent.getMax();
        Point2D.Double ptx = new Point2D.Double(0.0, 0.0);
        ProjPoint up1 = (ProjPoint)this.createPoint(0.0, 0.0);
        ProjPoint up2 = (ProjPoint)this.createPoint(0.0, 0.0);
        Geodetic geoProj = Geodetic.getProjection((Ellipsoid)this.getDatum());
        FontMetrics fm = g.getFontMetrics();
        boolean fmWidth = false;
        int fmHeight = fm.getAscent();
        String tit = "";
        String fmt = "%G\u00ba%N";
        if (step < 1.0) {
            fmt = "%G\u00ba%M'%N";
        }
        GeoPoint gp1 = (GeoPoint)this.toGeo(new ProjPoint(pt1));
        GeoPoint gp2 = (GeoPoint)this.toGeo(new ProjPoint(pt2));
        double xAxis = gp1.getX();
        double yAxis = gp2.getY();
        System.err.println(name + ": ViewPort Extent = (" + gp1 + "," + gp2 + ")");
        double xMin = (double)((int)gp1.getX()) - 1.0;
        xMin -= xMin % step;
        double xMax = (double)((int)gp2.getX()) + 1.0;
        double yMin = (double)((int)gp1.getY()) - 1.0;
        yMin -= yMin % step;
        double yMax = (double)((int)gp2.getY()) + 1.0;
        if (xMin < -180.0) {
            xMin = -180.0;
        }
        if (xMax > 180.0) {
            xMax = 180.0;
        }
        if (yMin < -80.0) {
            yMin = -80.0;
        }
        if (yMax > 80.0) {
            yMax = 80.0;
        }
        if (xAxis < -180.0) {
            xAxis = -180.0;
        }
        if (yAxis > 80.0) {
            yAxis = 80.0;
        }
        for (double y = yMin; y <= yMax; y += step) {
            gp1 = (GeoPoint)geoProj.createPoint(xAxis, y);
            gp2 = (GeoPoint)geoProj.createPoint(xMax, y);
            this.fromGeo(gp1, up1);
            this.fromGeo(gp2, up2);
            mat.transform(up1, up1);
            mat.transform(up2, up2);
            this.grid.addLine(up1, up2);
            tit = Mercator.coordToString(y, fmt, true);
            ptx.setLocation(up1.getX() + 3.0, up1.getY() - 2.0);
            this.grid.addText(tit, ptx);
        }
        for (double x = xMin; x <= xMax; x += step) {
            gp1 = (GeoPoint)geoProj.createPoint(x, yMin);
            gp2 = (GeoPoint)geoProj.createPoint(x, yAxis);
            this.fromGeo(gp1, up1);
            this.fromGeo(gp2, up2);
            mat.transform(up1, up1);
            mat.transform(up2, up2);
            this.grid.addLine(up1, up2);
            tit = Mercator.coordToString(x, fmt, false);
            ptx.setLocation(up2.getX() + 3.0, up2.getY() + (double)fmHeight);
            this.grid.addText(tit, ptx);
        }
    }

    @Override
    public void drawGrid(Graphics2D g, ViewPortData vp) {
        this.generateGrid(g, vp.getExtent(), vp.getMat());
        this.grid.setColor(this.gridColor);
        this.grid.draw(g, vp);
    }

    public double getScale(double minX, double maxX, double width, double dpi) {
        Geodetic prj = Geodetic.getProjection((Ellipsoid)this.getDatum());
        GeoPoint pt1 = (GeoPoint)((Projection)prj).createPoint(1.0, 0.0);
        GeoPoint pt2 = (GeoPoint)((Projection)prj).createPoint(2.0, 0.0);
        ProjPoint ppt1 = (ProjPoint)this.createPoint(0.0, 0.0);
        ProjPoint ppt2 = (ProjPoint)this.createPoint(0.0, 0.0);
        this.fromGeo(pt1, ppt1);
        this.fromGeo(pt2, ppt2);
        double scale = (maxX - minX) / (ppt2.getX() - ppt1.getX()) * (dpi / 2.54 * 100.0 * 1852.0 * 60.0) / width;
        return scale;
    }

    public ICoordTrans getCT(IProjection dest) {
        return null;
    }

    public Rectangle2D getExtent(Rectangle2D extent, double scale, double wImage, double hImage, double mapUnits, double distanceUnits, double dpi) {
        Geodetic prj = Geodetic.getProjection((Ellipsoid)this.getDatum());
        GeoPoint pt1 = (GeoPoint)((Projection)prj).createPoint(1.0, 0.0);
        GeoPoint pt2 = (GeoPoint)((Projection)prj).createPoint(2.0, 0.0);
        ProjPoint ppt1 = (ProjPoint)this.createPoint(0.0, 0.0);
        ProjPoint ppt2 = (ProjPoint)this.createPoint(0.0, 0.0);
        this.fromGeo(pt1, ppt1);
        this.fromGeo(pt2, ppt2);
        double w = 0.0;
        double h = 0.0;
        double wExtent = 0.0;
        double hExtent = 0.0;
        w = wImage / dpi * 2.54;
        h = hImage / dpi * 2.54;
        wExtent = w * scale * distanceUnits / (ppt2.getX() - ppt1.getX()) / (mapUnits * 1852.0 * 60.0);
        hExtent = h * scale * distanceUnits / (ppt2.getX() - ppt1.getX()) / (mapUnits * 1852.0 * 60.0);
        double xExtent = extent.getCenterX() - wExtent / 2.0;
        double yExtent = extent.getCenterY() - hExtent / 2.0;
        Rectangle2D.Double rec = new Rectangle2D.Double(xExtent, yExtent, wExtent, hExtent);
        return rec;
    }

    public String getFullCode() {
        return this.getAbrev();
    }

    @Override
    public String export(String arg0) {
        return null;
    }
}

