/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.impl.geo;

import java.awt.geom.Point2D;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.cresques.impl.geo.Ellipsoid;
import org.cresques.impl.geo.ProjPoint;
import org.cresques.impl.geo.Projection;
import org.cresques.impl.geo.UtmZone;

public class UtmPoint
extends ProjPoint {
    public UtmPoint() {
        this.proj = UtmZone.getProjection(Ellipsoid.hayford, 30, UtmZone.NORTH);
        this.setLocation(0.0, 0.0);
    }

    public UtmPoint(double x, double y) {
        this.proj = UtmZone.getProjection(Ellipsoid.hayford, 30, UtmZone.NORTH);
        this.setLocation(x, y);
    }

    public UtmPoint(Point2D pt) {
        this.proj = UtmZone.getProjection(Ellipsoid.hayford, 30, UtmZone.NORTH);
        this.setLocation(pt.getX(), pt.getY());
    }

    public UtmPoint(UtmZone zone) {
        this.setLocation(0.0, 0.0);
        this.proj = zone;
    }

    public UtmPoint(UtmZone zone, double x, double y) {
        this.setLocation(x, y);
        this.proj = zone;
    }

    public UtmPoint(UtmZone zone, Point2D pt) {
        this.setLocation(pt.getX(), pt.getY());
        this.proj = zone;
    }

    @Override
    public IProjection getProjection() {
        return this.proj;
    }

    @Override
    public void reProject(ICoordTrans rp) {
    }

    @Override
    public double getX() {
        return this.X;
    }

    @Override
    public double getY() {
        return this.Y;
    }

    @Override
    public void setLocation(double x, double y) {
        this.X = x;
        this.Y = y;
    }

    @Override
    public String toString() {
        return "(" + ((UtmZone)this.proj).Zone + ": " + this.getX() + "," + this.getY() + ")";
    }

    @Override
    public Point2D toGeo() {
        return ((Projection)this.proj).toGeo(this);
    }
}

