/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.impl;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.dynform.DynFormDefinition;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.DynFormLocator;
import org.gvsig.tools.dynform.DynFormManager;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.impl.DefaultJProblemIndicator;
import org.gvsig.tools.dynform.impl.DefaultZoomDialog;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynform.JDynFormFactory;
import org.gvsig.tools.dynform.spi.dynformfield.JCustomSpinner;
import org.gvsig.tools.dynform.spi.dynformfield.JCustomTextArea;
import org.gvsig.tools.dynform.spi.dynformfield.JCustomTextField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.dynform.spi.dynformfield.JProblemIndicator;
import org.gvsig.tools.dynform.spi.dynformfield.JZoomDialog;
import org.gvsig.tools.dynform.spi.dynformset.JDynFormSetFactory;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.service.spi.NotRegisteredException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDynFormSPIManager
implements DynFormSPIManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDynFormSPIManager.class);
    private DynFormManager manager = null;
    private final Map<String, JDynFormFactory> forms = new HashMap<String, JDynFormFactory>();
    private final Map<String, JDynFormSetFactory> formSets = new HashMap<String, JDynFormSetFactory>();
    private final List<JDynFormFieldFactory> formFields = new ArrayList<JDynFormFieldFactory>();
    private final Map<String, DynFormSPIManager.PopupMenuActionFactory> popupMenuActions = new HashMap<String, DynFormSPIManager.PopupMenuActionFactory>();

    public DynFormSPIManager.ComponentsFactory createDefaultComponentsFactory() {
        return new DefaultComponentsFactory();
    }

    public DynFormManager getDynFormManager() {
        if (this.manager == null) {
            this.manager = DynFormLocator.getDynFormManager();
        }
        return this.manager;
    }

    public JZoomDialog createJZoomDialog(String title, String message, String text) {
        return new DefaultZoomDialog(title, text);
    }

    public JProblemIndicator createProblemIndicator(JDynFormField field) {
        return new DefaultJProblemIndicator(field);
    }

    public void configurePopupMenu(JDynFormField jfield) {
        for (DynFormSPIManager.PopupMenuActionFactory factory : this.getPopupMenuActionFactories()) {
            if (factory == null || !factory.isApplicable(jfield)) continue;
            jfield.addActionToPopupMenu(factory.getName(), factory.create(jfield));
        }
    }

    public Iterable<DynFormSPIManager.PopupMenuActionFactory> getPopupMenuActionFactories() {
        return this.popupMenuActions.values();
    }

    public void addPopupMenuAction(DynFormSPIManager.PopupMenuActionFactory factory) {
        this.popupMenuActions.put(factory.getName(), factory);
    }

    public void registerDynFieldFactory(JDynFormFieldFactory factory) {
        this.formFields.add(factory);
        this.formFields.sort(null);
    }

    public void registerDynFormFactory(JDynFormFactory factory) {
        this.forms.put(factory.getName(), factory);
    }

    public void registerDynFormSetFactory(JDynFormSetFactory factory) {
        this.formSets.put(factory.getName(), factory);
    }

    public JDynFormFactory getJDynFormFactory(JDynForm.DynFormContext context, DynFormDefinition definition) throws NotRegisteredException {
        for (JDynFormFactory factory : this.forms.values()) {
            if (!factory.isApplicableTo(context, definition)) continue;
            return factory;
        }
        throw new NotRegisteredException(definition.getName());
    }

    public JDynFormSetFactory getJDynFormSetFactory(JDynForm.DynFormContext context, DynFormDefinition definition, Tags contextTags) throws NotRegisteredException {
        for (JDynFormSetFactory factory : this.formSets.values()) {
            if (!factory.isApplicableTo(context, definition, contextTags)) continue;
            return factory;
        }
        throw new NotRegisteredException(definition.getName());
    }

    public JDynFormFieldFactory getJDynFormFieldFactory(JDynForm.DynFormContext context, DynFormFieldDefinition definition) throws NotRegisteredException {
        for (JDynFormFieldFactory factory : this.formFields) {
            if (!factory.isApplicableTo(context, definition)) continue;
            return factory;
        }
        LOGGER.warn("Can't get JDynFormFieldFactory for '" + definition.getName() + "'.");
        JDynFormFieldFactory factory = this.getJDynFormFieldFactory("UNKNOWN");
        if (factory == null) {
            throw new NotRegisteredException(definition.getName());
        }
        return factory;
    }

    public JDynFormFieldFactory getJDynFormFieldFactory(String name) {
        for (JDynFormFieldFactory factory : this.formFields) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)factory.getName())) continue;
            return factory;
        }
        return null;
    }

    public List<JDynFormFieldFactory> getJDynFormFieldFactories() {
        return Collections.unmodifiableList(this.formFields);
    }

    public String dumpFactories() {
        StringBuilder builder = new StringBuilder();
        builder.append("JDynForm factories:\n");
        for (JDynFormFactory jDynFormFactory : this.forms.values()) {
            builder.append("- ").append(jDynFormFactory).append("\n");
        }
        builder.append("JDynFormSet factories:\n");
        for (JDynFormSetFactory jDynFormSetFactory : this.formSets.values()) {
            builder.append("- ").append(jDynFormSetFactory).append("\n");
        }
        builder.append("JDynFormField factories:\n");
        for (JDynFormFieldFactory jDynFormFieldFactory : this.formFields) {
            builder.append("- ").append(jDynFormFieldFactory).append("\n");
        }
        return builder.toString();
    }

    class DefaultComponentsFactory
    implements DynFormSPIManager.ComponentsFactory {
        DefaultComponentsFactory() {
        }

        public boolean containsComponents(DynFormFieldDefinition definition) {
            return false;
        }

        public boolean containsJComboBox(DynFormFieldDefinition definition, String suffix) {
            return false;
        }

        public boolean containsJLabel(DynFormFieldDefinition definition, String suffix) {
            return false;
        }

        public boolean containsJButton(DynFormFieldDefinition definition, String suffix) {
            return false;
        }

        public boolean containsJToggleButton(DynFormFieldDefinition definition, String suffix) {
            return false;
        }

        public boolean containsJSpinner(DynFormFieldDefinition definition, String suffix) {
            return false;
        }

        public boolean containsJTextField(DynFormFieldDefinition definition, String suffix) {
            return false;
        }

        public boolean containsJTextArea(DynFormFieldDefinition definition, String suffix) {
            return false;
        }

        public JCheckBox getJCheckBox(DynFormFieldDefinition definition, String suffix) {
            return new JCheckBox();
        }

        public JLabel getJLabel(DynFormFieldDefinition definition, String suffix) {
            return new JLabel();
        }

        public JButton getJButton(DynFormFieldDefinition definition, String suffix) {
            return new JButton();
        }

        public JToggleButton getJToggleButton(DynFormFieldDefinition definition, String suffix) {
            return new JToggleButton();
        }

        public JSpinner getJSpinner(DynFormFieldDefinition definition, String suffix) {
            return new JCustomSpinner(definition.getLabel());
        }

        public JComboBox getJComboBox(DynFormFieldDefinition definition, String suffix) {
            return new JComboBox();
        }

        public JTextComponent getJTextField(DynFormFieldDefinition definition, String suffix) {
            JCustomTextField text = new JCustomTextField(definition.getLabel());
            text.setColumns(1);
            return text;
        }

        public JTextComponent getJPasswordField(DynFormFieldDefinition definition, String suffix) {
            return new JPasswordField(definition.getLabel());
        }

        public DynFormSPIManager.ComponentsFactory.ScrolledComponent<JTextArea> getJTextArea(DynFormFieldDefinition definition, String suffix) {
            JCustomTextArea component = new JCustomTextArea(definition.getLabel());
            JScrollPane scrollPane = new JScrollPane((Component)component);
            return new DefaultScrolledComponent<JCustomTextArea>(scrollPane, component);
        }

        public DynFormSPIManager.ComponentsFactory.ScrolledComponent<JList> getJList(DynFormFieldDefinition definition, String suffix) {
            JList component = new JList();
            JScrollPane scrollPane = new JScrollPane(component);
            return new DefaultScrolledComponent<JList>(scrollPane, component);
        }

        public DynFormSPIManager.ComponentsFactory.ScrolledComponent<JTable> getJTable(DynFormFieldDefinition definition, String suffix) {
            JTable component = new JTable();
            JScrollPane scrollPane = new JScrollPane(component);
            return new DefaultScrolledComponent<JTable>(scrollPane, component);
        }

        private class DefaultScrolledComponent<T>
        implements DynFormSPIManager.ComponentsFactory.ScrolledComponent<T> {
            private final T component;
            private final JScrollPane scrollPane;

            public DefaultScrolledComponent(JScrollPane scrollPane, T component) {
                this.component = component;
                this.scrollPane = scrollPane;
            }

            public JScrollPane getScrollPane() {
                return this.scrollPane;
            }

            public T getComponent() {
                return this.component;
            }
        }
    }
}

