/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.converstocode;

import java.util.Map;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ConverterToCode;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.MutableCodes;
import org.gvsig.fmap.geom.Geometry;

public class GeometryToCode
implements ConverterToCode {
    public String getName() {
        return "Geometry";
    }

    public boolean isApplicable(Object ... os) {
        return os[0] instanceof Geometry;
    }

    public Code toCode(CodeBuilder builder, Object obj, Map props) {
        try {
            if (obj == null) {
                return null;
            }
            Geometry geom = (Geometry)obj;
            IProjection proj = geom.getProjection();
            if (proj == null) {
                MutableCodes args = builder.args();
                args.add((Code)builder.constant((Object)geom.convertToWKT()));
                return builder.function("ST_GEOMFROMTEXT", (Codes)args);
            }
            String abrev = geom.getProjection().getAbrev();
            String srid = abrev.split(":")[1];
            MutableCodes args = builder.args();
            args.add((Code)builder.constant((Object)geom.convertToWKT()));
            Code.Callable geomFromText = builder.function("ST_GEOMFROMTEXT", (Codes)args);
            MutableCodes args2 = builder.args();
            args2.add((Code)geomFromText);
            args2.add((Code)builder.constant((Object)Integer.valueOf(srid)));
            return builder.function("ST_SETSRID", (Codes)args2);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Can't convert geometry to code", ex);
        }
    }

    public static void selfRegister() {
        ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
        manager.registerCodeConverter((ConverterToCode)new GeometryToCode());
    }
}

