/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.utils.LogWriter;

public class StandardFonts {
    private static Map unicode_name_mapping_table = new Hashtable();
    private static String[][] unicode_char_decoding_table = new String[7][335];
    public static final int PDF = 6;
    public static final int ZAPF = 5;
    public static final int SYMBOL = 4;
    public static final int MACEXPERT = 3;
    public static final int WIN = 2;
    public static final int STD = 1;
    public static final int MAC = 0;
    public static final int TYPE0 = 1228944676;
    public static final int TYPE1 = 1228944677;
    public static final int TRUETYPE = 1217103210;
    public static final int TYPE3 = 1228944679;
    public static final int CIDTYPE0 = -1684566726;
    public static final int CIDTYPE2 = -1684566724;
    public static final int OPENTYPE = 6;
    public static final int TRUETYPE_COLLECTION = 7;
    public static final int FONT_UNSUPPORTED = 8;
    private static String ellipsis = String.valueOf((char)Integer.parseInt("2026", 16));
    private static final String enc = "Cp1252";
    private static Map uniqueValues = null;
    private static Map[] glyphToChar = new Hashtable[7];
    private static String[] MAC_char_encoding_table;
    private static String[] WIN_char_encoding_table;
    private static String[] STD_char_encoding_table;
    private static String[] PDF_char_encoding_table;
    private static String[] ZAPF_char_encoding_table;
    private static String[] SYMBOL_char_encoding_table;
    private static String[] MACEXPERT_char_encoding_table;
    private static ClassLoader loader;
    private static Hashtable standardFileList;
    private static Hashtable standardFontLoaded;
    private static Map widthTableStandard;
    protected static Map javaFontList;
    protected static String[] javaFonts;
    protected static String[] files_names;
    protected static String[] files_names_bis;
    private static Hashtable adobeMap;
    private static Map fontBounds;
    public static boolean usesGlyphlist;

    public static void dispose() {
        unicode_name_mapping_table = null;
        unicode_char_decoding_table = null;
        uniqueValues = null;
        glyphToChar = null;
        MAC_char_encoding_table = null;
        WIN_char_encoding_table = null;
        STD_char_encoding_table = null;
        PDF_char_encoding_table = null;
        ZAPF_char_encoding_table = null;
        SYMBOL_char_encoding_table = null;
        MACEXPERT_char_encoding_table = null;
        loader = null;
        standardFileList = null;
        standardFontLoaded = null;
        widthTableStandard = null;
        javaFontList = null;
        javaFonts = null;
        files_names = null;
        files_names_bis = null;
        adobeMap = null;
        fontBounds = null;
    }

    public static int getFontType(String string) {
        int n = 8;
        if (string.endsWith(".ttf")) {
            n = 1217103210;
        } else if (string.endsWith(".otf")) {
            n = 6;
        } else if (string.endsWith(".ttc")) {
            n = 7;
        } else if (string.endsWith(".pfb")) {
            n = 1228944677;
        }
        return n;
    }

    public static float[] getFontBounds(String string) {
        return (float[])fontBounds.get(string);
    }

    public static String getUnicodeName(String string) {
        return (String)unicode_name_mapping_table.get(string);
    }

    public static String getUnicodeChar(int n, int n2) {
        return unicode_char_decoding_table[n][n2];
    }

    public static Map getUniqueMappings() {
        if (uniqueValues == null) {
            uniqueValues = new HashMap();
            for (int i = 0; i < 256; ++i) {
                if (WIN_char_encoding_table[i] == null && MAC_char_encoding_table[i] != null) {
                    uniqueValues.put(new Integer(i), new Integer(1));
                }
                if (WIN_char_encoding_table[i] == null || MAC_char_encoding_table[i] != null) continue;
                uniqueValues.put(new Integer(i), new Integer(-1));
            }
        }
        return uniqueValues;
    }

    public static Float getStandardWidth(String string, String string2) {
        String string3;
        int n;
        Object v = widthTableStandard.get(string + string2);
        if (v == null && (n = (string3 = string).indexOf(44)) != -1) {
            string3 = string3.substring(0, n);
            v = widthTableStandard.get(string3 + string2);
        }
        return (Float)v;
    }

    private static final void readStandardMappingTable(int n, String string) {
        String string2 = null;
        String string3 = null;
        int n2 = 0;
        BufferedReader bufferedReader = null;
        StandardFonts.glyphToChar[n] = new Hashtable();
        try {
            BufferedReader bufferedReader2 = bufferedReader = string.equals("symbol.cfg") ? new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/" + string), enc)) : new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/" + string), "UTF-16"));
            if (bufferedReader == null) {
                LogWriter.writeLog("Unable to open " + string + " to read standard encoding");
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                String string4;
                String string5;
                String string6;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                if (string2.indexOf("space") != -1 || stringTokenizer.countTokens() <= 1) continue;
                if (stringTokenizer.countTokens() == 3) {
                    string6 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                } else if (stringTokenizer.countTokens() == 4) {
                    string3 = stringTokenizer.nextToken();
                    string6 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                    string6 = Character.toString((char)Integer.parseInt(string3, 16));
                } else if (stringTokenizer.countTokens() == 2) {
                    string6 = " ";
                    string5 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                } else {
                    string6 = stringTokenizer.nextToken();
                    string5 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                }
                unicode_name_mapping_table.put(n + string5, string6);
                glyphToChar[n].put(string5, new Integer(Integer.parseInt(string4)));
                unicode_name_mapping_table.put(string5, string6);
                if (!Character.isDigit(string4.charAt(0))) continue;
                n2 = Integer.parseInt(string4, 8);
                if (n == 5) {
                    StandardFonts.ZAPF_char_encoding_table[n2] = string6;
                } else if (n == 4) {
                    StandardFonts.SYMBOL_char_encoding_table[n2] = string6;
                } else if (n == 3) {
                    StandardFonts.MACEXPERT_char_encoding_table[n2] = string6;
                }
                StandardFonts.unicode_char_decoding_table[n][n2] = string5;
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf");
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    private static final void readStandardMappingTable(int n) {
        String string = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string2 = null;
        BufferedReader bufferedReader = null;
        if (n == 0) {
            StandardFonts.checkLoaded(2);
        }
        try {
            StandardFonts.glyphToChar[n] = new Hashtable();
            bufferedReader = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/standard_encoding.cfg"), enc));
            usesGlyphlist = true;
            if (bufferedReader == null) {
                LogWriter.writeLog("Unable to open standard_encoding.cfg from jar");
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                int n5 = stringTokenizer.countTokens();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                String string7 = stringTokenizer.nextToken();
                String string8 = stringTokenizer.nextToken();
                string = n5 == 7 ? Character.toString((char)Integer.parseInt(string8, 16)) : string8;
                if (n == 0 && Character.isDigit(string5.charAt(0))) {
                    n2 = Integer.parseInt(string5, 8);
                    if (n2 == 201) {
                        string = ellipsis;
                    }
                    StandardFonts.MAC_char_encoding_table[n2] = string;
                    StandardFonts.unicode_char_decoding_table[0][n2] = string3;
                    glyphToChar[0].put(string3, new Integer(n2));
                    if (Character.isDigit(string6.charAt(0))) {
                        n3 = Integer.parseInt(string6, 8);
                    }
                } else if (n == 1 && Character.isDigit(string4.charAt(0))) {
                    n4 = Integer.parseInt(string4, 8);
                    if (n4 == 188) {
                        string = ellipsis;
                    }
                    StandardFonts.STD_char_encoding_table[n4] = string;
                    StandardFonts.unicode_char_decoding_table[1][n4] = string3;
                    glyphToChar[1].put(string3, new Integer(n4));
                } else if (n == 6 && Character.isDigit(string7.charAt(0))) {
                    n4 = Integer.parseInt(string7, 8);
                    if (n4 == 131) {
                        string = ellipsis;
                    }
                    StandardFonts.PDF_char_encoding_table[n4] = string;
                    StandardFonts.unicode_char_decoding_table[6][n4] = string3;
                } else if (n == 2 && Character.isDigit(string6.charAt(0))) {
                    n3 = Integer.parseInt(string6, 8);
                    if (n3 == 133) {
                        string = ellipsis;
                    }
                    StandardFonts.WIN_char_encoding_table[n3] = string;
                    StandardFonts.unicode_char_decoding_table[2][n3] = string3;
                    glyphToChar[2].put(string3, new Integer(n3));
                }
                unicode_name_mapping_table.put(string3, string);
            }
            if (n == 0) {
                StandardFonts.MAC_char_encoding_table[202] = " ";
            }
            if (n == 2) {
                StandardFonts.WIN_char_encoding_table[160] = " ";
                StandardFonts.WIN_char_encoding_table[255] = "-";
                StandardFonts.unicode_char_decoding_table[2][160] = "space";
            }
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for " + n);
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    public static String getEncodedChar(int n, int n2) {
        String string = null;
        if (n == 2) {
            string = WIN_char_encoding_table[n2];
        } else if (n == 1) {
            string = STD_char_encoding_table[n2];
        } else if (n == 0) {
            string = MAC_char_encoding_table[n2];
        } else if (n == 6) {
            string = PDF_char_encoding_table[n2];
        } else if (n == 5) {
            string = ZAPF_char_encoding_table[n2];
        } else if (n == 4) {
            string = SYMBOL_char_encoding_table[n2];
        } else if (n == 3) {
            string = MACEXPERT_char_encoding_table[n2];
        }
        if (string == null) {
            string = "&#" + n2 + ';';
        }
        return string;
    }

    public static boolean isValidMacEncoding(int n) {
        return MAC_char_encoding_table[n] != null;
    }

    public static boolean isValidWinEncoding(int n) {
        return WIN_char_encoding_table[n] != null;
    }

    public static void checkLoaded(int n) {
        if (n == 0 && MAC_char_encoding_table == null) {
            MAC_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(n);
        } else if (n == 2 && WIN_char_encoding_table == null) {
            WIN_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(n);
        } else if (n == 1 && STD_char_encoding_table == null) {
            STD_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(n);
        } else if (n == 6 && PDF_char_encoding_table == null) {
            PDF_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(n);
        } else if (n == 4 && SYMBOL_char_encoding_table == null) {
            SYMBOL_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(4, "symbol.cfg");
        } else if (n == 5 && ZAPF_char_encoding_table == null) {
            ZAPF_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(5, "zapf.cfg");
        } else if (n == 3 && MACEXPERT_char_encoding_table == null) {
            MACEXPERT_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(3, "mac_expert.cfg");
        }
    }

    private static final void loadStandardFont(int n) throws IOException {
        String string = "";
        String string2 = "";
        String string3 = "";
        BufferedReader bufferedReader = null;
        float f = 200.0f;
        bufferedReader = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/defaults/" + files_names[n] + ".afm"), enc));
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            Object object;
            if (string.startsWith("EndCharMetrics")) {
                bl = false;
            }
            if (string.startsWith("FontBBox")) {
                object = new float[4];
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                stringTokenizer.nextToken();
                for (int i = 0; i < 4; ++i) {
                    object[i] = (float)Integer.parseInt(stringTokenizer.nextToken());
                }
                fontBounds.put(files_names[n], object);
            }
            if (bl) {
                object = new StringTokenizer(string, " ;");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string2 = ((StringTokenizer)object).nextToken();
                    if (string2.equals("WX")) {
                        f = Float.parseFloat(((StringTokenizer)object).nextToken()) / 1000.0f;
                        continue;
                    }
                    if (!string2.equals("N")) continue;
                    string3 = ((StringTokenizer)object).nextToken();
                }
                widthTableStandard.put(files_names_bis[n] + string3, new Float(f));
                widthTableStandard.put(files_names[n] + string3, new Float(f));
            }
            if (!string.startsWith("StartCharMetrics")) continue;
            bl = true;
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    protected static void loadStandardFontWidth(String string) {
        Integer n = (Integer)standardFileList.get(string);
        if (n != null && standardFontLoaded.get(n) == null) {
            standardFontLoaded.put(n, "x");
            try {
                StandardFonts.loadStandardFont(n);
            }
            catch (Exception exception) {
                LogWriter.writeLog("[PDF] " + exception + " problem reading lookup table for pdf font " + string + ' ' + string);
            }
        }
    }

    public static int lookupCharacterIndex(String string, int n) {
        Object v = glyphToChar[n].get(string);
        if (v == null) {
            return 0;
        }
        return (Integer)v;
    }

    private static void loadAdobeMap() {
        BufferedReader bufferedReader = null;
        if (adobeMap == null) {
            try {
                String string;
                adobeMap = new Hashtable();
                bufferedReader = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/glyphlist.cfg"), enc));
                if (bufferedReader == null) {
                    LogWriter.writeLog("Unable to open glyphlist.cfg from jar");
                }
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith("#") || string.indexOf(59) == -1) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                    String string2 = stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    int n = string3.indexOf(32);
                    if (n != -1) {
                        string3 = string3.substring(0, n);
                    }
                    int n2 = Integer.parseInt(string3, 16);
                    adobeMap.put(string2, new Integer(n2));
                    unicode_name_mapping_table.put(string2, Character.toString((char)n2));
                }
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for abobe map");
                exception.printStackTrace();
            }
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for abobe map");
            }
        }
    }

    public static int getAdobeMap(String string) {
        Object v = adobeMap.get(string);
        if (v == null) {
            return -1;
        }
        return (Integer)v;
    }

    public static boolean isValidGlyphName(String string) {
        if (string == null) {
            return false;
        }
        return adobeMap.get(string) != null;
    }

    public static boolean isStandardFont(String string, boolean bl) {
        int n;
        boolean bl2;
        boolean bl3 = bl2 = standardFileList.get(string) != null;
        if (!bl2 && bl && (n = string.indexOf("-")) != -1) {
            String string2 = string.substring(0, n);
            bl2 = standardFileList.get(string2) != null;
        }
        return bl2;
    }

    public static Map getFontDetails(int n, String string) {
        HashMap hashMap = new HashMap();
        if (n == 1217103210 || n == 7) {
            TTGlyphs tTGlyphs = new TTGlyphs();
            TTGlyphs.addStringValues(new FontData(string), hashMap);
        }
        return hashMap;
    }

    public static String[] readNamesFromFont(int n, String string, int n2) throws Exception {
        String[] stringArray = new String[]{""};
        if (n == 1217103210 || n == 7) {
            TTGlyphs tTGlyphs = new TTGlyphs();
            stringArray = TTGlyphs.readFontNames(new FontData(string), n2);
        } else if (n == 1228944677) {
            T1Glyphs t1Glyphs = new T1Glyphs();
            stringArray = T1Glyphs.readFontNames(new FontData(string), n2);
        }
        return stringArray;
    }

    public static String convertNumberToGlyph(String string, boolean bl) {
        int n = string.length();
        boolean bl2 = true;
        if (n == 2 || n == 3) {
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c >= '0' && c <= '9') continue;
                bl2 = false;
                i = n;
            }
            if (bl2) {
                string = String.valueOf((char)Integer.parseInt(string));
            }
        }
        return string;
    }

    public static String getFontypeAsString(int n) {
        switch (n) {
            case 1217103210: {
                return "TrueType";
            }
            case 1228944677: {
                return "Type1";
            }
            case 1228944679: {
                return "Type3";
            }
            case -1684566726: {
                return "CIDFontType0";
            }
            case -1684566724: {
                return "CIDFontType2";
            }
        }
        return "Unknown";
    }

    static {
        loader = StandardFonts.class.getClassLoader();
        standardFileList = new Hashtable();
        standardFontLoaded = new Hashtable();
        widthTableStandard = new Hashtable();
        javaFontList = new Hashtable();
        javaFonts = new String[]{"Courier", "Courier-Bold", "Courier", "Courier-Bold", "Arial", "Arial-Bold", "Arial", "Arial-Italic", "Symbol", "Times New Roman", "Times New Roman", "Times New Roman", "Times New Roman", "Wingdings"};
        files_names = new String[]{"Courier", "Courier-Bold", "Courier-BoldOblique", "Courier-Oblique", "Helvetica", "Helvetica-Bold", "Helvetica-BoldOblique", "Helvetica-Oblique", "Symbol", "Times-Bold", "Times-BoldItalic", "Times-Italic", "Times-Roman", "ZapfDingbats"};
        files_names_bis = new String[]{"CourierNew", "CourierNew,Bold", "CourierNew,BoldItalic", "CourierNew,Italic", "Arial", "Arial,Bold", "Arial,BoldItalic", "Arial,Italic", "Symbol", "TimesNewRoman,Bold", "TimesNewRoman,BoldItalic", "TimesNewRoman,Italic", "TimesNewRoman", "ZapfDingbats"};
        adobeMap = null;
        fontBounds = new HashMap();
        usesGlyphlist = false;
        for (int i = 0; i < files_names.length; ++i) {
            standardFileList.put(files_names_bis[i], new Integer(i));
            standardFileList.put(files_names[i], new Integer(i));
        }
        StandardFonts.loadAdobeMap();
    }
}

