/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.wfs;

import org.apache.commons.lang3.BooleanUtils;
import org.cresques.cts.IProjection;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.spi.AbstractDataStoreParameters;
import org.gvsig.fmap.dal.store.wfs.WFSStoreProvider;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public abstract class WFSBaseStoreParameters
extends AbstractDataStoreParameters
implements DataStoreParameters {
    protected static DynClass DYNCLASS = null;
    public static final String FIELD_URL = "url";
    public static final String FIELD_VERSION = "version";
    public static final String FIELD_TYPENAME = "typeName";
    public static final String FIELD_NAMESPACE = "namespace";
    public static final String DYNFIELDNAME_NAMESPACEPREFIX = "namespacePrefix";
    public static final String DYNFIELDNAME_FIELDS = "fields";
    public static final String FIELD_FILTER_ENCODING_BY_ATTRIBUTE = "filterEncodingByAttribute";
    public static final String DYNFIELDNAME_MAXFEATURES = "maxFeatures";
    public static final String DYNFIELDNAME_TIMEOUT = "timeOut";
    public static final String DYNFIELDNAME_USER = "user";
    public static final String DYNFIELDNAME_PASSWORD = "password";
    public static final String DYNFIELDNAME_FILTER_BY_AREA_GEOMETRY = "filterByAreaGeometry";
    public static final String DYNFIELDNAME_FILTER_BY_AREA_ENVELOPE = "filterByAreaEnvelope";
    public static final String DYNFIELDNAME_FILTER_BY_AREA_OPERATION = "filterByAreaOperation";
    public static final String DYNFIELDNAME_FILTER_BY_AREA_ATTRIBUTE = "filterByAreaAttribute";
    public static final String DYNFIELDNAME_FILTER_BY_AREA_CRS = "filterByAreaCrs";
    public static final String DYNFIELDNAME_CRS = "Crs";
    public static final String DYNFIELDNAME_AUTHENTICATION_CONFIG = "authenticationConfig";
    private DelegatedDynObject delegatedDynObject = (DelegatedDynObject)ToolsLocator.getDynObjectManager().createDynObject((DynStruct)DYNCLASS);

    public WFSBaseStoreParameters() {
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.delegatedDynObject;
    }

    protected abstract String getStoreParametersName();

    public WFSBaseStoreParameters(DataParameters dataParameters) throws InitializeException, ProviderNotRegisteredException {
        this();
        this.setUrl((String)dataParameters.getDynValue(FIELD_URL));
        String namespace = null;
        String namespacePrefix = null;
        if (dataParameters.hasDynValue(FIELD_NAMESPACE)) {
            namespace = (String)dataParameters.getDynValue(FIELD_NAMESPACE);
        }
        if (dataParameters.hasDynValue(DYNFIELDNAME_NAMESPACEPREFIX)) {
            namespacePrefix = (String)dataParameters.getDynValue(DYNFIELDNAME_NAMESPACEPREFIX);
        }
        this.setFeatureType(namespacePrefix, namespace, (String)dataParameters.getDynValue(FIELD_TYPENAME));
        if (dataParameters.hasDynValue(DYNFIELDNAME_MAXFEATURES)) {
            this.setMaxFeatures((Integer)dataParameters.getDynValue(DYNFIELDNAME_MAXFEATURES));
        } else {
            this.setMaxFeatures(1000);
        }
        if (dataParameters.hasDynValue(DYNFIELDNAME_TIMEOUT)) {
            this.setTimeOut((Integer)dataParameters.getDynValue(DYNFIELDNAME_TIMEOUT));
        } else {
            this.setTimeOut(10000);
        }
        if (dataParameters.hasDynValue(DYNFIELDNAME_FILTER_BY_AREA_GEOMETRY)) {
            this.setFilterByAreaGeometry((Geometry)dataParameters.getDynValue(DYNFIELDNAME_FILTER_BY_AREA_GEOMETRY));
            this.setFilterByAreaAttribute((String)dataParameters.getDynValue(DYNFIELDNAME_FILTER_BY_AREA_ATTRIBUTE));
            this.setFilterByAreaCrs((IProjection)dataParameters.getDynValue(DYNFIELDNAME_FILTER_BY_AREA_CRS));
            this.setFilterByAreaOperation((Integer)dataParameters.getDynValue(DYNFIELDNAME_FILTER_BY_AREA_OPERATION));
        }
        if (dataParameters.hasDynValue(DYNFIELDNAME_FILTER_BY_AREA_ENVELOPE)) {
            this.setFilterByAreaEnvelope((Envelope)dataParameters.getDynValue(DYNFIELDNAME_FILTER_BY_AREA_ENVELOPE));
            this.setFilterByAreaAttribute((String)dataParameters.getDynValue(DYNFIELDNAME_FILTER_BY_AREA_ATTRIBUTE));
            this.setFilterByAreaCrs((IProjection)dataParameters.getDynValue(DYNFIELDNAME_FILTER_BY_AREA_CRS));
            this.setFilterByAreaOperation((Integer)dataParameters.getDynValue(DYNFIELDNAME_FILTER_BY_AREA_OPERATION));
        }
        if (dataParameters.hasDynValue(FIELD_VERSION)) {
            this.setVersion((String)dataParameters.getDynValue(FIELD_VERSION));
        }
        if (dataParameters.hasDynValue(FIELD_FILTER_ENCODING_BY_ATTRIBUTE)) {
            this.setFilterEncodingByAttribute((String)dataParameters.getDynValue(FIELD_FILTER_ENCODING_BY_ATTRIBUTE));
        }
        if (dataParameters.hasDynValue(DYNFIELDNAME_USER)) {
            this.setUser((String)dataParameters.getDynValue(DYNFIELDNAME_USER));
        }
        if (dataParameters.hasDynValue(DYNFIELDNAME_PASSWORD)) {
            this.setPassword((String)dataParameters.getDynValue(DYNFIELDNAME_PASSWORD));
        }
        if (dataParameters.hasDynValue(DYNFIELDNAME_CRS)) {
            this.setCrs((String)dataParameters.getDynValue(DYNFIELDNAME_CRS));
        }
    }

    protected static void registerParameterClass(Class parametersClass, String parametersName) {
        if (DYNCLASS == null) {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            DynStruct definition = manager.addDefinition(parametersClass, parametersName, parametersName + " Persistence definition", null, null);
            definition.addDynFieldString(FIELD_URL).setDescription("URL of the WFS server").setMandatory(true);
            definition.addDynFieldString(FIELD_VERSION).setDescription("Version of the WFS server").setMandatory(false);
            definition.addDynFieldString(FIELD_TYPENAME).setDescription("Feature type to retrieve").setMandatory(true);
            definition.addDynFieldString(FIELD_NAMESPACE).setDescription("Namespace of the feature type to retrieve").setMandatory(false);
            definition.addDynFieldString(DYNFIELDNAME_NAMESPACEPREFIX).setDescription("Prefix of the namespace of the feature type to retrieve").setMandatory(false);
            definition.addDynFieldString(DYNFIELDNAME_FIELDS).setDescription("Fields to retrieve separated by ','").setMandatory(false);
            definition.addDynFieldString(FIELD_FILTER_ENCODING_BY_ATTRIBUTE).setDescription("Filter encoding request").setMandatory(false);
            definition.addDynFieldInt(DYNFIELDNAME_MAXFEATURES).setDescription("Number of features to retrieve").setMandatory(false);
            definition.addDynFieldInt(DYNFIELDNAME_TIMEOUT).setDescription("Timeout").setMandatory(false);
            definition.addDynFieldString(DYNFIELDNAME_USER).setDescription("User name (not used at this moment)").setMandatory(false);
            definition.addDynFieldString(DYNFIELDNAME_PASSWORD).setDescription("Password (not used at this moment").setMandatory(false);
            definition.addDynFieldObject(DYNFIELDNAME_FILTER_BY_AREA_GEOMETRY).setType(66).setDescription("Geometry used to do the filter").setMandatory(false);
            definition.addDynFieldObject(DYNFIELDNAME_FILTER_BY_AREA_ENVELOPE).setType(67).setDescription("Envelope used to do the filter").setMandatory(false);
            definition.addDynFieldInt(DYNFIELDNAME_FILTER_BY_AREA_OPERATION).setDescription("Geometry operation used to do the filter").setMandatory(false);
            definition.addDynFieldString(DYNFIELDNAME_FILTER_BY_AREA_ATTRIBUTE).setDescription("Attribute that contains the geometry").setMandatory(false);
            definition.addDynFieldObject(DYNFIELDNAME_FILTER_BY_AREA_CRS).setType(65).setDescription("CRS to do the spatial filter of the query").setMandatory(false);
            definition.addDynFieldString(DYNFIELDNAME_CRS).setDescription("CRS").setMandatory(false);
            definition.addDynFieldBoolean("useAxisOrderYX").setDefaultFieldValue((Object)"false").setMandatory(false);
            definition.addDynFieldBoolean("ignoreCache").setDefaultFieldValue((Object)"false").setMandatory(false);
            definition.addDynFieldString(DYNFIELDNAME_AUTHENTICATION_CONFIG).setDescription("Authentication config").setMandatory(false);
            DYNCLASS = (DynClass)definition;
        }
    }

    public String getDataStoreName() {
        return WFSStoreProvider.NAME;
    }

    public String getDescription() {
        return WFSStoreProvider.DESCRIPTION;
    }

    public boolean isValid() {
        return false;
    }

    public String getUrl() {
        return (String)this.getDynValue(FIELD_URL);
    }

    public void setUrl(String url) {
        this.setDynValue(FIELD_URL, url);
    }

    public String getVersion() {
        return (String)this.getDynValue(FIELD_VERSION);
    }

    public void setVersion(String version) {
        this.setDynValue(FIELD_VERSION, version);
    }

    public String getFeatureType() {
        return (String)this.getDynValue(FIELD_TYPENAME);
    }

    public void setFeatureType(String featureType) {
        this.setDynValue(FIELD_TYPENAME, featureType);
    }

    public void setFeatureType(String namespace, String featureType) {
        this.setDynValue(FIELD_NAMESPACE, namespace);
        this.setDynValue(FIELD_TYPENAME, featureType);
    }

    public void setFeatureType(String prefix, String namespace, String featureType) {
        this.setDynValue(DYNFIELDNAME_NAMESPACEPREFIX, prefix);
        this.setDynValue(FIELD_NAMESPACE, namespace);
        this.setDynValue(FIELD_TYPENAME, featureType);
    }

    public String getFeatureNamespace() {
        return (String)this.getDynValue(FIELD_NAMESPACE);
    }

    public void setFeatureNamespace(String nameSpace) {
        this.setDynValue(FIELD_NAMESPACE, nameSpace);
    }

    public String getFeaturePrefix() {
        return (String)this.getDynValue(DYNFIELDNAME_NAMESPACEPREFIX);
    }

    public String getFields() {
        return (String)this.getDynValue(DYNFIELDNAME_FIELDS);
    }

    public void setFields(String fields) {
        this.setDynValue(DYNFIELDNAME_FIELDS, fields);
    }

    public String getFilterEncodingByAttribute() {
        return (String)this.getDynValue(FIELD_FILTER_ENCODING_BY_ATTRIBUTE);
    }

    public void setFilterEncodingByAttribute(String filter) {
        this.setDynValue(FIELD_FILTER_ENCODING_BY_ATTRIBUTE, filter);
    }

    public Integer getMaxFeatures() {
        return (Integer)this.getDynValue(DYNFIELDNAME_MAXFEATURES);
    }

    public void setMaxFeatures(Integer maxFeatures) {
        this.setDynValue(DYNFIELDNAME_MAXFEATURES, maxFeatures);
    }

    public Integer getTimeOut() {
        return (Integer)this.getDynValue(DYNFIELDNAME_TIMEOUT);
    }

    public void setTimeOut(Integer timeOut) {
        this.setDynValue(DYNFIELDNAME_TIMEOUT, timeOut);
    }

    public String getUser() {
        return (String)this.getDynValue(DYNFIELDNAME_USER);
    }

    public void setUser(String user) {
        this.setDynValue(DYNFIELDNAME_USER, user);
    }

    public String getPassword() {
        return (String)this.getDynValue(DYNFIELDNAME_PASSWORD);
    }

    public void setPassword(String password) {
        this.setDynValue(DYNFIELDNAME_PASSWORD, password);
    }

    public Geometry getFilterByAreaGeometry() {
        return (Geometry)this.getDynValue(DYNFIELDNAME_FILTER_BY_AREA_GEOMETRY);
    }

    public void setFilterByAreaGeometry(Geometry area) {
        this.setDynValue(DYNFIELDNAME_FILTER_BY_AREA_GEOMETRY, area);
    }

    public Envelope getFilterByAreaEnvelope() {
        return (Envelope)this.getDynValue(DYNFIELDNAME_FILTER_BY_AREA_ENVELOPE);
    }

    public void setFilterByAreaEnvelope(Envelope area) {
        this.setDynValue(DYNFIELDNAME_FILTER_BY_AREA_ENVELOPE, area);
    }

    public Integer getFilterByAreaOperation() {
        return (Integer)this.getDynValue(DYNFIELDNAME_FILTER_BY_AREA_OPERATION);
    }

    public void setFilterByAreaOperation(Integer operation) {
        this.setDynValue(DYNFIELDNAME_FILTER_BY_AREA_OPERATION, operation);
    }

    public IProjection getFilterByAreaCrs() {
        return (IProjection)this.getDynValue(DYNFIELDNAME_FILTER_BY_AREA_CRS);
    }

    public void setFilterByAreaCrs(IProjection crs) {
        this.setDynValue(DYNFIELDNAME_FILTER_BY_AREA_CRS, crs);
    }

    public String getCrs() {
        return (String)this.getDynValue(DYNFIELDNAME_CRS);
    }

    public void setCrs(String crs) {
        this.setDynValue(DYNFIELDNAME_CRS, crs);
    }

    public String getFilterByAreaAttribute() {
        return (String)this.getDynValue(DYNFIELDNAME_FILTER_BY_AREA_ATTRIBUTE);
    }

    public void setFilterByAreaAttribute(String attribute) {
        this.setDynValue(DYNFIELDNAME_FILTER_BY_AREA_ATTRIBUTE, attribute);
    }

    public boolean getUseAxisOrderYX() {
        Boolean x = (Boolean)this.getDynValue("useAxisOrderYX");
        return BooleanUtils.isTrue((Boolean)x);
    }

    public void setUseAxisOrderYX(boolean useAxisOrderYX) {
        this.setDynValue("useAxisOrderYX", useAxisOrderYX);
    }

    public boolean getIgnoreCache() {
        Boolean x = (Boolean)this.getDynValue("ignoreCache");
        return BooleanUtils.isTrue((Boolean)x);
    }

    public void setIgnoreCache(boolean ignoreCache) {
        this.setDynValue("ignoreCache", ignoreCache);
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        this.setDynValue(DYNFIELDNAME_AUTHENTICATION_CONFIG, downloader.getAuthenticationConfigurationServiceAsString(this.getUrl()));
        super.saveToState(state);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        DownloaderManager downloader = DownloaderLocator.getDownloaderManager();
        downloader.registerAuthenticationConfigurationService((String)this.getDynValue(DYNFIELDNAME_AUTHENTICATION_CONFIG));
    }

    public String getProviderName() {
        return WFSStoreProvider.NAME;
    }
}

