/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.wfs;

import java.util.ArrayList;
import org.gvsig.fmap.dal.DALLibrary;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataServerExplorerFactory;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.serverexplorer.wfs.WFSServerExplorerFactory;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.store.wfs.WFSOpenStoreParameters;
import org.gvsig.fmap.dal.store.wfs.WFSStoreProvider;
import org.gvsig.fmap.dal.store.wfs.WFSStoreProviderFactory;
import org.gvsig.fmap.mapcontext.MapContextLibrary;
import org.gvsig.gpe.lib.api.GPELibrary;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.ListBaseException;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;
import org.gvsig.xmlpull.lib.api.XmlPullLibrary;
import org.gvsig.xmlschema.lib.api.XMLSchemaLibrary;

public class WFSLibrary
extends AbstractLibrary {
    public void doRegistration() {
        this.registerAsServiceOf(DALLibrary.class);
        this.require(MapContextLibrary.class);
        this.require(GPELibrary.class);
        this.require(XmlPullLibrary.class);
        this.require(XMLSchemaLibrary.class);
    }

    protected void doInitialize() throws LibraryException {
    }

    protected void doPostInitialize() throws LibraryException {
        WFSOpenStoreParameters.registerParameterClass();
        try {
            WFSStoreProvider.registerMetadataDefinition();
        }
        catch (MetadataException e) {
            throw new LibraryException(((Object)((Object)this)).getClass(), (ListBaseException)e);
        }
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        if (!dataman.getStoreProviders().contains(WFSStoreProvider.NAME)) {
            dataman.registerStoreProviderFactory((DataStoreProviderFactory)new WFSStoreProviderFactory(WFSStoreProvider.NAME, WFSStoreProvider.DESCRIPTION));
        }
        if (!dataman.getExplorerProviders().contains("WFSServerExplorer")) {
            dataman.registerServerExplorerFactory((DataServerExplorerFactory)new WFSServerExplorerFactory());
        }
        ExtensionPointManager extensionPointManager = ToolsLocator.getExtensionPointManager();
        ExtensionPoint extensionPoint = extensionPointManager.add("CatalogDataStoreParameters");
        extensionPoint.append("OGC:WFS", "Data store parameters to load a WFS layer", WFSOpenStoreParameters.class);
        ArrayList exs = new ArrayList();
        if (!exs.isEmpty()) {
            throw new LibraryException(((Object)((Object)this)).getClass(), exs);
        }
    }
}

