/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs;

import java.util.Vector;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.DataTypesManager;

public class WFSFeatureField {
    protected String name;
    private String type;
    private DataType dataType = null;
    private boolean isGeometry = false;
    private boolean isComplex = false;
    private int geometryType = -1;
    private static final DataTypesManager dataTypesManager = ToolsLocator.getDataTypesManager();
    private Vector fields = new Vector();

    public WFSFeatureField() {
        this.dataType = dataTypesManager.get(64);
    }

    public WFSFeatureField(String name, String type, DataType dataType) {
        this.name = name;
        this.type = type;
        if (dataType == null) {
            dataType = dataTypesManager.get(64);
        } else {
            this.dataType = dataType;
            if (dataType.getType() == dataTypesManager.getType("Geometry")) {
                this.isGeometry = true;
            }
        }
    }

    public WFSFeatureField(String name, String type, int geometryType) {
        this.name = name;
        this.type = type;
        this.dataType = dataTypesManager.get(dataTypesManager.getType("Geometry"));
        this.geometryType = geometryType;
        this.isGeometry = true;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isGeometry() {
        return this.isGeometry;
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    public int getGeometryType() {
        return this.geometryType;
    }

    public WFSFeatureField getFieldAt(int index) {
        if (index >= this.fields.size()) {
            return null;
        }
        return (WFSFeatureField)this.fields.get(index);
    }

    public int getFieldSize() {
        return this.fields.size();
    }

    public void addField(String fieldName, String fieldType, DataType dataType) {
        this.isComplex = true;
        this.fields.add(new WFSFeatureField(fieldName, fieldType, dataType));
    }

    public String toString() {
        return this.getName();
    }
}

