/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.ConnectException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.compat.CompatLocator;
import org.gvsig.compat.lang.StringUtils;
import org.gvsig.remoteclient.utils.EncodingXMLParser;
import org.gvsig.remoteclient.utils.Utilities;
import org.gvsig.remoteclient.wfs.WFSProtocolHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

public class WFSProtocolHandlerFactory {
    private static Logger logger = LoggerFactory.getLogger(WFSProtocolHandlerFactory.class);
    public WFSProtocolHandler wFSProtocolHandler;
    private static final StringUtils stringUtils = CompatLocator.getStringUtils();
    private static ArrayList supportedVersions = new ArrayList();

    private static String getDriverVersion(String version, Iterator clients) throws InstantiationException, IllegalAccessException {
        while (clients.hasNext()) {
            String clientVersion = (String)clients.next();
            int ret = version.compareTo(clientVersion);
            if (ret < 0) continue;
            return clientVersion;
        }
        return null;
    }

    public static WFSProtocolHandler negotiate(String host, boolean ignoreCache) throws ConnectException, IOException {
        if (supportedVersions.size() == 0) {
            return null;
        }
        try {
            String highestVersionSupportedByServer = WFSProtocolHandlerFactory.getSuitableWFSVersion(host, "", ignoreCache);
            if (supportedVersions.contains(highestVersionSupportedByServer)) {
                return WFSProtocolHandlerFactory.createVersionDriver(highestVersionSupportedByServer);
            }
            Iterator iVersion = supportedVersions.iterator();
            while (iVersion.hasNext()) {
                String gvSIGVersion = (String)iVersion.next();
                String wfsVersion = WFSProtocolHandlerFactory.getSuitableWFSVersion(host, gvSIGVersion, ignoreCache);
                int res = wfsVersion.compareTo(gvSIGVersion);
                if (res == 0) {
                    return WFSProtocolHandlerFactory.createVersionDriver(gvSIGVersion);
                }
                if (res > 0) {
                    throw new Exception("Server Version too high: " + wfsVersion);
                }
                String lowerVersion = WFSProtocolHandlerFactory.getDriverVersion(wfsVersion, iVersion);
                if (lowerVersion == null) {
                    throw new Exception("Lowest server version is " + wfsVersion);
                }
                if (!lowerVersion.equals(wfsVersion)) continue;
                return WFSProtocolHandlerFactory.createVersionDriver(lowerVersion);
            }
            return null;
        }
        catch (ConnectException conEx) {
            throw conEx;
        }
        catch (IOException ioEx) {
            throw ioEx;
        }
        catch (Exception e) {
            logger.warn("Can't negotiate version for host '" + host + "'.", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSuitableWFSVersion(String host, String _version, boolean ignoreCache) throws ConnectException, IOException {
        String request = WFSProtocolHandler.buildCapabilitiesSuitableVersionRequest(host, _version);
        String version = new String();
        Reader reader = null;
        File file = null;
        try {
            URL url = new URL(request);
            if (ignoreCache) {
                Utilities.removeURL((URL)url);
            }
            file = Utilities.downloadFile((URL)url, (String)"wfs-suitable-version", null);
            reader = new FileReader(file);
            EncodingXMLParser kxmlParser = new EncodingXMLParser();
            kxmlParser.setInput(reader);
            kxmlParser.nextTag();
            if (kxmlParser.getEventType() != 1) {
                String tag = kxmlParser.getName();
                if (stringUtils.split(tag, ":").length == 2) {
                    tag = stringUtils.split(tag, ":")[1];
                }
                if (tag.compareTo("WFS_Capabilities") == 0) {
                    version = kxmlParser.getAttributeValue("", "version");
                }
            }
            reader.close();
            String string = version;
            return string;
        }
        catch (ConnectException conEx) {
            throw new ConnectException(conEx.getMessage());
        }
        catch (IOException ioEx) {
            throw new IOException(ioEx.getMessage());
        }
        catch (XmlPullParserException xmlEx) {
            String fname = "";
            if (file != null) {
                fname = file.getAbsolutePath();
            }
            logger.warn("Can't get suitable WFS version for host '" + host + "' from file '" + fname + "'.", (Throwable)xmlEx);
            String string = "";
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ex) {
                    logger.warn("Can't close reader.", (Throwable)ex);
                }
            }
        }
    }

    public static List getRequestableVersions(String host, boolean ignoreCache) throws ConnectException, IOException {
        Iterator iVersion = supportedVersions.iterator();
        ArrayList<String> resp = new ArrayList<String>();
        while (iVersion.hasNext()) {
            String wfsVersion;
            String gvSIGVersion = (String)iVersion.next();
            if (gvSIGVersion.compareTo(wfsVersion = WFSProtocolHandlerFactory.getSuitableWFSVersion(host, gvSIGVersion, ignoreCache)) != 0) continue;
            resp.add(gvSIGVersion);
        }
        return resp;
    }

    public static WFSProtocolHandler createVersionDriver(String version) {
        try {
            version = version.replace('.', '_');
            Class<?> driver = Class.forName("org.gvsig.remoteclient.wfs.wfs_" + version + ".WFSProtocolHandler" + version);
            return (WFSProtocolHandler)((Object)driver.newInstance());
        }
        catch (Exception e) {
            logger.warn("Can't create driver for WFS version '" + version + "'.", (Throwable)e);
            return null;
        }
    }

    static {
        supportedVersions.add("1.1.0");
        supportedVersions.add("1.0.0");
    }
}

