/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs.filters;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.remoteclient.wfs.filters.BinaryTree;
import org.gvsig.remoteclient.wfs.filters.Filter;
import org.gvsig.remoteclient.wfs.filters.ISQLExpressionFormat;
import org.gvsig.remoteclient.wfs.filters.ParseExpressions;
import org.gvsig.remoteclient.wfs.filters.operations.WFSEnvelopeFilterOperation;
import org.gvsig.remoteclient.wfs.filters.operations.WFSGeometryFilterOperation;
import org.gvsig.remoteclient.wfs.filters.operations.WFSSpatialFilterOperation;

public abstract class AbstractFilter
implements Filter {
    private BinaryTree root = new BinaryTree();
    private String currentClause;
    private ISQLExpressionFormat formatter;
    private ArrayList spatialFilterOperations;
    private ArrayList ids = null;

    public AbstractFilter(ISQLExpressionFormat formatter) {
        this.formatter = formatter;
        this.spatialFilterOperations = new ArrayList();
    }

    public abstract String toString(BinaryTree var1, String var2);

    public abstract String getLogicalOperator(int var1);

    public abstract String getRelationalOperator(int var1);

    public abstract String getGeometricOperator(int var1);

    public abstract String getSeparator(int var1);

    public void addFeatureById(Object id) {
        if (this.ids == null) {
            this.ids = new ArrayList();
        }
        this.ids.add(id);
    }

    protected ArrayList getIds() {
        return this.ids;
    }

    public void setQueryByAttribute(String query) {
        if (query != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(query.getBytes());
            String sql = this.formatter.format(query);
            if (sql != null) {
                ParseExpressions expressions = new ParseExpressions();
                ArrayList tokens = expressions.parseExpression(sql);
                for (int i = 0; i < tokens.size(); ++i) {
                    String token = (String)tokens.get(i);
                    this.root.addTerm(token);
                }
            }
        }
    }

    public void addAndClause(String propertyName, String propertyValue) {
        this.root.addTerm(propertyName + " = " + propertyValue, this.getLogicalOperator(10));
    }

    public int getSpatialFiltersCount() {
        return this.spatialFilterOperations.size();
    }

    public WFSSpatialFilterOperation getSpatialFilterAt(int index) {
        if (index < this.spatialFilterOperations.size()) {
            return (WFSSpatialFilterOperation)this.spatialFilterOperations.get(index);
        }
        return null;
    }

    public void clearSpatialFilters() {
        this.spatialFilterOperations.clear();
    }

    public void addSpatialFilter(WFSSpatialFilterOperation spatialOperation) {
        if (spatialOperation != null) {
            this.spatialFilterOperations.add(spatialOperation);
        }
    }

    public void addSpatialFilter(Geometry geometry, String attributeName, String nameSpacePrefix, String nameSpaceLocation, String srs, int operation) {
        this.addSpatialFilter(new WFSGeometryFilterOperation(geometry, operation, attributeName, nameSpacePrefix, nameSpaceLocation, srs));
    }

    public void addSpatialFilter(String version, Envelope envelope, String attributeName, String nameSpacePrefix, String nameSpaceLocation, String srs, int operation) {
        this.addSpatialFilter(new WFSEnvelopeFilterOperation(envelope, operation, attributeName, nameSpacePrefix, nameSpaceLocation, srs));
    }

    public void addClause(String value) {
        if (this.currentClause == null) {
            this.currentClause = new String("");
        }
        this.currentClause = this.currentClause + value;
    }

    public String toString(String version) {
        if (this.currentClause != null) {
            this.setQueryByAttribute(this.currentClause);
        }
        return this.toString(this.root, version);
    }

    public String getOperator(int operator) {
        if (this.isLogical(operator)) {
            return this.getLogicalOperator(operator);
        }
        if (this.isRelational(operator)) {
            return this.getRelationalOperator(operator);
        }
        if (this.isGeometric(operator)) {
            return this.getGeometricOperator(operator);
        }
        return String.valueOf(operator);
    }

    public int getRelationalOperator(String operator) {
        if (operator.equals("=")) {
            return 40;
        }
        if (operator.equals("!=")) {
            return 41;
        }
        if (operator.equals("<>")) {
            return 41;
        }
        if (operator.equals(">")) {
            return 43;
        }
        if (operator.equals(">=")) {
            return 45;
        }
        if (operator.equals("<")) {
            return 42;
        }
        if (operator.equals("<=")) {
            return 44;
        }
        if (operator.toUpperCase().equals("LIKE")) {
            return 46;
        }
        return 40;
    }

    public int getLogicalOperator(String operator) {
        if (operator.toUpperCase().equals("AND")) {
            return 10;
        }
        if (operator.toUpperCase().equals("NOT")) {
            return 12;
        }
        if (operator.toUpperCase().equals("OR")) {
            return 11;
        }
        return 10;
    }

    private boolean isGeometric(int type) {
        return type > 19 && type < 40;
    }

    private boolean isRelational(int type) {
        return type > 39 && type < 60;
    }

    private boolean isLogical(int type) {
        return type > 9 && type < 20;
    }

    private boolean isSeparator(int type) {
        return type > 59 && type < 70;
    }

    public Iterator parseValues(String line, int option) {
        Vector<String> values = new Vector<String>();
        if (option == 0) {
            values.add(line);
            return values.iterator();
        }
        StringTokenizer doubleQuotesTokenizer = new StringTokenizer(line, "\"", true);
        boolean inside = false;
        while (doubleQuotesTokenizer.hasMoreTokens()) {
            String token = doubleQuotesTokenizer.nextToken();
            if (token.equals("\"")) {
                inside = !inside;
                continue;
            }
            if (inside) {
                values.add(token);
                continue;
            }
            StringTokenizer spaceTokenizer = new StringTokenizer(token, " ");
            while (spaceTokenizer.hasMoreTokens()) {
                String value = spaceTokenizer.nextToken();
                values.add(value);
            }
        }
        return values.iterator();
    }
}

