/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs.filters;

import java.util.ArrayList;

public class ParseExpressions {
    public ArrayList parseExpression(String expression) {
        ArrayList<String> expressions = new ArrayList<String>();
        char[] chars = expression.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '(') {
                expressions.add("(");
                ++i;
                continue;
            }
            if (chars[i] == ')') {
                expressions.add(")");
                ++i;
                continue;
            }
            if (chars[i] == ' ') {
                ++i;
                continue;
            }
            int desp = this.getShift(chars, i);
            expressions.add(expression.substring(i, i + desp));
            i += desp;
        }
        return expressions;
    }

    private int getShift(char[] chars, int position) {
        int shift = 0;
        shift = this.isAndOperator(chars, position);
        if (shift == 0 && (shift = this.isOrOperator(chars, position)) == 0 && (shift = this.isNotOperator(chars, position)) == 0) {
            shift = this.isExpression(chars, position);
        }
        return shift;
    }

    private int isExpression(char[] chars, int position) {
        int desp = 0;
        for (int i = position; i < chars.length && chars[i] != ')'; ++i) {
            ++desp;
        }
        return desp;
    }

    private int isAndOperator(char[] chars, int position) {
        if (chars[position] == 'A' && chars[position + 1] == 'N' && chars[position + 2] == 'D' && chars[position + 3] == ' ') {
            return 3;
        }
        return 0;
    }

    private int isOrOperator(char[] chars, int position) {
        if (chars[position] == 'O' && chars[position + 1] == 'R' && chars[position + 2] == ' ') {
            return 2;
        }
        return 0;
    }

    private int isNotOperator(char[] chars, int position) {
        if (chars[position] == 'N' && chars[position + 1] == 'O' && chars[position + 2] == 'T' && chars[position + 3] == ' ') {
            return 3;
        }
        return 0;
    }
}

