/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs.request;

import org.gvsig.remoteclient.wfs.WFSProtocolHandler;
import org.gvsig.remoteclient.wfs.WFSRequestInformation;
import org.gvsig.remoteclient.wfs.WFSStatus;
import org.gvsig.remoteclient.wfs.filters.filterencoding.FilterEncoding;
import org.gvsig.remoteclient.wfs.request.WFSGetFeatureRequestInformation;
import org.gvsig.remoteclient.wfs.request.WFSRequest;

public abstract class WFSGetFeatureRequest
extends WFSRequest {
    public WFSGetFeatureRequest(WFSStatus status, WFSProtocolHandler protocolHandler) {
        super(status, protocolHandler);
    }

    protected String getHttpPostRequest(String onlineResource) {
        StringBuffer request = new StringBuffer();
        request.append("<?xml version=\"1.0\" ?>");
        request.append("<wfs:");
        request.append("GetFeature ");
        request.append("version=\"" + this.protocolHandler.getVersion() + "\" ");
        request.append("service=\"WFS\" ");
        if (this.status.getMaxFeatures().longValue() > 0L) {
            request.append("maxFeatures=\"" + this.status.getMaxFeatures() + "\" ");
        }
        if (this.status.getResultType() == 1) {
            request.append("resultType=\"hits\" ");
        }
        request.append("xmlns:ogc");
        request.append("=\"http://www.opengis.net/ogc\" ");
        request.append("xmlns:wfs");
        request.append("=\"http://www.opengis.net/wfs\" ");
        request.append("xmlns:xsi");
        request.append("=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        request.append("xmlns:gml");
        request.append("=\"http://www.opengis.net/gml\" ");
        request.append("xmlns:" + this.status.getNamespacePrefix());
        request.append("=\"" + this.status.getNamespaceLocation() + "\" ");
        request.append("xsi:schemaLocation");
        request.append("=\"http://www.opengis.net/wfs ");
        request.append(this.getSchemaLocation());
        request.append("\">");
        request.append("<wfs:");
        request.append("Query");
        request.append(" typeName=\"" + this.status.getFeatureFullName() + "\"");
        request.append(">");
        if (this.status.getFilterByAttribute() != null || this.status.getFilterByArea() != null) {
            FilterEncoding filterEncoding = new FilterEncoding(this.status);
            request.append(filterEncoding.toString(this.protocolHandler.getVersion()));
        }
        request.append("</wfs:");
        request.append("Query");
        request.append(">");
        request.append("</wfs:");
        request.append("GetFeature>");
        return request.toString();
    }

    protected String getOperationName() {
        return "GetFeature";
    }

    protected String getSchemaLocation() {
        return null;
    }

    protected String getTempFilePrefix() {
        return "wfs_getFeature.gml";
    }

    @Override
    public WFSRequestInformation createRequestInformation() {
        return new WFSGetFeatureRequestInformation();
    }
}

