/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.remoteclient.wfs.schema;

import java.io.IOException;
import org.gvsig.compat.CompatLocator;
import org.gvsig.remoteclient.utils.EncodingXMLParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLSchemaParser
extends EncodingXMLParser {
    private String targetNameSpace = null;
    private String schema = "";
    private String encoding = "UTF-8";
    private String nameSpace = "";
    private String version = null;

    public XMLSchemaParser() {
    }

    public XMLSchemaParser(String schema) {
        this.schema = schema;
    }

    public void setSchemaFromMainTag(String tag) {
        int pos = tag.indexOf(":");
        this.schema = pos > 0 ? tag.substring(0, pos) : "";
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    private String getTag(String tag) {
        if (tag == null) {
            return null;
        }
        if (this.schema == null || this.schema.equals("")) {
            return tag;
        }
        return this.schema + ":" + tag;
    }

    public void require(int type, String namespace, String name) throws XmlPullParserException, IOException {
        super.require(type, namespace, this.getTag(name));
    }

    public String getName() {
        try {
            String name = super.getName();
            if (this.schema != null || !this.schema.equals("")) {
                return name.substring(name.indexOf(":") + 1, name.length());
            }
            return name;
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public String getNameSpace() {
        try {
            String name = super.getName();
            if (name != null && CompatLocator.getStringUtils().split(name, ":").length > 1) {
                return CompatLocator.getStringUtils().split(name, ":")[0];
            }
            return "";
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    public String getversion() {
        if (this.version == null) {
            return "99.99.99";
        }
        return this.version;
    }

    public String getTargetNamespace() {
        return this.targetNameSpace;
    }
}

